/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.spi.connector.SortOrder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestTopNStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testTopNWithLongInput() {
        this.tester().assertStatsFor(pb -> pb.topN(10L, (List<Symbol>)ImmutableList.of((Object)pb.symbol("i1")), (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol("i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).build()).check(check -> check.outputRowsCount(10.0).symbolStats("i1", assertion -> assertion.lowValue(1.0).highValue(10.0).distinctValuesCount(5.0).dataSizeUnknown().nullsFraction(0.0)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.0)));
        this.tester().assertStatsFor(pb -> pb.topN(10L, (List<Symbol>)ImmutableList.of((Object)pb.symbol("i1")), TopNNode.Step.PARTIAL, (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol("i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).build()).check(check -> check.outputRowsCount(Double.NaN).symbolStats("i1", assertion -> assertion.lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY).distinctValuesCount(Double.NaN).dataSizeUnknown().nullsFraction(Double.NaN)).symbolStats("i2", assertion -> assertion.lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY).dataSizeUnknown().distinctValuesCount(Double.NaN).nullsFraction(Double.NaN)));
    }

    @Test
    public void testTopNWithSmallInput() {
        this.tester().assertStatsFor(pb -> pb.topN(1000L, (List<Symbol>)ImmutableList.of((Object)pb.symbol("i1")), (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol("i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol("i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).build()).check(check -> check.outputRowsCount(100.0).symbolStats("i1", assertion -> assertion.lowValue(1.0).highValue(10.0).distinctValuesCount(5.0).dataSizeUnknown().nullsFraction(0.0)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.0)));
    }

    @Test
    public void testTopNWithNulls() {
        this.tester().assertStatsFor(pb -> pb.topN(10L, (List<Symbol>)ImmutableList.of((Object)pb.symbol("i1")), TopNNode.Step.SINGLE, SortOrder.ASC_NULLS_LAST, (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol("i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.3).build()).addSymbolStatistics(new Symbol("i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.5).build()).build()).check(check -> check.outputRowsCount(10.0).symbolStats("i1", assertion -> assertion.lowValue(1.0).highValue(10.0).distinctValuesCount(5.0).dataSizeUnknown().nullsFraction(0.0)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.5)));
        this.tester().assertStatsFor(pb -> pb.topN(50L, (List<Symbol>)ImmutableList.of((Object)pb.symbol("i1")), TopNNode.Step.SINGLE, SortOrder.ASC_NULLS_LAST, (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol("i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.6).build()).addSymbolStatistics(new Symbol("i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.5).build()).build()).check(check -> check.outputRowsCount(50.0).symbolStats("i1", assertion -> assertion.lowValue(1.0).highValue(10.0).distinctValuesCount(5.0).dataSizeUnknown().nullsFraction(0.2)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.5)));
        this.tester().assertStatsFor(pb -> pb.topN(50L, (List<Symbol>)ImmutableList.of((Object)pb.symbol("i1")), (PlanNode)pb.values(pb.symbol("i1"), pb.symbol("i2")))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol("i1"), SymbolStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.6).build()).addSymbolStatistics(new Symbol("i2"), SymbolStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.5).build()).build()).check(check -> check.outputRowsCount(50.0).symbolStats("i1", assertion -> assertion.lowValue(1.0).highValue(10.0).distinctValuesCount(2.5).dataSizeUnknown().nullsFraction(0.95)).symbolStats("i2", assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.5)));
    }
}

