/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableSchema;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.Identity;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.TestingConnectorTransactionHandle;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public abstract class BaseDataDefinitionTaskTest {
    protected static final String CATALOG_NAME = "catalog";
    public static final String SCHEMA = "schema";
    protected Session testSession;
    protected MockMetadata metadata;
    protected PlannerContext plannerContext;
    protected TransactionManager transactionManager;
    protected QueryStateMachine queryStateMachine;

    @BeforeMethod
    public void setUp() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        Catalog testCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        catalogManager.registerCatalog(testCatalog);
        this.testSession = TestingSession.testSessionBuilder().setTransactionId(this.transactionManager.beginTransaction(false)).build();
        this.metadata = new MockMetadata(testCatalog.getConnectorCatalogName());
        this.plannerContext = TestingPlannerContext.plannerContextBuilder().withMetadata(this.metadata).build();
        this.queryStateMachine = BaseDataDefinitionTaskTest.stateMachine(this.transactionManager, MetadataManager.createTestMetadataManager(), (AccessControl)new AllowAllAccessControl(), this.testSession);
    }

    protected static QualifiedObjectName qualifiedObjectName(String objectName) {
        return new QualifiedObjectName(CATALOG_NAME, SCHEMA, objectName);
    }

    protected static QualifiedName qualifiedName(String name) {
        return QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{SCHEMA, name});
    }

    protected static QualifiedObjectName asQualifiedObjectName(QualifiedName viewName) {
        return QualifiedObjectName.valueOf((String)viewName.toString());
    }

    protected static QualifiedName asQualifiedName(QualifiedObjectName qualifiedObjectName) {
        return QualifiedName.of((String)qualifiedObjectName.getCatalogName(), (String[])new String[]{qualifiedObjectName.getSchemaName(), qualifiedObjectName.getObjectName()});
    }

    protected MaterializedViewDefinition someMaterializedView() {
        return this.someMaterializedView("select * from some_table", (List<ViewColumn>)ImmutableList.of((Object)new ViewColumn("test", BigintType.BIGINT.getTypeId())));
    }

    protected MaterializedViewDefinition someMaterializedView(String sql, List<ViewColumn> columns) {
        return new MaterializedViewDefinition(sql, Optional.empty(), Optional.empty(), columns, Optional.empty(), Identity.ofUser((String)"owner"), Optional.empty(), (Map)ImmutableMap.of());
    }

    protected static ConnectorTableMetadata someTable(QualifiedObjectName tableName) {
        return new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.of((Object)new ColumnMetadata("test", (Type)BigintType.BIGINT)));
    }

    protected static ViewDefinition someView() {
        return BaseDataDefinitionTaskTest.viewDefinition("SELECT 1", (ImmutableList<ViewColumn>)ImmutableList.of((Object)new ViewColumn("test", BigintType.BIGINT.getTypeId())));
    }

    protected static ViewDefinition viewDefinition(String sql, ImmutableList<ViewColumn> columns) {
        return new ViewDefinition(sql, Optional.empty(), Optional.empty(), columns, Optional.empty(), Optional.empty());
    }

    private static QueryStateMachine stateMachine(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl, Session session) {
        return QueryStateMachine.begin((String)"test", Optional.empty(), (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)MoreExecutors.directExecutor(), (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
    }

    protected static class MockMetadata
    extends AbstractMockMetadata {
        private final CatalogName catalogHandle;
        private final List<CatalogSchemaName> schemas = new CopyOnWriteArrayList<CatalogSchemaName>();
        private final AtomicBoolean failCreateSchema = new AtomicBoolean();
        private final Map<SchemaTableName, ConnectorTableMetadata> tables = new ConcurrentHashMap<SchemaTableName, ConnectorTableMetadata>();
        private final Map<SchemaTableName, ViewDefinition> views = new ConcurrentHashMap<SchemaTableName, ViewDefinition>();
        private final Map<SchemaTableName, MaterializedViewDefinition> materializedViews = new ConcurrentHashMap<SchemaTableName, MaterializedViewDefinition>();

        public MockMetadata(CatalogName catalogHandle) {
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        }

        @Override
        public Optional<CatalogName> getCatalogHandle(Session session, String catalogName) {
            if (this.catalogHandle.getCatalogName().equals(catalogName)) {
                return Optional.of(this.catalogHandle);
            }
            return Optional.empty();
        }

        public void failCreateSchema() {
            this.failCreateSchema.set(true);
        }

        @Override
        public boolean schemaExists(Session session, CatalogSchemaName schema) {
            return this.schemas.contains(schema);
        }

        @Override
        public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, TrinoPrincipal principal) {
            if (this.failCreateSchema.get()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "TEST create schema fail: " + schema);
            }
            if (this.schemas.contains(schema)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Schema already exists");
            }
            this.schemas.add(schema);
        }

        @Override
        public TableSchema getTableSchema(Session session, TableHandle tableHandle) {
            return new TableSchema(tableHandle.getCatalogName(), this.getTableMetadata(tableHandle).getTableSchema());
        }

        @Override
        public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
            return Optional.ofNullable(this.tables.get(tableName.asSchemaTableName())).map(tableMetadata -> new TableHandle(new CatalogName(BaseDataDefinitionTaskTest.CATALOG_NAME), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(tableName.asSchemaTableName()), (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, Optional.empty()));
        }

        @Override
        public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
            return new TableMetadata(new CatalogName(BaseDataDefinitionTaskTest.CATALOG_NAME), this.getTableMetadata(tableHandle));
        }

        @Override
        public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
            Preconditions.checkArgument((ignoreExisting || !this.tables.containsKey(tableMetadata.getTable()) ? 1 : 0) != 0);
            this.tables.put(tableMetadata.getTable(), tableMetadata);
        }

        @Override
        public void dropTable(Session session, TableHandle tableHandle) {
            this.tables.remove(this.getTableName(tableHandle));
        }

        @Override
        public void renameTable(Session session, TableHandle tableHandle, QualifiedObjectName newTableName) {
            SchemaTableName oldTableName = this.getTableName(tableHandle);
            this.tables.put(newTableName.asSchemaTableName(), (ConnectorTableMetadata)Verify.verifyNotNull((Object)this.tables.get(oldTableName), (String)"Table not found %s", (Object[])new Object[]{oldTableName}));
            this.tables.remove(oldTableName);
        }

        private ConnectorTableMetadata getTableMetadata(TableHandle tableHandle) {
            return this.tables.get(this.getTableName(tableHandle));
        }

        private SchemaTableName getTableName(TableHandle tableHandle) {
            return ((TestingMetadata.TestingTableHandle)tableHandle.getConnectorHandle()).getTableName();
        }

        @Override
        public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
            return (Map)this.getTableMetadata(tableHandle).getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new TestingColumnHandle(column.getName())));
        }

        @Override
        public Optional<MaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
            return Optional.ofNullable(this.materializedViews.get(viewName.asSchemaTableName()));
        }

        @Override
        public void createMaterializedView(Session session, QualifiedObjectName viewName, MaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
            Preconditions.checkArgument((ignoreExisting || !this.materializedViews.containsKey(viewName.asSchemaTableName()) ? 1 : 0) != 0);
            this.materializedViews.put(viewName.asSchemaTableName(), definition);
        }

        @Override
        public void dropMaterializedView(Session session, QualifiedObjectName viewName) {
            this.materializedViews.remove(viewName.asSchemaTableName());
        }

        @Override
        public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
            return Optional.ofNullable(this.views.get(viewName.asSchemaTableName()));
        }

        @Override
        public void createView(Session session, QualifiedObjectName viewName, ViewDefinition definition, boolean replace) {
            Preconditions.checkArgument((replace || !this.views.containsKey(viewName.asSchemaTableName()) ? 1 : 0) != 0);
            this.views.put(viewName.asSchemaTableName(), definition);
        }

        @Override
        public void dropView(Session session, QualifiedObjectName viewName) {
            this.views.remove(viewName.asSchemaTableName());
        }

        @Override
        public void renameView(Session session, QualifiedObjectName source, QualifiedObjectName target) {
            SchemaTableName oldViewName = source.asSchemaTableName();
            this.views.put(target.asSchemaTableName(), (ViewDefinition)Verify.verifyNotNull((Object)this.views.get(oldViewName), (String)"View not found %s", (Object[])new Object[]{oldViewName}));
            this.views.remove(oldViewName);
        }

        @Override
        public void renameMaterializedView(Session session, QualifiedObjectName source, QualifiedObjectName target) {
            SchemaTableName oldViewName = source.asSchemaTableName();
            this.materializedViews.put(target.asSchemaTableName(), (MaterializedViewDefinition)Verify.verifyNotNull((Object)this.materializedViews.get(oldViewName), (String)"Materialized View not found %s", (Object[])new Object[]{oldViewName}));
            this.materializedViews.remove(oldViewName);
        }
    }
}

