/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.trino.connector.CatalogName;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.CreateSchemaTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.SchemaPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.QualifiedName;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateSchemaTask
extends BaseDataDefinitionTaskTest {
    private static final CatalogSchemaName CATALOG_SCHEMA_NAME = new CatalogSchemaName("catalog", "test_db");

    @Test
    public void testDuplicatedCreateSchema() {
        CreateSchemaTask task = this.getCreateSchemaTask();
        CreateSchema statement = new CreateSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), false, (List)ImmutableList.of());
        MoreFutures.getFutureValue((Future)task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertTrue((boolean)this.metadata.schemaExists(this.testSession, CATALOG_SCHEMA_NAME));
        Assertions.assertThatExceptionOfType(TrinoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).withMessage("Schema 'catalog.test_db' already exists");
    }

    @Test
    public void testDuplicatedCreateSchemaIfNotExists() {
        CreateSchemaTask task = this.getCreateSchemaTask();
        CreateSchema statement = new CreateSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), true, (List)ImmutableList.of());
        MoreFutures.getFutureValue((Future)task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertTrue((boolean)this.metadata.schemaExists(this.testSession, CATALOG_SCHEMA_NAME));
        MoreFutures.getFutureValue((Future)task.execute(statement, this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertTrue((boolean)this.metadata.schemaExists(this.testSession, CATALOG_SCHEMA_NAME));
    }

    @Test
    public void failCreateSchema() {
        CreateSchemaTask task = this.getCreateSchemaTask();
        this.metadata.failCreateSchema();
        Assertions.assertThatExceptionOfType(TrinoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)task.execute(new CreateSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), false, (List)ImmutableList.of()), this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).withMessage("TEST create schema fail: catalog.test_db");
        Assertions.assertThatExceptionOfType(TrinoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)task.execute(new CreateSchema(QualifiedName.of((String)CATALOG_SCHEMA_NAME.getSchemaName()), true, (List)ImmutableList.of()), this.queryStateMachine, Collections.emptyList(), WarningCollector.NOOP))).withMessage("TEST create schema fail: catalog.test_db");
    }

    private CreateSchemaTask getCreateSchemaTask() {
        SchemaPropertyManager schemaPropertyManager = new SchemaPropertyManager();
        schemaPropertyManager.addProperties(new CatalogName("catalog"), (List)ImmutableList.of());
        return new CreateSchemaTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), schemaPropertyManager);
    }
}

