/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.CreateViewTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.sql.PlannerContext;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateViewTask
extends BaseDataDefinitionTaskTest {
    private static final String CATALOG_NAME = "catalog";
    private SqlParser parser;
    private AnalyzerFactory analyzerFactory;

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.parser = new SqlParser();
        this.analyzerFactory = new AnalyzerFactory(StatementAnalyzerFactory.createTestingStatementAnalyzerFactory((PlannerContext)this.plannerContext, (AccessControl)new AllowAllAccessControl(), (TablePropertyManager)new TablePropertyManager(), (AnalyzePropertyManager)new AnalyzePropertyManager()), new StatementRewrite((Set)ImmutableSet.of()));
        QualifiedObjectName tableName = TestCreateViewTask.qualifiedObjectName("mock_table");
        this.metadata.createTable(this.testSession, CATALOG_NAME, TestCreateViewTask.someTable(tableName), false);
    }

    @Test
    public void testCreateViewOnViewIfNotExists() {
        QualifiedObjectName viewName = TestCreateViewTask.qualifiedObjectName("new_view");
        MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(viewName), false));
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, viewName)).isTrue();
    }

    @Test
    public void testCreateViewOnViewIfExists() {
        QualifiedObjectName viewName = TestCreateViewTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestCreateViewTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(viewName), false))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS).hasMessage("View already exists: '%s'", new Object[]{viewName});
    }

    @Test
    public void testReplaceViewOnViewIfExists() {
        QualifiedObjectName viewName = TestCreateViewTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestCreateViewTask.someView(), false);
        MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(viewName), true));
        Assertions.assertThat((boolean)this.metadata.isView(this.testSession, viewName)).isTrue();
    }

    @Test
    public void testCreateViewOnTableIfExists() {
        QualifiedObjectName tableName = TestCreateViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, CATALOG_NAME, TestCreateViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(tableName), false))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS).hasMessage("Table already exists: '%s'", new Object[]{tableName, tableName});
    }

    @Test
    public void testReplaceViewOnTableIfExists() {
        QualifiedObjectName tableName = TestCreateViewTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, CATALOG_NAME, TestCreateViewTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(tableName), true))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS).hasMessage("Table already exists: '%s'", new Object[]{tableName, tableName});
    }

    @Test
    public void testCreateViewOnMaterializedView() {
        QualifiedObjectName viewName = TestCreateViewTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, viewName, this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeCreateView(TestCreateViewTask.asQualifiedName(viewName), false))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS).hasMessage("Materialized view already exists: '%s'", new Object[]{viewName});
    }

    private QueryStateMachine stateMachine(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl) {
        return QueryStateMachine.begin((String)"test", Optional.empty(), (Session)this.testSession, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)MoreExecutors.directExecutor(), (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
    }

    private ListenableFuture<Void> executeCreateView(QualifiedName viewName, boolean replace) {
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"mock_table")));
        CreateView statement = new CreateView(viewName, query, replace, Optional.empty(), Optional.empty());
        return new CreateViewTask((Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.parser, this.analyzerFactory).execute(statement, this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

