/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.execution.FailureInjectionConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestFailureInjectionConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FailureInjectionConfig)ConfigAssertions.recordDefaults(FailureInjectionConfig.class)).setRequestTimeout(new Duration(2.0, TimeUnit.MINUTES)).setExpirationPeriod(new Duration(10.0, TimeUnit.MINUTES)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"failure-injection.request-timeout", (Object)"12m").put((Object)"failure-injection.expiration-period", (Object)"7m").build();
        FailureInjectionConfig expected = new FailureInjectionConfig().setRequestTimeout(new Duration(12.0, TimeUnit.MINUTES)).setExpirationPeriod(new Duration(7.0, TimeUnit.MINUTES));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

