/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestNodeSchedulerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((NodeSchedulerConfig)ConfigAssertions.recordDefaults(NodeSchedulerConfig.class)).setNodeSchedulerPolicy(NodeSchedulerConfig.NodeSchedulerPolicy.UNIFORM.name()).setMinCandidates(10).setMaxSplitsPerNode(100).setMaxPendingSplitsPerTask(10).setMaxUnacknowledgedSplitsPerTask(500).setIncludeCoordinator(true).setOptimizedLocalScheduling(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"node-scheduler.policy", (Object)"topology").put((Object)"node-scheduler.min-candidates", (Object)"11").put((Object)"node-scheduler.include-coordinator", (Object)"false").put((Object)"node-scheduler.max-pending-splits-per-task", (Object)"11").put((Object)"node-scheduler.max-splits-per-node", (Object)"101").put((Object)"node-scheduler.max-unacknowledged-splits-per-task", (Object)"501").put((Object)"node-scheduler.optimized-local-scheduling", (Object)"false").build();
        NodeSchedulerConfig expected = new NodeSchedulerConfig().setNodeSchedulerPolicy("topology").setIncludeCoordinator(false).setMaxSplitsPerNode(101).setMaxPendingSplitsPerTask(11).setMaxUnacknowledgedSplitsPerTask(501).setMinCandidates(11).setOptimizedLocalScheduling(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

