/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.execution.warnings.DefaultWarningCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.execution.warnings.WarningCollectorConfig;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCode;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPlannerWarnings {
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void setUp() {
        this.queryRunner = LocalQueryRunner.create((Session)TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").build());
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.queryRunner.close();
    }

    @Test
    public void testWarning() {
        List<TrinoWarning> warnings = TestPlannerWarnings.createTestWarnings(3);
        List warningCodes = (List)warnings.stream().map(TrinoWarning::getWarningCode).collect(ImmutableList.toImmutableList());
        TestPlannerWarnings.assertPlannerWarnings(this.queryRunner, "SELECT * FROM NATION", (Map<String, String>)ImmutableMap.of(), warningCodes, Optional.of(ImmutableList.of((Object)new TestWarningsRule(warnings))));
    }

    public static void assertPlannerWarnings(LocalQueryRunner queryRunner, @Language(value="SQL") String sql, Map<String, String> sessionProperties, List<WarningCode> expectedWarnings, Optional<List<Rule<?>>> rules) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog(queryRunner.getDefaultSession().getCatalog()).setSchema(queryRunner.getDefaultSession().getSchema());
        sessionProperties.forEach((arg_0, arg_1) -> ((Session.SessionBuilder)sessionBuilder).setSystemProperty(arg_0, arg_1));
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig());
        try {
            queryRunner.inTransaction(sessionBuilder.build(), arg_0 -> TestPlannerWarnings.lambda$assertPlannerWarnings$0(rules, queryRunner, sql, (WarningCollector)warningCollector, arg_0));
        }
        catch (TrinoException trinoException) {
            // empty catch block
        }
        Set warnings = (Set)warningCollector.getWarnings().stream().map(TrinoWarning::getWarningCode).collect(ImmutableSet.toImmutableSet());
        for (WarningCode expectedWarning : expectedWarnings) {
            if (warnings.contains(expectedWarning)) continue;
            Assert.fail((String)("Expected warning: " + expectedWarning));
        }
    }

    private static Plan createPlan(LocalQueryRunner queryRunner, Session session, String sql, WarningCollector warningCollector, List<Rule<?>> rules) {
        IterativeOptimizer optimizer = new IterativeOptimizer(queryRunner.getMetadata(), new RuleStatsRecorder(), queryRunner.getStatsCalculator(), queryRunner.getCostCalculator(), (Set)ImmutableSet.copyOf(rules));
        return queryRunner.createPlan(session, sql, (List)ImmutableList.of((Object)optimizer), LogicalPlanner.Stage.OPTIMIZED, warningCollector);
    }

    public static List<TrinoWarning> createTestWarnings(int numberOfWarnings) {
        Preconditions.checkArgument((numberOfWarnings > 0 ? 1 : 0) != 0, (Object)"numberOfWarnings must be > 0");
        ImmutableList.Builder builder = ImmutableList.builder();
        IntStream.range(1, numberOfWarnings).mapToObj(code -> new TrinoWarning(new WarningCode(code, "testWarning"), "Test warning " + code)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private static /* synthetic */ Object lambda$assertPlannerWarnings$0(Optional rules, LocalQueryRunner queryRunner, String sql, WarningCollector warningCollector, Session transactionSession) {
        if (rules.isPresent()) {
            TestPlannerWarnings.createPlan(queryRunner, transactionSession, sql, warningCollector, (List)rules.get());
        } else {
            queryRunner.createPlan(transactionSession, sql, LogicalPlanner.Stage.OPTIMIZED, false, warningCollector);
        }
        return null;
    }

    public static class TestWarningsRule
    implements Rule<ProjectNode> {
        private final List<TrinoWarning> warnings;

        public TestWarningsRule(List<TrinoWarning> warnings) {
            this.warnings = ImmutableList.copyOf((Collection)Objects.requireNonNull(warnings, "warnings is null"));
        }

        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        public Rule.Result apply(ProjectNode node, Captures captures, Rule.Context context) {
            this.warnings.stream().forEach(arg_0 -> ((WarningCollector)context.getWarningCollector()).add(arg_0));
            return Rule.Result.empty();
        }
    }
}

