/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.ResetSessionTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.ResetSession;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestResetSessionTask {
    private static final String CATALOG_NAME = "catalog";
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private final SessionPropertyManager sessionPropertyManager;

    public TestResetSessionTask() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        this.sessionPropertyManager = new SessionPropertyManager();
        this.sessionPropertyManager.addSystemSessionProperty(PropertyMetadata.stringProperty((String)"foo", (String)"test property", null, (boolean)false));
        Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        this.sessionPropertyManager.addConnectorSessionProperties(bogusTestingCatalog.getConnectorCatalogName(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"baz", (String)"test property", null, (boolean)false)));
        catalogManager.registerCatalog(bogusTestingCatalog);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void test() {
        Session session = TestingSession.testSessionBuilder((SessionPropertyManager)this.sessionPropertyManager).setSystemProperty("foo", "bar").setCatalogSessionProperty(CATALOG_NAME, "baz", "blah").build();
        QueryStateMachine stateMachine = QueryStateMachine.begin((String)"reset foo", Optional.empty(), (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
        MoreFutures.getFutureValue((Future)new ResetSessionTask(this.metadata, this.sessionPropertyManager).execute(new ResetSession(QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{"baz"})), stateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Set sessionProperties = stateMachine.getResetSessionProperties();
        Assert.assertEquals((Set)sessionProperties, (Set)ImmutableSet.of((Object)"catalog.baz"));
    }
}

