/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.system.StaticSystemTablesProvider;
import io.trino.connector.system.SystemTablesMetadata;
import io.trino.connector.system.SystemTablesProvider;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.SetRoleTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.SetRole;
import io.trino.testing.TestingConnectorContext;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSetRoleTask {
    private static final String CATALOG_NAME = "foo";
    private static final String SYSTEM_ROLE_CATALOG_NAME = "system_role";
    private static final String USER_NAME = "user";
    private static final String ROLE_NAME = "bar";
    private TransactionManager transactionManager;
    private AccessControl accessControl;
    private Metadata metadata;
    private ExecutorService executor;
    private SqlParser parser;

    @BeforeClass
    public void setUp() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        MockConnectorFactory mockConnectorFactory = MockConnectorFactory.builder().withListRoleGrants((connectorSession, roles, grantees, limit) -> ImmutableSet.of((Object)new RoleGrant(new TrinoPrincipal(PrincipalType.USER, USER_NAME), ROLE_NAME, false))).build();
        Connector testConnector = mockConnectorFactory.create(CATALOG_NAME, (Map<String, String>)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
        CatalogName catalogName = new CatalogName(CATALOG_NAME);
        catalogManager.registerCatalog(new Catalog(CATALOG_NAME, catalogName, "test", testConnector, Catalog.SecurityManagement.CONNECTOR, CatalogName.createInformationSchemaCatalogName((CatalogName)catalogName), testConnector, CatalogName.createSystemTablesCatalogName((CatalogName)catalogName), testConnector));
        CatalogName systemRoleCatalog = new CatalogName(SYSTEM_ROLE_CATALOG_NAME);
        Connector systemRoleConnector = new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
                return new ConnectorTransactionHandle(){};
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return new SystemTablesMetadata((SystemTablesProvider)new StaticSystemTablesProvider((Set)ImmutableSet.of()));
            }
        };
        catalogManager.registerCatalog(new Catalog(SYSTEM_ROLE_CATALOG_NAME, systemRoleCatalog, "test", systemRoleConnector, Catalog.SecurityManagement.SYSTEM, CatalogName.createInformationSchemaCatalogName((CatalogName)systemRoleCatalog), systemRoleConnector, CatalogName.createSystemTablesCatalogName((CatalogName)systemRoleCatalog), systemRoleConnector));
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-set-role-task-executor-%s"));
        this.parser = new SqlParser();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.metadata = null;
        this.accessControl = null;
        this.transactionManager = null;
        this.parser = null;
    }

    @Test
    public void testSetRole() {
        this.assertSetRole("SET ROLE ALL IN foo", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty())));
        this.assertSetRole("SET ROLE NONE IN foo", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty())));
        this.assertSetRole("SET ROLE bar IN foo", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of(ROLE_NAME))));
        this.assertSetRole("SET ROLE ALL", (Map<String, SelectedRole>)ImmutableMap.of((Object)"system", (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty())));
        this.assertSetRole("SET ROLE NONE", (Map<String, SelectedRole>)ImmutableMap.of((Object)"system", (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty())));
    }

    @Test
    public void testSetRoleInvalidRole() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.executeSetRole("SET ROLE unknown IN foo")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND).hasMessage("line 1:1: Role 'unknown' does not exist");
    }

    @Test
    public void testSetRoleInvalidCatalog() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.executeSetRole("SET ROLE foo IN invalid")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND).hasMessage("line 1:1: Catalog 'invalid' does not exist");
    }

    @Test
    public void testSetCatalogRoleInCatalogWithSystemSecurity() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.executeSetRole("SET ROLE foo IN system_role")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessage("line 1:1: Catalog 'system_role' does not support role management");
    }

    private void assertSetRole(String statement, Map<String, SelectedRole> expected) {
        QueryStateMachine stateMachine = this.executeSetRole(statement);
        QueryInfo queryInfo = stateMachine.getQueryInfo(Optional.empty());
        Assert.assertEquals((Map)queryInfo.getSetRoles(), expected);
    }

    private QueryStateMachine executeSetRole(String statement) {
        SetRole setRole = (SetRole)this.parser.createStatement(statement, new ParsingOptions());
        QueryStateMachine stateMachine = QueryStateMachine.begin((String)statement, Optional.empty(), (Session)TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)USER_NAME)).build(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
        new SetRoleTask(this.metadata, this.accessControl).execute(setRole, stateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
        return stateMachine;
    }
}

