/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.SetSessionTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Catalog;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.StringLiteral;
import io.trino.testing.TestingSession;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestSetSessionTask {
    private static final String CATALOG_NAME = "foo";
    private static final String MUST_BE_POSITIVE = "property must be positive";
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private final PlannerContext plannerContext;
    private final SessionPropertyManager sessionPropertyManager;
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    public TestSetSessionTask() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        this.plannerContext = TestingPlannerContext.plannerContextBuilder().withMetadata(this.metadata).build();
        this.sessionPropertyManager = new SessionPropertyManager();
        this.sessionPropertyManager.addSystemSessionProperty(PropertyMetadata.stringProperty((String)CATALOG_NAME, (String)"test property", null, (boolean)false));
        Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        ImmutableList sessionProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"bar", (String)"test property", null, (boolean)false), (Object)PropertyMetadata.integerProperty((String)"positive_property", (String)"property that should be positive", null, TestSetSessionTask::validatePositive, (boolean)false), (Object)PropertyMetadata.enumProperty((String)"size_property", (String)"size enum property", Size.class, null, (boolean)false));
        this.sessionPropertyManager.addConnectorSessionProperties(bogusTestingCatalog.getConnectorCatalogName(), (List)sessionProperties);
        catalogManager.registerCatalog(bogusTestingCatalog);
    }

    private static void validatePositive(Object value) {
        int intValue = ((Number)value).intValue();
        if (intValue < 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, MUST_BE_POSITIVE);
        }
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testSetSession() {
        this.testSetSession("bar", (Expression)new StringLiteral("baz"), "baz");
        this.testSetSession("bar", (Expression)new TestingFunctionResolution(this.transactionManager, this.metadata).functionCallBuilder(QualifiedName.of((String)"concat")).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral("ban")).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral("ana")).build(), "banana");
    }

    @Test
    public void testSetSessionWithValidation() {
        this.testSetSession("positive_property", (Expression)new LongLiteral("0"), "0");
        this.testSetSession("positive_property", (Expression)new LongLiteral("2"), "2");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testSetSession("positive_property", (Expression)new LongLiteral("-1"), "-1")).isInstanceOf(TrinoException.class)).hasMessage(MUST_BE_POSITIVE);
    }

    @Test
    public void testSetSessionWithInvalidEnum() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testSetSession("size_property", (Expression)new StringLiteral("XL"), "XL")).isInstanceOf(TrinoException.class)).hasMessage("Invalid value [XL]. Valid values: [SMALL, MEDIUM, LARGE]").matches(throwable -> ((TrinoException)((Object)throwable)).getErrorCode() == StandardErrorCode.INVALID_SESSION_PROPERTY.toErrorCode());
    }

    @Test
    public void testSetSessionWithParameters() {
        FunctionCall functionCall = new TestingFunctionResolution(this.transactionManager, this.metadata).functionCallBuilder(QualifiedName.of((String)"concat")).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral("ban")).addArgument((Type)VarcharType.VARCHAR, (Expression)new Parameter(0)).build();
        this.testSetSessionWithParameters("bar", (Expression)functionCall, "banana", (List<Expression>)ImmutableList.of((Object)new StringLiteral("ana")));
    }

    private void testSetSession(String property, Expression expression, String expectedValue) {
        this.testSetSessionWithParameters(property, expression, expectedValue, Collections.emptyList());
    }

    private void testSetSessionWithParameters(String property, Expression expression, String expectedValue, List<Expression> parameters) {
        QualifiedName qualifiedPropName = QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{property});
        QueryStateMachine stateMachine = QueryStateMachine.begin((String)String.format("set %s = 'old_value'", qualifiedPropName), Optional.empty(), (Session)SessionTestUtils.TEST_SESSION, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
        MoreFutures.getFutureValue((Future)new SetSessionTask(this.plannerContext, this.accessControl, this.sessionPropertyManager).execute(new SetSession(qualifiedPropName, expression), stateMachine, parameters, WarningCollector.NOOP));
        Map sessionProperties = stateMachine.getSetSessionProperties();
        Assert.assertEquals((Map)sessionProperties, (Map)ImmutableMap.of((Object)qualifiedPropName.toString(), (Object)expectedValue));
    }

    private static enum Size {
        SMALL,
        MEDIUM,
        LARGE;

    }
}

