/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.StartTransactionTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.sql.tree.Isolation;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.TransactionAccessMode;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionInfo;
import io.trino.transaction.TransactionManager;
import io.trino.transaction.TransactionManagerConfig;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestStartTransactionTask {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testNonTransactionalClient() {
        Session session = TestStartTransactionTask.sessionBuilder().build();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new StartTransactionTask(transactionManager).execute(new StartTransaction((List)ImmutableList.of()), stateMachine, Collections.emptyList(), WarningCollector.NOOP))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INCOMPATIBLE_CLIENT);
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
    }

    @Test
    public void testNestedTransaction() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestStartTransactionTask.sessionBuilder().setTransactionId(TransactionId.create()).setClientTransactionSupport().build();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new StartTransactionTask(transactionManager).execute(new StartTransaction((List)ImmutableList.of()), stateMachine, Collections.emptyList(), WarningCollector.NOOP))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED);
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
    }

    @Test
    public void testStartTransaction() {
        Session session = TestStartTransactionTask.sessionBuilder().setClientTransactionSupport().build();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        MoreFutures.getFutureValue((Future)new StartTransactionTask(transactionManager).execute(new StartTransaction((List)ImmutableList.of()), stateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
        TransactionInfo transactionInfo = transactionManager.getTransactionInfo((TransactionId)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().get());
        Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
    }

    @Test
    public void testStartTransactionExplicitModes() {
        Session session = TestStartTransactionTask.sessionBuilder().setClientTransactionSupport().build();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        MoreFutures.getFutureValue((Future)new StartTransactionTask(transactionManager).execute(new StartTransaction((List)ImmutableList.of((Object)new Isolation(Isolation.Level.SERIALIZABLE), (Object)new TransactionAccessMode(true))), stateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
        TransactionInfo transactionInfo = transactionManager.getTransactionInfo((TransactionId)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().get());
        Assert.assertEquals((Object)transactionInfo.getIsolationLevel(), (Object)IsolationLevel.SERIALIZABLE);
        Assert.assertTrue((boolean)transactionInfo.isReadOnly());
        Assert.assertFalse((boolean)transactionInfo.isAutoCommitContext());
    }

    @Test
    public void testStartTransactionTooManyIsolationLevels() {
        Session session = TestStartTransactionTask.sessionBuilder().setClientTransactionSupport().build();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new StartTransactionTask(transactionManager).execute(new StartTransaction((List)ImmutableList.of((Object)new Isolation(Isolation.Level.READ_COMMITTED), (Object)new Isolation(Isolation.Level.READ_COMMITTED))), stateMachine, Collections.emptyList(), WarningCollector.NOOP))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR);
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
    }

    @Test
    public void testStartTransactionTooManyAccessModes() {
        Session session = TestStartTransactionTask.sessionBuilder().setClientTransactionSupport().build();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new StartTransactionTask(transactionManager).execute(new StartTransaction((List)ImmutableList.of((Object)new TransactionAccessMode(true), (Object)new TransactionAccessMode(true))), stateMachine, Collections.emptyList(), WarningCollector.NOOP))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR);
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
    }

    @Test
    public void testStartTransactionIdleExpiration() throws Exception {
        Session session = TestStartTransactionTask.sessionBuilder().setClientTransactionSupport().build();
        TransactionManager transactionManager = InMemoryTransactionManager.create((TransactionManagerConfig)new TransactionManagerConfig().setIdleTimeout(new Duration(1.0, TimeUnit.MICROSECONDS)).setIdleCheckInterval(new Duration(10.0, TimeUnit.MILLISECONDS)), (ScheduledExecutorService)this.scheduledExecutor, (CatalogManager)new CatalogManager(), (Executor)this.executor);
        QueryStateMachine stateMachine = this.createQueryStateMachine("START TRANSACTION", session, transactionManager);
        Assert.assertFalse((boolean)stateMachine.getSession().getTransactionId().isPresent());
        MoreFutures.getFutureValue((Future)new StartTransactionTask(transactionManager).execute(new StartTransaction((List)ImmutableList.of()), stateMachine, Collections.emptyList(), WarningCollector.NOOP));
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        long start = System.nanoTime();
        while (!transactionManager.getAllTransactionInfos().isEmpty()) {
            if (Duration.nanosSince((long)start).toMillis() > 10000L) {
                Assert.fail((String)"Transaction did not expire in the allotted time");
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }

    private QueryStateMachine createQueryStateMachine(String query, Session session, TransactionManager transactionManager) {
        return QueryStateMachine.begin((String)query, Optional.empty(), (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)true, (TransactionManager)transactionManager, (AccessControl)new AccessControlManager(transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), "default"), (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, Optional.empty());
    }

    private static Session.SessionBuilder sessionBuilder() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny");
    }
}

