/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.StateMachine;
import io.trino.execution.buffer.ArbitraryOutputBuffer;
import io.trino.execution.buffer.BufferInfo;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.BufferTestUtils;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBufferMemoryManager;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PageBufferInfo;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestArbitraryOutputBuffer {
    private static final String TASK_INSTANCE_ID = "task-instance-id";
    private static final ImmutableList<BigintType> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final OutputBuffers.OutputBufferId FIRST = new OutputBuffers.OutputBufferId(0);
    private static final OutputBuffers.OutputBufferId SECOND = new OutputBuffers.OutputBufferId(1);
    private ScheduledExecutorService stateNotificationExecutor;

    @BeforeClass
    public void setUp() {
        this.stateNotificationExecutor = Executors.newScheduledThreadPool(5, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.stateNotificationExecutor != null) {
            this.stateNotificationExecutor.shutdownNow();
            this.stateNotificationExecutor = null;
        }
    }

    @Test
    public void testInvalidConstructorArg() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), DataSize.ofBytes((long)0L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("maxBufferSize must be at least 1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), DataSize.ofBytes((long)0L))).isInstanceOf(IllegalArgumentException.class)).hasMessage("maxBufferSize must be at least 1");
    }

    @Test
    public void testSimple() {
        int i;
        OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY);
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(outputBuffers, BufferTestUtils.sizeOfPages(10));
        for (i = 0; i < 3; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0);
        buffer.setOutputBuffers(outputBuffers);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 3, FIRST, 0, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 3, 0);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 3);
        for (i = 3; i < 13; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 9, FIRST, 1, 3);
        ListenableFuture<Void> future = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(13));
        Assert.assertFalse((boolean)future.isDone());
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 10, FIRST, 1, 3);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 3L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(3L, BufferTestUtils.createPage(3), new Page[0]));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 10, FIRST, 1, 3);
        Assert.assertFalse((boolean)future.isDone());
        outputBuffers = outputBuffers.withBuffer(SECOND, 0);
        buffer.setOutputBuffers(outputBuffers);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 10, SECOND, 0, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(4), BufferTestUtils.createPage(5), BufferTestUtils.createPage(6), BufferTestUtils.createPage(7), BufferTestUtils.createPage(8), BufferTestUtils.createPage(9), BufferTestUtils.createPage(10), BufferTestUtils.createPage(11), BufferTestUtils.createPage(12), BufferTestUtils.createPage(13)));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 10, 0);
        buffer.get(SECOND, 10L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 0, 10);
        outputBuffers = outputBuffers.withNoMoreBufferIds();
        buffer.setOutputBuffers(outputBuffers);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 1, 3);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 0, 10);
        BufferTestUtils.assertFutureIsDone(future);
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(14));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(15));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(16));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 2, FIRST, 1, 3);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 2, SECOND, 1, 10);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 10L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(10L, BufferTestUtils.createPage(14), new Page[0]));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 2, FIRST, 1, 3);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 2, SECOND, 1, 10);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 4L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(4L, BufferTestUtils.createPage(15), BufferTestUtils.createPage(16)));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 2, 4);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 1, 10);
        Assert.assertFalse((boolean)buffer.isFinished());
        buffer.setNoMorePages();
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 2, 4);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 1, 10);
        Assert.assertFalse((boolean)buffer.isFinished());
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 6L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)6L, (boolean)true));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 6);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 1, 10);
        Assert.assertFalse((boolean)buffer.isFinished());
        buffer.abort(FIRST);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 6);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 1, 10);
        Assert.assertFalse((boolean)buffer.isFinished());
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 11L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)11L, (boolean)true));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 0, 11);
        Assert.assertFalse((boolean)buffer.isFinished());
        buffer.abort(SECOND);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 6);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, SECOND, 11);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 6L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)6L, (boolean)true));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 11L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)11L, (boolean)true));
    }

    @Test
    public void testAcknowledge() {
        OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY);
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(outputBuffers, BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0);
        buffer.setOutputBuffers(outputBuffers);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 3, FIRST, 0, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 2L);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 1, 2);
        BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 3L);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 3);
        try {
            BufferTestUtils.acknowledgeBufferResult((OutputBuffer)buffer, FIRST, 4L);
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Invalid sequence id");
        }
        for (int i = 3; i < 6; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 3, FIRST, 0, 3);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 2, FIRST, 1, 3);
    }

    @Test
    public void testBufferFull() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(2));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(3));
    }

    @Test
    public void testDuplicateRequests() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 3, FIRST, 0, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 3, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 3, 0);
        buffer.get(FIRST, 3L, BufferTestUtils.sizeOfPages(10)).cancel(true);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)false));
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 3);
    }

    @Test
    public void testAddQueueAfterCreation() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)buffer.isFinished());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds())).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected buffer to not change after no more buffers is set");
    }

    @Test
    public void testAddAfterFinish() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.setNoMorePages();
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        Assert.assertEquals((long)buffer.getInfo().getTotalPagesSent(), (long)0L);
    }

    @Test
    public void testAddQueueAfterNoMoreQueues() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)buffer.isFinished());
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withNoMoreBufferIds());
        Assert.assertFalse((boolean)buffer.isFinished());
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withNoMoreBufferIds());
        Assert.assertFalse((boolean)buffer.isFinished());
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withNoMoreBufferIds());
        Assert.assertFalse((boolean)buffer.isFinished());
        OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> buffer.setOutputBuffers(outputBuffers)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected buffer to not change after no more buffers is set");
    }

    @Test
    public void testAddAfterDestroy() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.destroy();
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        Assert.assertEquals((long)buffer.getInfo().getTotalPagesSent(), (long)0L);
    }

    @Test
    public void testGetBeforeCreate() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)buffer.isFinished());
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(1));
        Assert.assertFalse((boolean)future.isDone());
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(33));
        Assert.assertTrue((boolean)future.isDone());
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(33), new Page[0]));
    }

    @Test
    public void testResumeFromPreviousPosition() {
        int i;
        OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY);
        OutputBuffers.OutputBufferId[] ids = new OutputBuffers.OutputBufferId[5];
        for (int i2 = 0; i2 < ids.length; ++i2) {
            ids[i2] = new OutputBuffers.OutputBufferId(i2);
            outputBuffers = outputBuffers.withBuffer(ids[i2], i2);
        }
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(outputBuffers, BufferTestUtils.sizeOfPages(5));
        Assert.assertFalse((boolean)buffer.isFinished());
        HashMap<OutputBuffers.OutputBufferId, ListenableFuture> firstReads = new HashMap<OutputBuffers.OutputBufferId, ListenableFuture>();
        for (OutputBuffers.OutputBufferId id : ids) {
            firstReads.put(id, buffer.get(id, 0L, BufferTestUtils.sizeOfPages(1)));
        }
        Assertions.assertThat(firstReads.values()).noneMatch(Future::isDone);
        ArrayList<ListenableFuture> secondReads = new ArrayList<ListenableFuture>();
        for (i = 0; i < ids.length; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(33));
            Assertions.assertThat(secondReads).allMatch(future -> !future.isDone(), "No secondary reads should complete until after all first reads");
            List completedIds = firstReads.entrySet().stream().filter(entry -> ((ListenableFuture)entry.getValue()).isDone()).map(Map.Entry::getKey).collect(Collectors.toList());
            Assert.assertEquals((int)completedIds.size(), (int)1, (String)"One completed buffer read per page addition");
            OutputBuffers.OutputBufferId completed = (OutputBuffers.OutputBufferId)completedIds.get(0);
            BufferResult result = BufferTestUtils.getFuture((ListenableFuture<BufferResult>)((ListenableFuture)firstReads.remove(completed)), BufferTestUtils.NO_WAIT);
            secondReads.add(buffer.get(completed, result.getNextToken(), BufferTestUtils.sizeOfPages(1)));
        }
        Assert.assertEquals((int)secondReads.size(), (int)ids.length);
        for (i = 0; i < ids.length; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(33));
            Assert.assertTrue((boolean)((ListenableFuture)secondReads.get(i)).isDone(), (String)("Invalid second read completion order at index: " + i));
        }
    }

    @Test
    public void testUseUndeclaredBufferAfterFinalBuffersSet() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)buffer.isFinished());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> buffer.get(SECOND, 0L, BufferTestUtils.sizeOfPages(1))).isInstanceOf(IllegalStateException.class)).hasMessage("No more buffers already set");
    }

    @Test
    public void testAbortBeforeCreate() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)buffer.isFinished());
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(1));
        Assert.assertFalse((boolean)future.isDone());
        buffer.abort(FIRST);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)false));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(33));
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testFullBufferBlocksWriter() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(2));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(2));
        TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(3));
    }

    @Test
    public void testAbort() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 10; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        buffer.setNoMorePages();
        OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0);
        buffer.setOutputBuffers(outputBuffers);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.abort(FIRST);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 9, FIRST, 0);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 1L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
        outputBuffers = outputBuffers.withBuffer(SECOND, 0).withNoMoreBufferIds();
        buffer.setOutputBuffers(outputBuffers);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(1), new Page[0]));
        buffer.abort(SECOND);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, SECOND, 0);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 1L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testFinishClosesEmptyQueues() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withBuffer(SECOND, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(10));
        buffer.setNoMorePages();
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 0);
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, SECOND, 0, 0);
        buffer.abort(FIRST);
        buffer.abort(SECOND);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 0);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, SECOND, 0);
    }

    @Test
    public void testAbortFreesReader() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0));
        Assert.assertFalse((boolean)buffer.isFinished());
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.abort(FIRST);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 1);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)false));
    }

    @Test
    public void testFinishFreesReader() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0));
        Assert.assertFalse((boolean)buffer.isFinished());
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        TestArbitraryOutputBuffer.assertQueueState((OutputBuffer)buffer, 0, FIRST, 0, 1);
        buffer.abort(FIRST);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 1);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)false));
    }

    @Test
    public void testFinishFreesWriter() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(5));
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds());
        Assert.assertFalse((boolean)buffer.isFinished());
        for (int i = 0; i < 5; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(100)).cancel(true);
        Assert.assertFalse((boolean)firstEnqueuePage.isDone());
        Assert.assertFalse((boolean)secondEnqueuePage.isDone());
        buffer.setNoMorePages();
        Assert.assertFalse((boolean)buffer.isFinished());
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 1L, BufferTestUtils.sizeOfPages(100), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(1L, BufferTestUtils.createPage(1), BufferTestUtils.createPage(2), BufferTestUtils.createPage(3), BufferTestUtils.createPage(4), BufferTestUtils.createPage(5), BufferTestUtils.createPage(6)));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 7L, BufferTestUtils.sizeOfPages(100), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)7L, (boolean)true));
        Assert.assertFalse((boolean)buffer.isFinished());
        buffer.abort(FIRST);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
    }

    @Test
    public void testDestroyFreesReader() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(5));
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds());
        Assert.assertFalse((boolean)buffer.isFinished());
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.destroy();
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 1);
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)1L, (boolean)false));
    }

    @Test
    public void testDestroyFreesWriter() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(5));
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds());
        Assert.assertFalse((boolean)buffer.isFinished());
        for (int i = 0; i < 5; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        Assert.assertFalse((boolean)firstEnqueuePage.isDone());
        Assert.assertFalse((boolean)secondEnqueuePage.isDone());
        buffer.destroy();
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
    }

    @Test
    public void testFailDoesNotFreeReader() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertFalse((boolean)buffer.isFinished());
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.fail();
        Assert.assertFalse((boolean)future.isDone());
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
    }

    @Test
    public void testFailFreesWriter() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds(), BufferTestUtils.sizeOfPages(5));
        Assert.assertFalse((boolean)buffer.isFinished());
        for (int i = 0; i < 5; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        ListenableFuture<Void> firstEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(5));
        ListenableFuture<Void> secondEnqueuePage = TestArbitraryOutputBuffer.enqueuePage((OutputBuffer)buffer, BufferTestUtils.createPage(6));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.MAX_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(1)).cancel(true);
        Assert.assertFalse((boolean)firstEnqueuePage.isDone());
        Assert.assertFalse((boolean)secondEnqueuePage.isDone());
        buffer.fail();
        Assert.assertFalse((boolean)buffer.isFinished());
        BufferTestUtils.assertFutureIsDone(firstEnqueuePage);
        BufferTestUtils.assertFutureIsDone(secondEnqueuePage);
    }

    @Test
    public void testAddBufferAfterFail() {
        OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0);
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(outputBuffers, BufferTestUtils.sizeOfPages(5));
        Assert.assertFalse((boolean)buffer.isFinished());
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(0));
        BufferTestUtils.assertBufferResultEquals(TYPES, BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        buffer.fail();
        outputBuffers = outputBuffers.withBuffer(SECOND, 0);
        buffer.setOutputBuffers(outputBuffers);
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        future = buffer.get(SECOND, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        outputBuffers = outputBuffers.withNoMoreBufferIds();
        buffer.setOutputBuffers(outputBuffers);
        future = buffer.get(FIRST, 1L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        future = buffer.get(SECOND, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
    }

    @Test
    public void testBufferCompletion() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(5));
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0).withNoMoreBufferIds());
        Assert.assertFalse((boolean)buffer.isFinished());
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = 0; i < 5; ++i) {
            Page page = BufferTestUtils.createPage(i);
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, page);
            pages.add(page);
        }
        buffer.setNoMorePages();
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(5), BufferTestUtils.MAX_WAIT), BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, 0L, pages));
        Assert.assertFalse((boolean)buffer.isFinished());
        Assert.assertFalse((boolean)buffer.isFinished());
        buffer.abort(FIRST);
        Assert.assertTrue((boolean)buffer.isFinished());
    }

    @Test
    public void testNoMorePagesFreesReader() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        buffer.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0));
        Assert.assertFalse((boolean)buffer.isFinished());
        ListenableFuture future = buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10));
        Assert.assertFalse((boolean)future.isDone());
        buffer.setNoMorePages();
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)buffer.get(FIRST, 0L, BufferTestUtils.sizeOfPages(10)).isDone());
    }

    @Test
    public void testFinishBeforeNoMoreBuffers() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        buffer.setNoMorePages();
        Assert.assertFalse((boolean)buffer.isFinished());
        OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY).withBuffer(FIRST, 0);
        buffer.setOutputBuffers(outputBuffers);
        Assert.assertFalse((boolean)buffer.isFinished());
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(0L, BufferTestUtils.createPage(0), new Page[0]));
        Assert.assertFalse((boolean)buffer.isFinished());
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 1L, BufferTestUtils.sizeOfPages(10), BufferTestUtils.NO_WAIT), TestArbitraryOutputBuffer.bufferResult(1L, BufferTestUtils.createPage(1), BufferTestUtils.createPage(2)));
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, FIRST, 3L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)3L, (boolean)true));
        Assert.assertFalse((boolean)buffer.isFinished());
        buffer.abort(FIRST);
        TestArbitraryOutputBuffer.assertQueueClosed((OutputBuffer)buffer, 0, FIRST, 3);
        BufferTestUtils.assertFinished((OutputBuffer)buffer);
        outputBuffers = outputBuffers.withBuffer(SECOND, 0);
        buffer.setOutputBuffers(outputBuffers);
        BufferTestUtils.assertBufferResultEquals(TYPES, TestArbitraryOutputBuffer.getBufferResult((OutputBuffer)buffer, SECOND, 0L, BufferTestUtils.sizeOfPages(1), BufferTestUtils.NO_WAIT), BufferResult.emptyResults((String)TASK_INSTANCE_ID, (long)0L, (boolean)true));
    }

    @Test
    public void testForceFreeMemory() {
        ArbitraryOutputBuffer buffer = this.createArbitraryBuffer(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY), BufferTestUtils.sizeOfPages(10));
        for (int i = 0; i < 3; ++i) {
            TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(i));
        }
        OutputBufferMemoryManager memoryManager = buffer.getMemoryManager();
        Assert.assertTrue((memoryManager.getBufferedBytes() > 0L ? 1 : 0) != 0);
        buffer.forceFreeMemory();
        Assert.assertEquals((long)memoryManager.getBufferedBytes(), (long)0L);
        TestArbitraryOutputBuffer.addPage((OutputBuffer)buffer, BufferTestUtils.createPage(1));
        Assert.assertEquals((long)memoryManager.getBufferedBytes(), (long)0L);
    }

    private static BufferResult getBufferResult(OutputBuffer buffer, OutputBuffers.OutputBufferId bufferId, long sequenceId, DataSize maxSize, Duration maxWait) {
        ListenableFuture future = buffer.get(bufferId, sequenceId, maxSize);
        return BufferTestUtils.getFuture((ListenableFuture<BufferResult>)future, maxWait);
    }

    private static ListenableFuture<Void> enqueuePage(OutputBuffer buffer, Page page) {
        buffer.enqueue((List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        ListenableFuture future = buffer.isFull();
        Assert.assertFalse((boolean)future.isDone());
        return future;
    }

    private static void addPage(OutputBuffer buffer, Page page) {
        buffer.enqueue((List)ImmutableList.of((Object)BufferTestUtils.serializePage(page)));
        Assert.assertTrue((boolean)buffer.isFull().isDone(), (String)"Expected add page to not block");
    }

    private static void assertQueueState(OutputBuffer buffer, int unassignedPages, OutputBuffers.OutputBufferId bufferId, int bufferedPages, int pagesSent) {
        OutputBufferInfo outputBufferInfo = buffer.getInfo();
        long assignedPages = outputBufferInfo.getBuffers().stream().mapToInt(BufferInfo::getBufferedPages).sum();
        Assert.assertEquals((long)(outputBufferInfo.getTotalBufferedPages() - assignedPages), (long)unassignedPages, (String)"unassignedPages");
        BufferInfo bufferInfo = outputBufferInfo.getBuffers().stream().filter(info -> info.getBufferId().equals((Object)bufferId)).findAny().orElse(null);
        Assert.assertEquals((Object)bufferInfo, (Object)new BufferInfo(bufferId, false, bufferedPages, (long)pagesSent, new PageBufferInfo(bufferId.getId(), (long)bufferedPages, BufferTestUtils.sizeOfPages(bufferedPages).toBytes(), (long)(bufferedPages + pagesSent), (long)(bufferedPages + pagesSent))));
    }

    private static void assertQueueClosed(OutputBuffer buffer, int unassignedPages, OutputBuffers.OutputBufferId bufferId, int pagesSent) {
        OutputBufferInfo outputBufferInfo = buffer.getInfo();
        long assignedPages = outputBufferInfo.getBuffers().stream().mapToInt(BufferInfo::getBufferedPages).sum();
        Assert.assertEquals((long)(outputBufferInfo.getTotalBufferedPages() - assignedPages), (long)unassignedPages, (String)"unassignedPages");
        BufferInfo bufferInfo = outputBufferInfo.getBuffers().stream().filter(info -> info.getBufferId().equals((Object)bufferId)).findAny().orElse(null);
        Assert.assertEquals((int)bufferInfo.getBufferedPages(), (int)0);
        Assert.assertEquals((long)bufferInfo.getPagesSent(), (long)pagesSent);
        Assert.assertTrue((boolean)bufferInfo.isFinished());
    }

    private ArbitraryOutputBuffer createArbitraryBuffer(OutputBuffers buffers, DataSize dataSize) {
        ArbitraryOutputBuffer buffer = new ArbitraryOutputBuffer(TASK_INSTANCE_ID, new StateMachine("bufferState", (Executor)this.stateNotificationExecutor, (Object)BufferState.OPEN, (Iterable)BufferState.TERMINAL_BUFFER_STATES), dataSize, () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), (Executor)this.stateNotificationExecutor);
        buffer.setOutputBuffers(buffers);
        return buffer;
    }

    private static BufferResult bufferResult(long token, Page firstPage, Page ... otherPages) {
        ImmutableList pages = ImmutableList.builder().add((Object)firstPage).add((Object[])otherPages).build();
        return BufferTestUtils.createBufferResult(TASK_INSTANCE_ID, token, (List<Page>)pages);
    }
}

