/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.scheduler.PartitionedOutputBufferManager;
import io.trino.sql.planner.SystemPartitioningHandle;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartitionedOutputBufferManager {
    @Test
    public void test() {
        PartitionedOutputBufferManager hashOutputBufferManager = new PartitionedOutputBufferManager(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 4);
        TestPartitionedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        hashOutputBufferManager.addOutputBuffer(new OutputBuffers.OutputBufferId(0));
        TestPartitionedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        hashOutputBufferManager.addOutputBuffer(new OutputBuffers.OutputBufferId(3));
        TestPartitionedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> hashOutputBufferManager.addOutputBuffer(new OutputBuffers.OutputBufferId(5))).isInstanceOf(IllegalStateException.class)).hasMessage("Unexpected new output buffer 5");
        TestPartitionedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> hashOutputBufferManager.addOutputBuffer(new OutputBuffers.OutputBufferId(6))).isInstanceOf(IllegalStateException.class)).hasMessage("Unexpected new output buffer 6");
        TestPartitionedOutputBufferManager.assertOutputBuffers(hashOutputBufferManager.getOutputBuffers());
    }

    private static void assertOutputBuffers(OutputBuffers outputBuffers) {
        Assert.assertNotNull((Object)outputBuffers);
        Assert.assertTrue((outputBuffers.getVersion() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)outputBuffers.isNoMoreBufferIds());
        Map buffers = outputBuffers.getBuffers();
        Assert.assertEquals((int)buffers.size(), (int)4);
        for (int partition = 0; partition < 4; ++partition) {
            Assert.assertEquals(buffers.get(new OutputBuffers.OutputBufferId(partition)), (Object)partition);
        }
    }
}

