/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.execution.scheduler.TopologyFileConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestTopologyFileConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((TopologyFileConfig)ConfigAssertions.recordDefaults(TopologyFileConfig.class)).setNetworkTopologyFile(null).setRefreshPeriod(new Duration(5.0, TimeUnit.MINUTES)));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path networkTopologyFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"node-scheduler.network-topology.file", (Object)networkTopologyFile.toString()).put((Object)"node-scheduler.network-topology.refresh-period", (Object)"27m").build();
        TopologyFileConfig expected = new TopologyFileConfig().setNetworkTopologyFile(networkTopologyFile.toFile()).setRefreshPeriod(new Duration(27.0, TimeUnit.MINUTES));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

