/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.trino.client.NodeVersion;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryInfo;
import io.trino.metadata.InternalNode;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryPoolInfo;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class LowMemoryKillerTestingUtils {
    private LowMemoryKillerTestingUtils() {
    }

    static List<MemoryInfo> toNodeMemoryInfoList(long maxReservedPoolBytes, long maxGeneralPoolBytes, String reservedQuery, Map<String, Map<String, Long>> queries) {
        HashMap<InternalNode, NodeReservation> nodeReservations = new HashMap<InternalNode, NodeReservation>();
        for (Map.Entry<String, Map<String, Long>> entry : queries.entrySet()) {
            QueryId queryId = new QueryId(entry.getKey());
            Map<String, Long> reservationByNode = entry.getValue();
            for (Map.Entry<String, Long> nodeEntry : reservationByNode.entrySet()) {
                InternalNode node = new InternalNode(nodeEntry.getKey(), URI.create("http://localhost"), new NodeVersion("version"), false);
                long bytes = nodeEntry.getValue();
                if (bytes == 0L) continue;
                if (reservedQuery.equals(entry.getKey())) {
                    nodeReservations.computeIfAbsent(node, ignored -> new NodeReservation()).getReserved().add(queryId, bytes);
                    continue;
                }
                nodeReservations.computeIfAbsent(node, ignored -> new NodeReservation()).getGeneral().add(queryId, bytes);
            }
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry entry : nodeReservations.entrySet()) {
            NodeReservation nodeReservation = (NodeReservation)entry.getValue();
            ImmutableMap.Builder pools = ImmutableMap.builder();
            if (nodeReservation.getGeneral().getTotalReservedBytes() > 0L) {
                pools.put((Object)LocalMemoryManager.GENERAL_POOL, (Object)new MemoryPoolInfo(maxGeneralPoolBytes, nodeReservation.getGeneral().getTotalReservedBytes(), 0L, nodeReservation.getGeneral().getReservationByQuery(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
            }
            if (nodeReservation.getReserved().getTotalReservedBytes() > 0L) {
                pools.put((Object)LocalMemoryManager.RESERVED_POOL, (Object)new MemoryPoolInfo(maxReservedPoolBytes, nodeReservation.getReserved().getTotalReservedBytes(), 0L, nodeReservation.getReserved().getReservationByQuery(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
            }
            result.add((Object)new MemoryInfo(7, DataSize.ofBytes((long)(maxReservedPoolBytes + maxGeneralPoolBytes)), (Map)pools.build()));
        }
        return result.build();
    }

    static List<LowMemoryKiller.QueryMemoryInfo> toQueryMemoryInfoList(String reservedQuery, Map<String, Map<String, Long>> queries) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry<String, Map<String, Long>> entry : queries.entrySet()) {
            String queryId = entry.getKey();
            long totalReservation = entry.getValue().values().stream().mapToLong(x -> x).sum();
            result.add((Object)new LowMemoryKiller.QueryMemoryInfo(new QueryId(queryId), queryId.equals(reservedQuery) ? LocalMemoryManager.RESERVED_POOL : LocalMemoryManager.GENERAL_POOL, totalReservation));
        }
        return result.build();
    }

    private static class NodeReservation {
        private final PoolReservation general = new PoolReservation();
        private final PoolReservation reserved = new PoolReservation();

        private NodeReservation() {
        }

        public PoolReservation getGeneral() {
            return this.general;
        }

        public PoolReservation getReserved() {
            return this.reserved;
        }
    }

    private static class PoolReservation {
        private long totalReservedBytes;
        private final Map<QueryId, Long> reservationByQuery = new HashMap<QueryId, Long>();

        private PoolReservation() {
        }

        public void add(QueryId queryId, long bytes) {
            this.totalReservedBytes += bytes;
            this.reservationByQuery.put(queryId, bytes);
        }

        public long getTotalReservedBytes() {
            return this.totalReservedBytes;
        }

        public Map<QueryId, Long> getReservationByQuery() {
            return this.reservationByQuery;
        }
    }
}

