/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.memory.MemoryManagerConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestMemoryManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((MemoryManagerConfig)ConfigAssertions.recordDefaults(MemoryManagerConfig.class)).setLowMemoryKillerPolicy(MemoryManagerConfig.LowMemoryKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES).setKillOnOutOfMemoryDelay(new Duration(5.0, TimeUnit.MINUTES)).setMaxQueryMemory(DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemory(DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.low-memory-killer.policy", (Object)"none").put((Object)"query.low-memory-killer.delay", (Object)"20s").put((Object)"query.max-memory", (Object)"2GB").put((Object)"query.max-total-memory", (Object)"3GB").build();
        MemoryManagerConfig expected = new MemoryManagerConfig().setLowMemoryKillerPolicy(MemoryManagerConfig.LowMemoryKillerPolicy.NONE).setKillOnOutOfMemoryDelay(new Duration(20.0, TimeUnit.SECONDS)).setMaxQueryMemory(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setMaxQueryTotalMemory(DataSize.of((long)3L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

