/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.json.JsonModule;
import io.airlift.testing.Assertions;
import io.trino.connector.informationschema.InformationSchemaTable;
import io.trino.connector.informationschema.InformationSchemaTableHandle;
import io.trino.metadata.HandleJsonModule;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.spi.connector.ConnectorTableHandle;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestInformationSchemaTableHandle {
    private static final Map<String, Object> SCHEMA_AS_MAP = new ImmutableMap.Builder().put((Object)"@type", (Object)"$info_schema").put((Object)"catalogName", (Object)"information_schema_catalog").put((Object)"table", (Object)"COLUMNS").put((Object)"prefixes", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"catalogName", (Object)"abc", (Object)"schemaName", (Object)"information_schema"))).put((Object)"roles", (Object)ImmutableList.of((Object)"role")).put((Object)"grantees", (Object)ImmutableList.of((Object)"grantee")).build();
    private ObjectMapper objectMapper;

    @BeforeMethod
    public void startUp() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), new HandleJsonModule()});
        this.objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    @Test
    public void testInformationSchemaSerialize() throws Exception {
        InformationSchemaTableHandle informationSchemaTableHandle = new InformationSchemaTableHandle("information_schema_catalog", InformationSchemaTable.COLUMNS, (Set)ImmutableSet.of((Object)new QualifiedTablePrefix("abc", "information_schema")), Optional.of(ImmutableSet.of((Object)"role")), Optional.of(ImmutableSet.of((Object)"grantee")), OptionalLong.empty());
        Assert.assertTrue((boolean)this.objectMapper.canSerialize(InformationSchemaTableHandle.class));
        String json = this.objectMapper.writeValueAsString((Object)informationSchemaTableHandle);
        this.testJsonEquals(json, SCHEMA_AS_MAP);
    }

    @Test
    public void testInformationSchemaDeserialize() throws Exception {
        String json = this.objectMapper.writeValueAsString(SCHEMA_AS_MAP);
        ConnectorTableHandle tableHandle = (ConnectorTableHandle)this.objectMapper.readValue(json, ConnectorTableHandle.class);
        Assert.assertEquals(tableHandle.getClass(), InformationSchemaTableHandle.class);
        InformationSchemaTableHandle informationSchemaHandle = (InformationSchemaTableHandle)tableHandle;
        Assert.assertEquals((String)informationSchemaHandle.getCatalogName(), (String)"information_schema_catalog");
        Assert.assertEquals((Object)informationSchemaHandle.getTable(), (Object)InformationSchemaTable.COLUMNS);
    }

    private void testJsonEquals(String json, Map<String, Object> expectedMap) throws Exception {
        Map jsonMap = (Map)this.objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Assertions.assertEqualsIgnoreOrder(jsonMap.entrySet(), expectedMap.entrySet());
    }
}

