/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableMap;
import io.trino.metadata.TableLayoutResult;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.testing.TestingConnectorSession;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTableLayoutResult {
    @Test
    public void testComputeEnforced() {
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all());
        this.assertComputeEnforcedFails((TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.none());
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.none());
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.all());
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.all());
        this.assertComputeEnforcedFails((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.none());
        this.assertComputeEnforcedFails((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)9999L))));
        this.assertComputeEnforcedFails((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c9999"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertComputeEnforced((TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("c1"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)new TestingColumnHandle("c2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))), (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    private void assertComputeEnforcedFails(TupleDomain<ColumnHandle> predicate, TupleDomain<ColumnHandle> unenforced) {
        try {
            TupleDomain enforced = TableLayoutResult.computeEnforced(predicate, unenforced);
            Assert.fail((String)String.format("expected IllegalArgumentException but found [%s]", enforced.toString(TestingConnectorSession.SESSION)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertComputeEnforced(TupleDomain<ColumnHandle> predicate, TupleDomain<ColumnHandle> unenforced, TupleDomain<ColumnHandle> expectedEnforced) {
        TupleDomain enforced = TableLayoutResult.computeEnforced(predicate, unenforced);
        if (!enforced.equals(expectedEnforced)) {
            Assert.fail((String)String.format("expected [%s] but found [%s]", expectedEnforced.toString(TestingConnectorSession.SESSION), enforced.toString(TestingConnectorSession.SESSION)));
        }
    }
}

