/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SqlFunction;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.LocalQueryRunner;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TestingFunctionResolution {
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final PlannerContext plannerContext;

    public TestingFunctionResolution() {
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        this.plannerContext = TestingPlannerContext.plannerContextBuilder().withMetadata(this.metadata).build();
    }

    public TestingFunctionResolution(LocalQueryRunner localQueryRunner) {
        this(localQueryRunner.getTransactionManager(), localQueryRunner.getMetadata());
    }

    public TestingFunctionResolution(TransactionManager transactionManager, Metadata metadata) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.plannerContext = TestingPlannerContext.plannerContextBuilder().withMetadata(metadata).build();
    }

    public TestingFunctionResolution addFunctions(List<? extends SqlFunction> functions) {
        this.metadata.addFunctions(functions);
        return this;
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public ExpressionCompiler getExpressionCompiler() {
        return new ExpressionCompiler(this.metadata, this.getPageFunctionCompiler());
    }

    public PageFunctionCompiler getPageFunctionCompiler() {
        return this.getPageFunctionCompiler(0);
    }

    public PageFunctionCompiler getPageFunctionCompiler(int expressionCacheSize) {
        return new PageFunctionCompiler(this.metadata, expressionCacheSize);
    }

    public ResolvedFunction resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        return this.inTransaction(session -> this.metadata.resolveOperator(session, operatorType, argumentTypes));
    }

    public ResolvedFunction getCoercion(Type fromType, Type toType) {
        return this.inTransaction(session -> this.metadata.getCoercion(session, fromType, toType));
    }

    public ResolvedFunction getCoercion(QualifiedName name, Type fromType, Type toType) {
        return this.inTransaction(session -> this.metadata.getCoercion(session, name, fromType, toType));
    }

    public TestingFunctionCallBuilder functionCallBuilder(QualifiedName name) {
        return new TestingFunctionCallBuilder(name);
    }

    public ResolvedFunction resolveFunction(QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.inTransaction(session -> this.metadata.resolveFunction(session, name, parameterTypes));
    }

    public FunctionInvoker getScalarFunctionInvoker(QualifiedName name, List<TypeSignatureProvider> parameterTypes, InvocationConvention invocationConvention) {
        return this.inTransaction(session -> this.metadata.getScalarFunctionInvoker(this.metadata.resolveFunction(session, name, parameterTypes), invocationConvention));
    }

    public TestingAggregationFunction getAggregateFunction(QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.inTransaction(session -> {
            ResolvedFunction resolvedFunction = this.metadata.resolveFunction(session, name, parameterTypes);
            return new TestingAggregationFunction(resolvedFunction.getSignature(), resolvedFunction.getFunctionNullability(), this.metadata.getAggregateFunctionImplementation(resolvedFunction));
        });
    }

    private <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(SessionTestUtils.TEST_SESSION, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }

    public class TestingFunctionCallBuilder {
        private final QualifiedName name;
        private List<TypeSignature> argumentTypes = new ArrayList<TypeSignature>();
        private List<Expression> argumentValues = new ArrayList<Expression>();

        public TestingFunctionCallBuilder(QualifiedName name) {
            this.name = name;
        }

        public TestingFunctionCallBuilder addArgument(Type type, Expression value) {
            Objects.requireNonNull(type, "type is null");
            return this.addArgument(type.getTypeSignature(), value);
        }

        public TestingFunctionCallBuilder addArgument(TypeSignature typeSignature, Expression value) {
            Objects.requireNonNull(typeSignature, "typeSignature is null");
            Objects.requireNonNull(value, "value is null");
            this.argumentTypes.add(typeSignature);
            this.argumentValues.add(value);
            return this;
        }

        public TestingFunctionCallBuilder setArguments(List<Type> types, List<Expression> values) {
            Objects.requireNonNull(types, "types is null");
            Objects.requireNonNull(values, "values is null");
            this.argumentTypes = types.stream().map(Type::getTypeSignature).collect(Collectors.toList());
            this.argumentValues = new ArrayList<Expression>(values);
            return this;
        }

        public FunctionCall build() {
            return new FunctionCall(Optional.empty(), TestingFunctionResolution.this.resolveFunction(this.name, TypeSignatureProvider.fromTypeSignatures(this.argumentTypes)).toQualifiedName(), Optional.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.empty(), this.argumentValues);
        }
    }
}

