/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import io.trino.type.TypeTestUtils;
import java.util.List;
import java.util.Optional;

public class PageTestUtils {
    private PageTestUtils() {
    }

    public static Page createRandomPage(List<Type> types, int positionCount, float nullRate) {
        return PageTestUtils.createRandomPage(types, positionCount, Optional.of(ImmutableList.of((Object)0)), nullRate, Optional.empty());
    }

    public static Page createRandomDictionaryPage(List<Type> types, int positionCount, float nullRate) {
        return PageTestUtils.createRandomPage(types, positionCount, Optional.of(ImmutableList.of((Object)0)), nullRate, Optional.of(Wrapping.DICTIONARY));
    }

    public static Page createRandomRlePage(List<Type> types, int positionCount, float nullRate) {
        return PageTestUtils.createRandomPage(types, positionCount, Optional.of(ImmutableList.of((Object)0)), nullRate, Optional.of(Wrapping.RUN_LENGTH));
    }

    public static Page createRandomPage(List<Type> types, int positionCount, Optional<List<Integer>> hashChannels, float nullRate, Optional<Wrapping> wrapping) {
        int channelCount = types.size();
        ImmutableList.Builder blocks = ImmutableList.builder();
        for (int i = 0; i < channelCount; ++i) {
            Block block = BlockAssertions.createRandomBlockForType(types.get(i), positionCount, nullRate);
            blocks.add((Object)wrapping.map(w -> w.wrap(block, positionCount)).orElse(block));
        }
        hashChannels.ifPresent(channels -> {
            ImmutableList blocksWithoutHash = blocks.build();
            blocks.add((Object)TypeTestUtils.getHashBlock((List)channels.stream().map(types::get).collect(ImmutableList.toImmutableList()), (Block[])channels.stream().map(arg_0 -> blocksWithoutHash.get(arg_0)).toArray(Block[]::new)));
        });
        return new Page(positionCount, (Block[])blocks.build().toArray(Block[]::new));
    }

    public static enum Wrapping {
        DICTIONARY{

            @Override
            public Block wrap(Block block, int positionCount) {
                return BlockAssertions.createRandomDictionaryBlock(block, positionCount);
            }
        }
        ,
        RUN_LENGTH{

            @Override
            public Block wrap(Block block, int positionCount) {
                return BlockAssertions.createRandomRleBlock(block, positionCount);
            }
        };


        public abstract Block wrap(Block var1, int var2);
    }
}

