/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.operator.DeduplicationExchangeClientBuffer;
import io.trino.operator.ExchangeClientBuffer;
import io.trino.operator.RetryPolicy;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeduplicationExchangeClientBuffer {
    private static final DataSize ONE_KB = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.KILOBYTE);

    @Test
    public void testIsBlocked() {
        TaskId taskId;
        ListenableFuture blocked;
        try (DeduplicationExchangeClientBuffer buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);){
            blocked = buffer.isBlocked();
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.close();
            TestDeduplicationExchangeClientBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            blocked = buffer.isBlocked();
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.noMoreTasks();
            TestDeduplicationExchangeClientBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            blocked = buffer.isBlocked();
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.taskFinished(taskId);
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.noMoreTasks();
            TestDeduplicationExchangeClientBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            blocked = buffer.isBlocked();
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.noMoreTasks();
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.taskFinished(taskId);
            TestDeduplicationExchangeClientBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            blocked = buffer.isBlocked();
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.taskFailed(taskId, (Throwable)new RuntimeException());
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.noMoreTasks();
            TestDeduplicationExchangeClientBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            blocked = buffer.isBlocked();
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.noMoreTasks();
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked);
            buffer.taskFailed(taskId, (Throwable)new RuntimeException());
            TestDeduplicationExchangeClientBuffer.assertNotBlocked((ListenableFuture<Void>)blocked);
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            ListenableFuture blocked1 = buffer.isBlocked();
            ListenableFuture blocked2 = buffer.isBlocked();
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked1);
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked2);
            blocked2.cancel(true);
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)blocked1);
            TestDeduplicationExchangeClientBuffer.assertNotBlocked((ListenableFuture<Void>)blocked2);
        }
        finally {
            buffer.close();
        }
    }

    @Test
    public void testPollPage() {
        TestDeduplicationExchangeClientBuffer.testPollPages((Multimap<TaskId, Slice>)ImmutableListMultimap.of(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), (List<String>)ImmutableList.of());
        TestDeduplicationExchangeClientBuffer.testPollPages((Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 0), (Object)Slices.utf8Slice((String)"p0a0v0")).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), (List<String>)ImmutableList.of((Object)"p0a0v0"));
        TestDeduplicationExchangeClientBuffer.testPollPages((Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 0), (Object)Slices.utf8Slice((String)"p0a0v0")).put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 1), (Object)Slices.utf8Slice((String)"p0a1v0")).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), (List<String>)ImmutableList.of((Object)"p0a1v0"));
        TestDeduplicationExchangeClientBuffer.testPollPages((Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 0), (Object)Slices.utf8Slice((String)"p0a0v0")).put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(1, 0), (Object)Slices.utf8Slice((String)"p1a0v0")).put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 1), (Object)Slices.utf8Slice((String)"p0a1v0")).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of(), (List<String>)ImmutableList.of((Object)"p0a1v0"));
        TestDeduplicationExchangeClientBuffer.testPollPages((Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 0), (Object)Slices.utf8Slice((String)"p0a0v0")).put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(1, 0), (Object)Slices.utf8Slice((String)"p1a0v0")).put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 1), (Object)Slices.utf8Slice((String)"p0a1v0")).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicationExchangeClientBuffer.createTaskId(2, 0), (Object)new RuntimeException("error")), (List<String>)ImmutableList.of((Object)"p0a1v0"));
        RuntimeException error = new RuntimeException("error");
        TestDeduplicationExchangeClientBuffer.testPollPagesFailure((Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 0), (Object)Slices.utf8Slice((String)"p0a0v0")).put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(1, 0), (Object)Slices.utf8Slice((String)"p1a0v0")).put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 1), (Object)Slices.utf8Slice((String)"p0a1v0")).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicationExchangeClientBuffer.createTaskId(2, 2), (Object)error), error);
        TestDeduplicationExchangeClientBuffer.testPollPagesFailure((Multimap<TaskId, Slice>)ImmutableListMultimap.builder().put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 0), (Object)Slices.utf8Slice((String)"p0a0v0")).put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(1, 0), (Object)Slices.utf8Slice((String)"p1a0v0")).put((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 1), (Object)Slices.utf8Slice((String)"p0a1v0")).build(), (Map<TaskId, RuntimeException>)ImmutableMap.of((Object)TestDeduplicationExchangeClientBuffer.createTaskId(0, 1), (Object)error), error);
    }

    private static void testPollPages(Multimap<TaskId, Slice> pages, Map<TaskId, RuntimeException> failures, List<String> expectedValues) {
        List<Slice> actualPages = TestDeduplicationExchangeClientBuffer.pollPages(pages, failures);
        List actualValues = (List)actualPages.stream().map(Slice::toStringUtf8).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)actualValues).containsExactlyInAnyOrderElementsOf(expectedValues);
    }

    private static void testPollPagesFailure(Multimap<TaskId, Slice> pages, Map<TaskId, RuntimeException> failures, Throwable expectedFailure) {
        Assertions.assertThatThrownBy(() -> TestDeduplicationExchangeClientBuffer.pollPages(pages, failures)).isEqualTo((Object)expectedFailure);
    }

    private static List<Slice> pollPages(Multimap<TaskId, Slice> pages, Map<TaskId, RuntimeException> failures) {
        try (DeduplicationExchangeClientBuffer buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);){
            Slice slice;
            for (TaskId immutableList : Sets.union((Set)pages.keySet(), failures.keySet())) {
                buffer.addTask(immutableList);
            }
            for (Map.Entry entry : pages.entries()) {
                buffer.addPages((TaskId)entry.getKey(), (List)ImmutableList.of((Object)((Slice)entry.getValue())));
            }
            for (Map.Entry entry : failures.entrySet()) {
                buffer.taskFailed((TaskId)entry.getKey(), (Throwable)entry.getValue());
            }
            for (TaskId taskId : Sets.difference((Set)pages.keySet(), failures.keySet())) {
                buffer.taskFinished(taskId);
            }
            buffer.noMoreTasks();
            ImmutableList.Builder result = ImmutableList.builder();
            while ((slice = buffer.pollPage()) != null) {
                result.add((Object)slice);
            }
            Assert.assertTrue((boolean)buffer.isFinished());
            ImmutableList immutableList = result.build();
            return immutableList;
        }
    }

    @Test
    public void testRemovePagesForPreviousAttempts() {
        try (DeduplicationExchangeClientBuffer buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);){
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)0L);
            TaskId partition0Attempt0 = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            TaskId partition1Attempt0 = TestDeduplicationExchangeClientBuffer.createTaskId(1, 0);
            TaskId partition0Attempt1 = TestDeduplicationExchangeClientBuffer.createTaskId(0, 1);
            Slice page1 = Slices.utf8Slice((String)"textofrandomlength");
            Slice page2 = Slices.utf8Slice((String)"textwithdifferentlength");
            Slice page3 = Slices.utf8Slice((String)"smalltext");
            buffer.addTask(partition0Attempt0);
            buffer.addPages(partition0Attempt0, (List)ImmutableList.of((Object)page1));
            buffer.addTask(partition1Attempt0);
            buffer.addPages(partition1Attempt0, (List)ImmutableList.of((Object)page2));
            Assertions.assertThat((long)buffer.getRetainedSizeInBytes()).isGreaterThan(0L);
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)(page1.getRetainedSize() + page2.getRetainedSize()));
            buffer.addTask(partition0Attempt1);
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)0L);
            buffer.addPages(partition0Attempt1, (List)ImmutableList.of((Object)page3));
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)page3.getRetainedSize());
        }
    }

    @Test
    public void testBufferOverflow() {
        try (DeduplicationExchangeClientBuffer buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.BYTE), RetryPolicy.QUERY);){
            TaskId task = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            Slice page1 = Slices.utf8Slice((String)"1234");
            Slice page2 = Slices.utf8Slice((String)"123456789");
            Assertions.assertThat((long)page1.getRetainedSize()).isLessThanOrEqualTo(100L);
            Assertions.assertThat((long)(page1.getRetainedSize() + page2.getRetainedSize())).isGreaterThan(100L);
            buffer.addTask(task);
            buffer.addPages(task, (List)ImmutableList.of((Object)page1));
            Assert.assertFalse((boolean)buffer.isFinished());
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)buffer.isBlocked());
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)page1.getRetainedSize());
            buffer.addPages(task, (List)ImmutableList.of((Object)page2));
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertTrue((boolean)buffer.isFailed());
            TestDeduplicationExchangeClientBuffer.assertNotBlocked((ListenableFuture<Void>)buffer.isBlocked());
            Assert.assertEquals((long)buffer.getRetainedSizeInBytes(), (long)0L);
            Assert.assertEquals((int)buffer.getBufferedPageCount(), (int)0);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ExchangeClientBuffer)buffer).pollPage()).isInstanceOf(TrinoException.class)).hasMessage("Retries for queries with large result set currently unsupported");
        }
    }

    @Test
    public void testIsFinished() {
        TaskId taskId;
        try (DeduplicationExchangeClientBuffer buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);){
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.close();
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFinished(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFinished(taskId);
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFailed(taskId, (Throwable)new RuntimeException());
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertTrue((boolean)buffer.isFailed());
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFailed(taskId, (Throwable)new RuntimeException());
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertTrue((boolean)buffer.isFailed());
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            buffer.addPages(taskId, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"page")));
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFailed(taskId, (Throwable)new RuntimeException());
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertTrue((boolean)buffer.isFailed());
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            buffer.addPages(taskId, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"page")));
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFinished(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertNotNull((Object)buffer.pollPage());
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        finally {
            buffer.close();
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            Assert.assertFalse((boolean)buffer.isFinished());
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            buffer.addPages(taskId, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"page")));
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.taskFinished(taskId);
            Assert.assertFalse((boolean)buffer.isFinished());
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertNotNull((Object)buffer.pollPage());
            Assert.assertTrue((boolean)buffer.isFinished());
        }
        finally {
            buffer.close();
        }
    }

    @Test
    public void testRemainingBufferCapacity() {
        try (DeduplicationExchangeClientBuffer buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);){
            Assert.assertFalse((boolean)buffer.isFinished());
            TaskId taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            Slice page = Slices.utf8Slice((String)"page");
            buffer.addPages(taskId, (List)ImmutableList.of((Object)page));
            Assert.assertEquals((long)buffer.getRemainingCapacityInBytes(), (long)(ONE_KB.toBytes() - page.getRetainedSize()));
        }
    }

    @Test
    public void testRemoteTaskFailedError() {
        TaskId taskId;
        try (DeduplicationExchangeClientBuffer buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);){
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            buffer.taskFailed(taskId, (Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_FAILED, "Remote task failed"));
            buffer.noMoreTasks();
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertFalse((boolean)buffer.isFailed());
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)buffer.isBlocked());
            Assert.assertNull((Object)buffer.pollPage());
        }
        buffer = new DeduplicationExchangeClientBuffer(MoreExecutors.directExecutor(), ONE_KB, RetryPolicy.QUERY);
        try {
            taskId = TestDeduplicationExchangeClientBuffer.createTaskId(0, 0);
            buffer.addTask(taskId);
            buffer.noMoreTasks();
            buffer.taskFailed(taskId, (Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_FAILED, "Remote task failed"));
            Assert.assertFalse((boolean)buffer.isFinished());
            Assert.assertFalse((boolean)buffer.isFailed());
            TestDeduplicationExchangeClientBuffer.assertBlocked((ListenableFuture<Void>)buffer.isBlocked());
            Assert.assertNull((Object)buffer.pollPage());
        }
        finally {
            buffer.close();
        }
    }

    private static TaskId createTaskId(int partition, int attempt) {
        return new TaskId(new StageId("query", 0), partition, attempt);
    }

    private static void assertNotBlocked(ListenableFuture<Void> blocked) {
        Assert.assertTrue((boolean)blocked.isDone());
    }

    private static void assertBlocked(ListenableFuture<Void> blocked) {
        Assert.assertFalse((boolean)blocked.isDone());
    }
}

