/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.Lifespan;
import io.trino.operator.DriverStats;
import io.trino.operator.OperatorStats;
import io.trino.operator.TestOperatorStats;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDriverStats {
    public static final DriverStats EXPECTED = new DriverStats(Lifespan.driverGroup((int)21), new DateTime(1L), new DateTime(2L), new DateTime(3L), new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)6L), DataSize.ofBytes((long)7L), DataSize.ofBytes((long)8L), new Duration(9.0, TimeUnit.NANOSECONDS), new Duration(10.0, TimeUnit.NANOSECONDS), new Duration(12.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)131L), 141L, new Duration(151.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)132L), 142L, new Duration(152.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)13L), 14L, new Duration(15.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)16L), 17L, DataSize.ofBytes((long)18L), 19L, DataSize.ofBytes((long)20L), (List)ImmutableList.of((Object)TestOperatorStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(DriverStats.class);
        String json = codec.toJson((Object)EXPECTED);
        DriverStats actual = (DriverStats)codec.fromJson(json);
        TestDriverStats.assertExpectedDriverStats(actual);
    }

    public static void assertExpectedDriverStats(DriverStats actual) {
        Assert.assertEquals((Object)actual.getLifespan(), (Object)Lifespan.driverGroup((int)21));
        Assert.assertEquals((Object)actual.getCreateTime(), (Object)new DateTime(1L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getStartTime(), (Object)new DateTime(2L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getEndTime(), (Object)new DateTime(3L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getQueuedTime(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getElapsedTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)DataSize.ofBytes((long)6L));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)7L));
        Assert.assertEquals((Object)actual.getSystemMemoryReservation(), (Object)DataSize.ofBytes((long)8L));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(9.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(10.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(12.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPhysicalInputDataSize(), (Object)DataSize.ofBytes((long)131L));
        Assert.assertEquals((long)actual.getPhysicalInputPositions(), (long)141L);
        Assert.assertEquals((Object)actual.getPhysicalInputReadTime(), (Object)new Duration(151.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getInternalNetworkInputDataSize(), (Object)DataSize.ofBytes((long)132L));
        Assert.assertEquals((long)actual.getInternalNetworkInputPositions(), (long)142L);
        Assert.assertEquals((Object)actual.getInternalNetworkInputReadTime(), (Object)new Duration(152.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)DataSize.ofBytes((long)13L));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)14L);
        Assert.assertEquals((Object)actual.getRawInputReadTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)DataSize.ofBytes((long)16L));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)17L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)DataSize.ofBytes((long)18L));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)19L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)DataSize.ofBytes((long)20L));
        Assert.assertEquals((int)actual.getOperatorStats().size(), (int)1);
        TestOperatorStats.assertExpectedOperatorStats((OperatorStats)actual.getOperatorStats().get(0));
    }
}

