/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.execution.Lifespan;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.TestingPagesSerdeFactory;
import io.trino.metadata.Split;
import io.trino.operator.DriverContext;
import io.trino.operator.ExchangeClient;
import io.trino.operator.ExchangeClientBuffer;
import io.trino.operator.ExchangeClientSupplier;
import io.trino.operator.ExchangeOperator;
import io.trino.operator.Operator;
import io.trino.operator.OperatorStats;
import io.trino.operator.PageAssertions;
import io.trino.operator.RetryPolicy;
import io.trino.operator.SourceOperator;
import io.trino.operator.StreamingExchangeClientBuffer;
import io.trino.operator.TestingExchangeHttpClientHandler;
import io.trino.operator.TestingTaskBuffer;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.split.RemoteSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingTaskContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestExchangeOperator {
    private static final List<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR);
    private static final PagesSerdeFactory SERDE_FACTORY = new TestingPagesSerdeFactory();
    private static final TaskId TASK_1_ID = new TaskId(new StageId("query", 0), 0, 0);
    private static final TaskId TASK_2_ID = new TaskId(new StageId("query", 0), 1, 0);
    private static final TaskId TASK_3_ID = new TaskId(new StageId("query", 0), 2, 0);
    private final LoadingCache<TaskId, TestingTaskBuffer> taskBuffers = CacheBuilder.newBuilder().build(CacheLoader.from(TestingTaskBuffer::new));
    private ScheduledExecutorService scheduler;
    private ScheduledExecutorService scheduledExecutor;
    private HttpClient httpClient;
    private ExchangeClientSupplier exchangeClientSupplier;
    private ExecutorService pageBufferClientCallbackExecutor;

    @BeforeClass
    public void setUp() {
        this.scheduler = Executors.newScheduledThreadPool(4, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.pageBufferClientCallbackExecutor = Executors.newSingleThreadExecutor();
        this.httpClient = new TestingHttpClient((TestingHttpClient.Processor)new TestingExchangeHttpClientHandler(this.taskBuffers), (ExecutorService)this.scheduler);
        this.exchangeClientSupplier = (systemMemoryUsageListener, taskFailureListener, retryPolicy) -> new ExchangeClient("localhost", FeaturesConfig.DataIntegrityVerification.ABORT, (ExchangeClientBuffer)new StreamingExchangeClientBuffer((Executor)this.scheduler, DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)), DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE), 3, new Duration(1.0, TimeUnit.MINUTES), true, this.httpClient, this.scheduler, systemMemoryUsageListener, (Executor)this.pageBufferClientCallbackExecutor, taskFailureListener);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.httpClient.close();
        this.httpClient = null;
        this.scheduler.shutdownNow();
        this.scheduler = null;
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
        this.pageBufferClientCallbackExecutor.shutdownNow();
        this.pageBufferClientCallbackExecutor = null;
    }

    @BeforeMethod
    public void setUpMethod() {
        this.taskBuffers.invalidateAll();
    }

    @Test
    public void testSimple() throws Exception {
        SourceOperator operator = this.createExchangeOperator();
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_1_ID));
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_2_ID));
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_3_ID));
        operator.noMoreSplits();
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPages(10, true);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_2_ID)).addPages(10, true);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_3_ID)).addPages(10, true);
        TestExchangeOperator.waitForPages((Operator)operator, 30);
        TestExchangeOperator.waitForFinished((Operator)operator);
    }

    private static Split newRemoteSplit(TaskId taskId) {
        return new Split(ExchangeOperator.REMOTE_CONNECTOR_ID, (ConnectorSplit)new RemoteSplit(taskId, "http://localhost/" + taskId), Lifespan.taskWide());
    }

    @Test
    public void testWaitForClose() throws Exception {
        SourceOperator operator = this.createExchangeOperator();
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_1_ID));
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_2_ID));
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_3_ID));
        operator.noMoreSplits();
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPages(1, false);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_2_ID)).addPages(1, false);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_3_ID)).addPages(1, false);
        TestExchangeOperator.waitForPages((Operator)operator, 3);
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)false);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        Assert.assertEquals((Object)operator.getOutput(), null);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPages(2, true);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_2_ID)).addPages(2, true);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_3_ID)).addPages(2, true);
        TestExchangeOperator.waitForPages((Operator)operator, 6);
        TestExchangeOperator.waitForFinished((Operator)operator);
    }

    @Test
    public void testWaitForNoMoreSplits() throws Exception {
        SourceOperator operator = this.createExchangeOperator();
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_1_ID));
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPages(1, true);
        TestExchangeOperator.waitForPages((Operator)operator, 1);
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)false);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        Assert.assertEquals((Object)operator.getOutput(), null);
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_2_ID));
        operator.noMoreSplits();
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_2_ID)).addPages(2, true);
        TestExchangeOperator.waitForPages((Operator)operator, 2);
        TestExchangeOperator.waitForFinished((Operator)operator);
    }

    @Test
    public void testFinish() throws Exception {
        SourceOperator operator = this.createExchangeOperator();
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_1_ID));
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_2_ID));
        operator.addSplit(TestExchangeOperator.newRemoteSplit(TASK_3_ID));
        operator.noMoreSplits();
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_1_ID)).addPages(1, false);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_2_ID)).addPages(1, false);
        ((TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)TASK_3_ID)).addPages(1, false);
        TestExchangeOperator.waitForPages((Operator)operator, 3);
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)false);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        Assert.assertEquals((Object)operator.getOutput(), null);
        operator.finish();
        TestExchangeOperator.waitForFinished((Operator)operator);
    }

    private SourceOperator createExchangeOperator() {
        ExchangeOperator.ExchangeOperatorFactory operatorFactory = new ExchangeOperator.ExchangeOperatorFactory(0, new PlanNodeId("test"), this.exchangeClientSupplier, SERDE_FACTORY, RetryPolicy.NONE);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.scheduler, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        SourceOperator operator = operatorFactory.createOperator(driverContext);
        Assert.assertEquals((long)((OperatorStats)Iterables.getOnlyElement((Iterable)operator.getOperatorContext().getNestedOperatorStats())).getSystemMemoryReservation().toBytes(), (long)0L);
        return operator;
    }

    private static List<Page> waitForPages(Operator operator, int expectedPageCount) throws InterruptedException {
        long endTime = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
        ArrayList<Page> outputPages = new ArrayList<Page>();
        boolean greaterThanZero = false;
        while (System.nanoTime() - endTime < 0L && !operator.isFinished()) {
            if (operator.getOperatorContext().getDriverContext().getPipelineContext().getPipelineStats().getSystemMemoryReservation().toBytes() > 0L) {
                greaterThanZero = true;
                break;
            }
            Thread.sleep(10L);
        }
        Assert.assertTrue((boolean)greaterThanZero);
        while (outputPages.size() < expectedPageCount && System.nanoTime() < endTime) {
            Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
            if (operator.isFinished()) break;
            Page outputPage = operator.getOutput();
            if (outputPage != null) {
                outputPages.add(outputPage);
                continue;
            }
            Thread.sleep(10L);
        }
        Thread.sleep(10L);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        Assert.assertNull((Object)operator.getOutput());
        Assert.assertEquals((int)outputPages.size(), (int)expectedPageCount);
        for (Page page : outputPages) {
            PageAssertions.assertPageEquals(TYPES, page, TestingTaskBuffer.PAGE);
        }
        Assert.assertEquals((long)((OperatorStats)Iterables.getOnlyElement((Iterable)operator.getOperatorContext().getNestedOperatorStats())).getSystemMemoryReservation().toBytes(), (long)0L);
        return outputPages;
    }

    private static void waitForFinished(Operator operator) throws InterruptedException {
        long endTime = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
        while (System.nanoTime() - endTime < 0L) {
            Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
            Assert.assertNull((Object)operator.getOutput());
            if (operator.isFinished()) break;
            Thread.sleep(10L);
        }
        Assert.assertEquals((boolean)operator.isFinished(), (boolean)true);
        Assert.assertEquals((boolean)operator.needsInput(), (boolean)false);
        Assert.assertNull((Object)operator.getOutput());
        Assert.assertEquals((long)((OperatorStats)Iterables.getOnlyElement((Iterable)operator.getOperatorContext().getNestedOperatorStats())).getSystemMemoryReservation().toBytes(), (long)0L);
    }
}

