/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.SqlDecimal;
import java.math.BigDecimal;

public abstract class AbstractTestDecimalAverageAggregation
extends AbstractTestAggregationFunction {
    protected abstract DecimalType getDecimalType();

    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = this.getDecimalType().createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            this.writeDecimalToBlock(AbstractTestDecimalAverageAggregation.getBigDecimalForCounter(i), blockBuilder);
        }
        return new Block[]{blockBuilder.build()};
    }

    protected abstract void writeDecimalToBlock(BigDecimal var1, BlockBuilder var2);

    private static BigDecimal getBigDecimalForCounter(int i) {
        String iAsString = String.valueOf(Math.abs(i));
        return new BigDecimal(String.valueOf(i) + "." + iAsString + iAsString).setScale(2, 1);
    }

    protected SqlDecimal getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        BigDecimal avg = BigDecimal.ZERO;
        for (int i = start; i < start + length; ++i) {
            avg = avg.add(AbstractTestDecimalAverageAggregation.getBigDecimalForCounter(i));
        }
        avg = avg.divide(BigDecimal.valueOf(length), 4);
        return new SqlDecimal(avg.unscaledValue(), avg.precision(), avg.scale());
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }
}

