/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.Aggregator;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayAggregation {
    private static final int ARRAY_SIZE = 10000000;

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public void arrayAggregation(BenchmarkData data) {
        data.getAggregator().processPage(data.getPage());
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArrayAggregation().arrayAggregation(data);
        Benchmarks.benchmark(BenchmarkArrayAggregation.class, (WarmupMode)WarmupMode.BULK).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"BIGINT", "VARCHAR", "DOUBLE", "BOOLEAN"})
        private String type = "BIGINT";
        private Page page;
        private Aggregator aggregator;

        @Setup(value=Level.Invocation)
        public void setup() {
            BigintType elementType;
            switch (this.type) {
                case "BIGINT": {
                    elementType = BigintType.BIGINT;
                    break;
                }
                case "VARCHAR": {
                    elementType = VarcharType.VARCHAR;
                    break;
                }
                case "DOUBLE": {
                    elementType = DoubleType.DOUBLE;
                    break;
                }
                case "BOOLEAN": {
                    elementType = BooleanType.BOOLEAN;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            TestingAggregationFunction function = new TestingFunctionResolution().getAggregateFunction(QualifiedName.of((String)"array_agg"), TypeSignatureProvider.fromTypes((Type[])new Type[]{elementType}));
            this.aggregator = function.createAggregatorFactory(AggregationNode.Step.SINGLE, (List<Integer>)ImmutableList.of((Object)0), OptionalInt.empty()).createAggregator();
            Block block = BenchmarkData.createChannel(10000000, (Type)elementType);
            this.page = new Page(new Block[]{block});
        }

        private static Block createChannel(int arraySize, Type elementType) {
            BlockBuilder blockBuilder = elementType.createBlockBuilder(null, arraySize);
            for (int i = 0; i < arraySize; ++i) {
                if (elementType.getJavaType() == Long.TYPE) {
                    elementType.writeLong(blockBuilder, (long)i);
                    continue;
                }
                if (elementType.getJavaType() == Double.TYPE) {
                    elementType.writeDouble(blockBuilder, ThreadLocalRandom.current().nextDouble());
                    continue;
                }
                if (elementType.getJavaType() == Boolean.TYPE) {
                    elementType.writeBoolean(blockBuilder, ThreadLocalRandom.current().nextBoolean());
                    continue;
                }
                if (elementType.equals(VarcharType.VARCHAR)) {
                    elementType.writeSlice(blockBuilder, Slices.utf8Slice((String)Long.toString(ThreadLocalRandom.current().nextLong() % 100L)));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return blockBuilder.build();
        }

        public Aggregator getAggregator() {
            return this.aggregator;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

