/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.block.BlockAssertions;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import io.trino.util.StructuralTestUtil;
import java.util.LinkedHashMap;
import java.util.List;
import org.testng.annotations.Test;

public class TestMapAggAggregation {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();

    @Test
    public void testDuplicateKeysValues() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR}), (Object)ImmutableMap.of((Object)1.0, (Object)"a"), BlockAssertions.createDoublesBlock(1.0, 1.0, 1.0), BlockAssertions.createStringsBlock("a", "b", "c"));
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, IntegerType.INTEGER}), (Object)ImmutableMap.of((Object)1.0, (Object)99, (Object)2.0, (Object)99, (Object)3.0, (Object)99), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createTypedLongsBlock((Type)IntegerType.INTEGER, (Iterable<Long>)ImmutableList.of((Object)99L, (Object)99L, (Object)99L)));
    }

    @Test
    public void testSimpleMaps() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR}), (Object)ImmutableMap.of((Object)1.0, (Object)"a", (Object)2.0, (Object)"b", (Object)3.0, (Object)"c"), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createStringsBlock("a", "b", "c"));
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, IntegerType.INTEGER}), (Object)ImmutableMap.of((Object)1.0, (Object)3, (Object)2.0, (Object)2, (Object)3.0, (Object)1), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createTypedLongsBlock((Type)IntegerType.INTEGER, (Iterable<Long>)ImmutableList.of((Object)3L, (Object)2L, (Object)1L)));
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, BooleanType.BOOLEAN}), (Object)ImmutableMap.of((Object)1.0, (Object)true, (Object)2.0, (Object)false, (Object)3.0, (Object)false), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createBooleansBlock(true, false, false));
    }

    @Test
    public void testNull() {
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}), (Object)ImmutableMap.of((Object)1.0, (Object)2.0), BlockAssertions.createDoublesBlock(1.0, null, null), BlockAssertions.createDoublesBlock(2.0, 3.0, 4.0));
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}), null, BlockAssertions.createDoublesBlock(null, null, null), BlockAssertions.createDoublesBlock(2.0, 3.0, 4.0));
        LinkedHashMap<Double, Object> expected = new LinkedHashMap<Double, Object>();
        expected.put(1.0, null);
        expected.put(2.0, null);
        expected.put(3.0, null);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}), expected, BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createDoublesBlock(null, null, null));
    }

    @Test
    public void testDoubleArrayMap() {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, arrayType}), (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableList.of((Object)"e", (Object)"f")), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), BlockAssertions.createStringArraysBlock((Iterable<? extends Iterable<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"e", (Object)"f"))));
    }

    @Test
    public void testDoubleMapMap() {
        MapType innerMapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR);
        BlockBuilder builder = innerMapType.createBlockBuilder(null, 3);
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"a", (Object)"b")));
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"c", (Object)"d")));
        innerMapType.writeObject(builder, (Object)StructuralTestUtil.mapBlockOf((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)"e", (Object)"f")));
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, innerMapType}), (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableMap.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableMap.of((Object)"e", (Object)"f")), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), builder.build());
    }

    @Test
    public void testDoubleRowMap() {
        RowType innerRowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"f1", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)));
        BlockBuilder builder = innerRowType.createBlockBuilder(null, 3);
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), 1L, 1.0));
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), 2L, 2.0));
        innerRowType.writeObject(builder, (Object)OperatorAssertion.toRow((List<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), 3L, 3.0));
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, innerRowType}), (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)1, (Object)1.0), (Object)2.0, (Object)ImmutableList.of((Object)2, (Object)2.0), (Object)3.0, (Object)ImmutableList.of((Object)3, (Object)3.0)), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0), builder.build());
    }

    @Test
    public void testArrayDoubleMap() {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_agg"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, DoubleType.DOUBLE}), (Object)ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)1.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)2.0, (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)3.0), BlockAssertions.createStringArraysBlock((Iterable<? extends Iterable<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)ImmutableList.of((Object)"e", (Object)"f"))), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0));
    }
}

