/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.SessionTestUtils;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionNullability;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.AggregatorFactory;
import io.trino.operator.aggregation.DistinctAccumulatorFactory;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.type.BlockTypeOperators;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public class TestingAggregationFunction {
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();
    private final List<Type> parameterTypes;
    private final Type intermediateType;
    private final Type finalType;
    private final AccumulatorFactory factory;
    private final DistinctAccumulatorFactory distinctFactory;

    public TestingAggregationFunction(BoundSignature signature, FunctionNullability functionNullability, AggregationMetadata aggregationMetadata) {
        this.parameterTypes = signature.getArgumentTypes();
        List intermediateTypes = (List)aggregationMetadata.getAccumulatorStateDescriptors().stream().map(stateDescriptor -> stateDescriptor.getSerializer().getSerializedType()).collect(ImmutableList.toImmutableList());
        this.intermediateType = intermediateTypes.size() == 1 ? (Type)Iterables.getOnlyElement((Iterable)intermediateTypes) : RowType.anonymous((List)intermediateTypes);
        this.finalType = signature.getReturnType();
        this.factory = AccumulatorCompiler.generateAccumulatorFactory((BoundSignature)signature, (AggregationMetadata)aggregationMetadata, (FunctionNullability)functionNullability, (List)ImmutableList.of());
        this.distinctFactory = new DistinctAccumulatorFactory(this.factory, this.parameterTypes, new JoinCompiler(TYPE_OPERATORS), new BlockTypeOperators(TYPE_OPERATORS), SessionTestUtils.TEST_SESSION);
    }

    public TestingAggregationFunction(List<Type> parameterTypes, List<Type> intermediateTypes, Type finalType, AccumulatorFactory factory) {
        this.parameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
        Objects.requireNonNull(intermediateTypes, "intermediateTypes is null");
        this.intermediateType = intermediateTypes.size() == 1 ? (Type)Iterables.getOnlyElement(intermediateTypes) : RowType.anonymous(intermediateTypes);
        this.finalType = Objects.requireNonNull(finalType, "finalType is null");
        this.factory = Objects.requireNonNull(factory, "factory is null");
        this.distinctFactory = new DistinctAccumulatorFactory(factory, parameterTypes, new JoinCompiler(TYPE_OPERATORS), new BlockTypeOperators(TYPE_OPERATORS), SessionTestUtils.TEST_SESSION);
    }

    public int getParameterCount() {
        return this.parameterTypes.size();
    }

    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getIntermediateType() {
        return this.intermediateType;
    }

    public Type getFinalType() {
        return this.finalType;
    }

    public AggregatorFactory createAggregatorFactory(AggregationNode.Step step, List<Integer> inputChannels, OptionalInt maskChannel) {
        return this.createAggregatorFactory(step, inputChannels, maskChannel, this.factory);
    }

    public AggregatorFactory createDistinctAggregatorFactory(AggregationNode.Step step, List<Integer> inputChannels, OptionalInt maskChannel) {
        return this.createAggregatorFactory(step, inputChannels, maskChannel, (AccumulatorFactory)this.distinctFactory);
    }

    private AggregatorFactory createAggregatorFactory(AggregationNode.Step step, List<Integer> inputChannels, OptionalInt maskChannel, AccumulatorFactory distinctFactory) {
        return new AggregatorFactory(distinctFactory, step, this.intermediateType, this.finalType, inputChannels, maskChannel, true);
    }
}

