/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxby;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMinMaxByNAggregation {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();

    @Test
    public void testMaxDoubleDouble() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(new Double[]{null}), new Block[]{BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(3.0, 5.0), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(1.0), new Block[]{BlockAssertions.createDoublesBlock(null, 1.0, null, null), BlockAssertions.createDoublesBlock(null, 0.0, null, null), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(1.0), new Block[]{BlockAssertions.createDoublesBlock(1.0), BlockAssertions.createDoublesBlock(0.0), BlockAssertions.createRLEBlock(2L, 1)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createDoublesBlock(new Double[0]), BlockAssertions.createDoublesBlock(new Double[0]), BlockAssertions.createRLEBlock(2L, 0)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)2.5), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(1L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)2.5, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinDoubleDouble() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, Arrays.asList(new Double[]{null}), new Block[]{BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(5.0, 3.0), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(1L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)2.0, (Object)5.0), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinDoubleVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"z", (Object)"a"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createDoublesBlock(1.0, 2.0, 2.0, 3.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"b", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(Double.NaN, 2.0, 3.0, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, Double.NaN, 3.0, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, 2.0, Double.NaN, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0, Double.NaN), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b"), BlockAssertions.createDoublesBlock(1.0, Double.NaN), BlockAssertions.createRLEBlock(2L, 2)});
    }

    @Test
    public void testMaxDoubleVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"z"), new Block[]{BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createDoublesBlock(1.0, 2.0, null), BlockAssertions.createRLEBlock(2L, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"bb", (Object)"hi"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"hi", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"d", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(Double.NaN, 2.0, 3.0, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"d", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, Double.NaN, 3.0, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"d", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, 2.0, Double.NaN, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"c", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0, Double.NaN), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b"), BlockAssertions.createDoublesBlock(1.0, Double.NaN), BlockAssertions.createRLEBlock(2L, 2)});
    }

    @Test
    public void testMinRealVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, RealType.REAL, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"z", (Object)"a"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(-1.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), null, Float.valueOf(-1.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"b", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(Float.NaN), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN), Float.valueOf(3.0f), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(Float.NaN), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(Float.NaN)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN)), BlockAssertions.createRLEBlock(2L, 2)});
    }

    @Test
    public void testMaxRealVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, RealType.REAL, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"z"), new Block[]{BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), null), BlockAssertions.createRLEBlock(2L, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"bb", (Object)"hi"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(-1.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"hi", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), null, Float.valueOf(-1.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"d", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(Float.NaN), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"d", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN), Float.valueOf(3.0f), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"d", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(Float.NaN), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"c", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(Float.NaN)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN)), BlockAssertions.createRLEBlock(2L, 2)});
    }

    @Test
    public void testMinVarcharDouble() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)2.0, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 2.0, 3.0), BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)-1.0, (Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)-1.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMaxVarcharDouble() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)1.0, (Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, null), BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createRLEBlock(2L, 3)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)0.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)0.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinVarcharArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)4L, (Object)5L)), new Block[]{BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3L, (Object)4L), (Object)ImmutableList.of((Object)4L, (Object)5L))), BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMaxVarcharArray() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR, BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)3L, (Object)4L)), new Block[]{BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3L, (Object)4L), (Object)ImmutableList.of((Object)4L, (Object)5L))), BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinArrayVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"min_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"b", (Object)"x", (Object)"z"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)2L))), BlockAssertions.createRLEBlock(3L, 4)});
    }

    @Test
    public void testMaxArrayVarchar() {
        List parameterTypes = TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT});
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"max_by"), (List<TypeSignatureProvider>)parameterTypes, (Object)ImmutableList.of((Object)"a", (Object)"z", (Object)"x"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)2L))), BlockAssertions.createRLEBlock(3L, 4)});
    }

    @Test
    public void testOutOfBound() {
        TestingAggregationFunction function = FUNCTION_RESOLUTION.getAggregateFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}));
        try {
            AggregationTestUtils.groupedAggregation(function, new Page(new Block[]{BlockAssertions.createStringsBlock("z"), BlockAssertions.createLongsBlock(0), BlockAssertions.createLongsBlock(10001)}));
        }
        catch (TrinoException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"third argument of max_by/min_by must be less than or equal to 10000; found 10001");
        }
    }
}

