/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.FeaturesConfig;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.RegexLibrary;
import java.util.ArrayList;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestRegexpFunctions
extends AbstractTestFunctions {
    AbstractTestRegexpFunctions(RegexLibrary regexLibrary) {
        super(new FeaturesConfig().setRegexLibrary(regexLibrary));
    }

    @BeforeClass
    public void setUp() {
        this.registerScalar(AbstractTestRegexpFunctions.class);
    }

    @ScalarFunction(deterministic=false)
    @SqlType(value="varchar")
    public static Slice invalidUtf8() {
        return Slices.wrappedBuffer((byte[])new byte[]{65, 65, -19, -96, -128, 65, 65, 65, 65, -19, -65, -65, 65, 65, 65});
    }

    @Test
    public void testRegexpLike() {
        this.functionAssertions.tryEvaluate("REGEXP_LIKE(invalid_utf8(), invalid_utf8())", (Type)BooleanType.BOOLEAN);
        this.assertFunction("REGEXP_LIKE('Stephen', 'Ste(v|ph)en')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('Stevens', 'Ste(v|ph)en')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('Stephen', '^Ste(v|ph)en$')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('Stevens', '^Ste(v|ph)en$')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REGEXP_LIKE('hello world', '[a-z]')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('hello\nworld', '.*hello\nworld.*')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('Hello', '^[a-z]+$')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REGEXP_LIKE('Hello', '^(?i)[a-z]+$')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('Hello', '^[a-zA-Z]+$')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("REGEXP_LIKE('test', 'test\\b')", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testRegexCharLike() {
        this.assertFunction("REGEXP_LIKE('ala', CHAR 'ala  ')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("REGEXP_LIKE('ala  ', CHAR 'ala  ')", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testRegexpReplace() {
        this.assertFunction("REGEXP_REPLACE('abc\u6709\u670b$%X\u81ea9\u8fdc\u65b9\u6765', '', 'Y')", (Type)VarcharType.createVarcharType((int)97), "YaYbYcY\u6709Y\u670bY$Y%YXY\u81eaY9Y\u8fdcY\u65b9Y\u6765Y");
        this.assertFunction("REGEXP_REPLACE('a\u6709\u670b\ud83d\udcb0', '.', 'Y')", (Type)VarcharType.createVarcharType((int)14), "YYYY");
        this.assertFunction("REGEXP_REPLACE('a\u6709\u670b\ud83d\udcb0', '.', '1$02')", (Type)VarcharType.createVarcharType((int)44), "1a21\u670921\u670b21\ud83d\udcb02");
        this.assertFunction("REGEXP_REPLACE('', '', 'Y')", (Type)VarcharType.createVarcharType((int)1), "Y");
        this.assertFunction("REGEXP_REPLACE('fun stuff.', '[a-z]')", (Type)VarcharType.createVarcharType((int)10), " .");
        this.assertFunction("REGEXP_REPLACE('fun stuff.', '[a-z]', '*')", (Type)VarcharType.createVarcharType((int)65), "*** *****.");
        this.assertFunction("REGEXP_REPLACE('call 555.123.4444 now', '(\\d{3})\\.(\\d{3}).(\\d{4})')", (Type)VarcharType.createVarcharType((int)21), "call  now");
        this.assertFunction("REGEXP_REPLACE('call 555.123.4444 now', '(\\d{3})\\.(\\d{3}).(\\d{4})', '($1) $2-$3')", (Type)VarcharType.createVarcharType((int)2331), "call (555) 123-4444 now");
        this.assertFunction("REGEXP_REPLACE('xxx xxx xxx', 'x', 'x')", (Type)VarcharType.createVarcharType((int)71), "xxx xxx xxx");
        this.assertFunction("REGEXP_REPLACE('xxx xxx xxx', 'x', '\\x')", (Type)VarcharType.createVarcharType((int)143), "xxx xxx xxx");
        this.assertFunction("REGEXP_REPLACE('xxx', '', 'y')", (Type)VarcharType.createVarcharType((int)7), "yxyxyxy");
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', 'x', '\\')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertFunction("REGEXP_REPLACE('xxx xxx xxx', 'x', '$0')", (Type)VarcharType.createVarcharType((int)143), "xxx xxx xxx");
        this.assertFunction("REGEXP_REPLACE('xxx', '(x)', '$01')", (Type)VarcharType.createVarcharType((int)19), "xxx");
        this.assertFunction("REGEXP_REPLACE('xxx', 'x', '$05')", (Type)VarcharType.createVarcharType((int)19), "x5x5x5");
        this.assertFunction("REGEXP_REPLACE('123456789', '(1)(2)(3)(4)(5)(6)(7)(8)(9)', '$10')", (Type)VarcharType.createVarcharType((int)139), "10");
        this.assertFunction("REGEXP_REPLACE('1234567890', '(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)', '$10')", (Type)VarcharType.createVarcharType((int)175), "0");
        this.assertFunction("REGEXP_REPLACE('1234567890', '(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)', '$11')", (Type)VarcharType.createVarcharType((int)175), "11");
        this.assertFunction("REGEXP_REPLACE('1234567890', '(1)(2)(3)(4)(5)(6)(7)(8)(9)(0)', '$1a')", (Type)VarcharType.createVarcharType((int)175), "1a");
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', 'x', '$1')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', 'x', '$a')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', 'x', '$')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertFunction("REGEXP_REPLACE('wxyz', '(?<xyz>[xyz])', '${xyz}${xyz}')", (Type)VarcharType.createVarcharType((int)124), "wxxyyzz");
        this.assertFunction("REGEXP_REPLACE('wxyz', '(?<w>w)|(?<xyz>[xyz])', '[${w}](${xyz})')", (Type)VarcharType.createVarcharType((int)144), "[w]()[](x)[](y)[](z)");
        this.assertFunction("REGEXP_REPLACE('xyz', '(?<xyz>[xyz])+', '${xyz}')", (Type)VarcharType.createVarcharType((int)39), "z");
        this.assertFunction("REGEXP_REPLACE('xyz', '(?<xyz>[xyz]+)', '${xyz}')", (Type)VarcharType.createVarcharType((int)39), "xyz");
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', '(?<name>x)', '${}')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', '(?<name>x)', '${0}')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('xxx', '(?<name>x)', '${nam}')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertFunction("REGEXP_REPLACE(VARCHAR 'x', '.*', 'xxxxx')", (Type)VarcharType.createUnboundedVarcharType(), "xxxxxxxxxx");
    }

    @Test
    public void testRegexpReplaceLambda() {
        this.assertFunction("REGEXP_REPLACE('abc\u6709\u670b$%X\u81ea9\u8fdc\u65b9\u6765', '', x -> 'Y')", (Type)VarcharType.createUnboundedVarcharType(), "YaYbYcY\u6709Y\u670bY$Y%YXY\u81eaY9Y\u8fdcY\u65b9Y\u6765Y");
        this.assertFunction("REGEXP_REPLACE('a\u6709\u670b\ud83d\udcb0', '.', x -> 'Y')", (Type)VarcharType.createUnboundedVarcharType(), "YYYY");
        this.assertFunction("REGEXP_REPLACE('a\u6709\u670b\ud83d\udcb0', '(.)', x -> '1' || x[1] || '2')", (Type)VarcharType.createUnboundedVarcharType(), "1a21\u670921\u670b21\ud83d\udcb02");
        this.assertFunction("REGEXP_REPLACE('', '', x -> 'Y')", (Type)VarcharType.createUnboundedVarcharType(), "Y");
        this.assertFunction("REGEXP_REPLACE('x', '(x)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "X");
        this.assertFunction("REGEXP_REPLACE('xxx xxx xxx', '(x)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "XXX XXX XXX");
        this.assertFunction("REGEXP_REPLACE('new', '(\\w)', x -> x[1])", (Type)VarcharType.createUnboundedVarcharType(), "new");
        this.assertFunction("REGEXP_REPLACE('new', '(\\w)', x -> x[1] || upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "nNeEwW");
        this.assertFunction("REGEXP_REPLACE('new york', '(\\w)(\\w*)', x -> upper(x[1]) || lower(x[2]))", (Type)VarcharType.createUnboundedVarcharType(), "New York");
        this.assertFunction("REGEXP_REPLACE('new york', '((\\w)(\\w*))', x -> upper(x[2]) || lower(x[3]))", (Type)VarcharType.createUnboundedVarcharType(), "New York");
        this.assertFunction("REGEXP_REPLACE('new york', '(n\\w*)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "NEW york");
        this.assertFunction("REGEXP_REPLACE('new york', '(y\\w*)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "new YORK");
        this.assertFunction("REGEXP_REPLACE('new york city', '(yo\\w*)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "new YORK city");
        this.assertFunction("REGEXP_REPLACE('abc abc', '(abc)', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "m m");
        this.assertFunction("REGEXP_REPLACE('123 456', '([0-9]*)', x -> x[1])", (Type)VarcharType.createUnboundedVarcharType(), "123 456");
        this.assertFunction("REGEXP_REPLACE('123 456', '(([0-9]*) ([0-9]*))', x -> x[2] || x[3])", (Type)VarcharType.createUnboundedVarcharType(), "123456");
        this.assertFunction("REGEXP_REPLACE('abbabba', '(abba)', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "mbba");
        this.assertFunction("REGEXP_REPLACE('abbabba', '(abba)', x -> 'm' || x[1])", (Type)VarcharType.createUnboundedVarcharType(), "mabbabba");
        this.assertFunction("REGEXP_REPLACE('abcde', 'ab(c)?de', x -> CASE WHEN x[1] IS NULL THEN 'foo' ELSE 'bar' END)", (Type)VarcharType.createUnboundedVarcharType(), "bar");
        this.assertFunction("REGEXP_REPLACE('abc', '(.)', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "mmm");
        this.assertFunction("REGEXP_REPLACE('abc', '.', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "mmm");
        this.assertFunction("REGEXP_REPLACE('abbabba', 'abba', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "mbba");
        this.assertFunction("REGEXP_REPLACE('abc abc', 'abc', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "m m");
        this.assertFunction("REGEXP_REPLACE('abc', '', x -> 'OK')", (Type)VarcharType.createUnboundedVarcharType(), "OKaOKbOKcOK");
        this.assertFunction("REGEXP_REPLACE('abc', '()', x -> x[1])", (Type)VarcharType.createUnboundedVarcharType(), "abc");
        this.assertFunction("REGEXP_REPLACE('abc', '()', x -> 'OK')", (Type)VarcharType.createUnboundedVarcharType(), "OKaOKbOKcOK");
        this.assertFunction("REGEXP_REPLACE('new', '(\\w*)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "NEW");
        this.assertFunction("REGEXP_REPLACE('new', '(\\w*)', x -> x[1] || upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "newNEW");
        this.assertFunction("REGEXP_REPLACE('new', '(\\w*)', x -> CAST(length(x[1]) AS VARCHAR))", (Type)VarcharType.createUnboundedVarcharType(), "30");
        this.assertFunction("REGEXP_REPLACE('new york', '(\\w*)', x -> '<' || x[1] || '>')", (Type)VarcharType.createUnboundedVarcharType(), "<new><> <york><>");
        this.assertFunction("REGEXP_REPLACE('aaa', '(b)?', x -> x[1] )", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abde', 'ab(c)?de', x -> x[1])", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abde', 'ab(c)?de', x -> 'OK')", (Type)VarcharType.createUnboundedVarcharType(), "OK");
        this.assertFunction("REGEXP_REPLACE('abde', 'ab(c)?de', x -> x[1] || 'OK')", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abde', 'ab(c)?de', x -> 'OK' || x[1])", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abde', 'ab(c)?de', x -> CASE WHEN x[1] IS NULL THEN 'foo' ELSE 'bar' END)", (Type)VarcharType.createUnboundedVarcharType(), "foo");
        this.assertFunction("REGEXP_REPLACE('ab', '(a)?(b)?', x -> CASE WHEN (x[1] IS NOT NULL) AND (x[2] IS NOT NULL) THEN 'foo' ELSE NULL END)", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('aaa', '(a)', x -> CAST(NULL AS VARCHAR))", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('ab', '(a)?(b)?', x -> CASE WHEN (x[1] IS NOT NULL) AND (x[2] IS NULL) OR (x[1] IS NULL) AND (x[2] IS NOT NULL) THEN 'foo' ELSE NULL END)", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abacdb', '(a)?(b)?', x -> CASE WHEN (x[1] IS NOT NULL) AND (x[2] IS NULL) OR (x[1] IS NULL) AND (x[2] IS NOT NULL) THEN 'foo' ELSE NULL END)", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('new york', '(a)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "new york");
        this.assertFunction("REGEXP_REPLACE('', '(a)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), "");
        this.assertFunction("REGEXP_REPLACE(null, '(a)', x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('new', null, x -> upper(x[1]))", (Type)VarcharType.createUnboundedVarcharType(), null);
        this.assertFunction("REGEXP_REPLACE('abde', '(c)', x -> x[1])", (Type)VarcharType.createUnboundedVarcharType(), "abde");
        this.assertFunction("REGEXP_REPLACE('abde', '(c)', x -> 'm')", (Type)VarcharType.createUnboundedVarcharType(), "abde");
        this.assertInvalidFunction("REGEXP_REPLACE('new', '(\\w)', x -> upper(x[2]))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('new', '(\\w)', x -> upper(x[0]))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('abc', '', x -> x[1])", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('x', 'x', x -> upper(x[1]))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_REPLACE('abbabba', 'abba', x -> 'm' || x[1])", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testRegexpExtract() {
        this.assertFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)')", (Type)VarcharType.createVarcharType((int)15), "world");
        this.assertFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)', 1)", (Type)VarcharType.createVarcharType((int)15), "orld");
        this.assertFunction("REGEXP_EXTRACT('rat cat\nbat dog', 'ra(.)|blah(.)(.)', 2)", (Type)VarcharType.createVarcharType((int)15), null);
        this.assertFunction("REGEXP_EXTRACT('12345', 'x')", (Type)VarcharType.createVarcharType((int)5), null);
        this.assertFunction("REGEXP_EXTRACT('Baby X', 'by ([A-Z].*)\\b[a-z]')", (Type)VarcharType.createVarcharType((int)6), null);
        this.assertInvalidFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)', -1)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_EXTRACT('Hello world bye', '\\b[a-z]([a-z]*)', 2)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testRegexpExtractAll() {
        this.assertFunction("REGEXP_EXTRACT_ALL('abc\u6709\u670b$%X\u81ea9\u8fdc\u65b9\u6765\ud83d\udcb0', '')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)14)), ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object[])new String[]{"", "", ""}));
        this.assertFunction("REGEXP_EXTRACT_ALL('a\u6709\u670b\ud83d\udcb0', '.')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), ImmutableList.of((Object)"a", (Object)"\u6709", (Object)"\u670b", (Object)"\ud83d\udcb0"));
        this.assertFunction("REGEXP_EXTRACT_ALL('', '')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)0)), ImmutableList.of((Object)""));
        this.assertFunction("REGEXP_EXTRACT_ALL('rat cat\nbat dog', '.at')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)15)), ImmutableList.of((Object)"rat", (Object)"cat", (Object)"bat"));
        this.assertFunction("REGEXP_EXTRACT_ALL('rat cat\nbat dog', '(.)at', 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)15)), ImmutableList.of((Object)"r", (Object)"c", (Object)"b"));
        ArrayList<Object> nullList = new ArrayList<Object>();
        nullList.add(null);
        this.assertFunction("REGEXP_EXTRACT_ALL('rat cat\nbat dog', 'ra(.)|blah(.)(.)', 2)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)15)), nullList);
        this.assertInvalidFunction("REGEXP_EXTRACT_ALL('hello', '(.)', 2)", "Pattern has 1 groups. Cannot access group 2");
        this.assertFunction("REGEXP_EXTRACT_ALL('12345', '')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)5)), ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)"", (Object)"", (Object)""));
        this.assertInvalidFunction("REGEXP_EXTRACT_ALL('12345', '(')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testRegexpSplit() {
        this.assertFunction("REGEXP_SPLIT('abc\u6709\u670b$%X\u81ea9\u8fdc\u65b9\u6765\ud83d\udcb0', '')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)14)), ImmutableList.of((Object)"", (Object)"a", (Object)"b", (Object)"c", (Object)"\u6709", (Object)"\u670b", (Object)"$", (Object)"%", (Object)"X", (Object)"\u81ea", (Object)"9", (Object)"\u8fdc", (Object[])new String[]{"\u65b9", "\u6765", "\ud83d\udcb0", ""}));
        this.assertFunction("REGEXP_SPLIT('a\u6709\u670b\ud83d\udcb0', '.')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)"", (Object)""));
        this.assertFunction("REGEXP_SPLIT('', '')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)0)), ImmutableList.of((Object)"", (Object)""));
        this.assertFunction("REGEXP_SPLIT('abc', 'a')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"", (Object)"bc"));
        this.assertFunction("REGEXP_SPLIT('a.b:c;d', '[\\.:;]')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        this.assertFunction("REGEXP_SPLIT('a.b:c;d', '\\.')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a", (Object)"b:c;d"));
        this.assertFunction("REGEXP_SPLIT('a.b:c;d', ':')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a.b", (Object)"c;d"));
        this.assertFunction("REGEXP_SPLIT('a,b,c', ',')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)5)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        this.assertFunction("REGEXP_SPLIT('a1b2c3d', '\\d')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        this.assertFunction("REGEXP_SPLIT('a1b2346c3d', '\\d+')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)10)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        this.assertFunction("REGEXP_SPLIT('abcd', 'x')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), ImmutableList.of((Object)"abcd"));
        this.assertFunction("REGEXP_SPLIT('abcd', '')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)4)), ImmutableList.of((Object)"", (Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)""));
        this.assertFunction("REGEXP_SPLIT('', 'x')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)0)), ImmutableList.of((Object)""));
        this.assertFunction("REGEXP_SPLIT('a,b,c,d', ',')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"));
        this.assertFunction("REGEXP_SPLIT(',,a,,,b,c,d,,', ',')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)13)), ImmutableList.of((Object)"", (Object)"", (Object)"a", (Object)"", (Object)"", (Object)"b", (Object)"c", (Object)"d", (Object)"", (Object)""));
        this.assertFunction("REGEXP_SPLIT(',,,', ',')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)""));
    }

    @Test
    public void testRegexpCount() {
        this.assertRegexpCount("a.b:c;d", "[\\.:;]", 3L);
        this.assertRegexpCount("a.b:c;d", "\\.", 1L);
        this.assertRegexpCount("a.b:c;d", ":", 1L);
        this.assertRegexpCount("a,b,c", ",", 2L);
        this.assertRegexpCount("a1b2c3d", "\\d", 3L);
        this.assertRegexpCount("a1b2346c3d", "\\d+", 3L);
        this.assertRegexpCount("abcd", "x", 0L);
        this.assertRegexpCount("Hello world bye", "\\b[a-z]([a-z]*)", 2L);
        this.assertRegexpCount("rat cat\nbat dog", "ra(.)|blah(.)(.)", 1L);
        this.assertRegexpCount("Baby X", "by ([A-Z].*)\\b[a-z]", 0L);
        this.assertRegexpCount("rat cat bat dog", ".at", 3L);
        this.assertRegexpCount("", "x", 0L);
        this.assertRegexpCount("", "", 1L);
        this.assertRegexpCount("\u541b\u5b50\u77dc\u800c\u4e0d\u4e89\uff0c\u515a\u800c\u4e0d\u7fa4", "\u4e0d", 2L);
        this.assertRegexpCount("abcd", "", 5L);
        this.assertRegexpCount("1a 2b 14m", "\\s*[a-z]+\\s*", 3L);
    }

    @Test
    public void testRegexpPosition() {
        this.assertRegexpPosition("a.b:c;d", "[\\.:;]", 2);
        this.assertRegexpPosition("a.b:c;d", "\\.", 2);
        this.assertRegexpPosition("a.b:c;d", ":", 4);
        this.assertRegexpPosition("a,b,c", ",", 2);
        this.assertRegexpPosition("a1b2c3d", "\\d", 2);
        this.assertRegexpPosition("a,b,c", ",", 3, 4);
        this.assertRegexpPosition("a1b2c3d", "\\d", 5, 6);
        this.assertRegexpPosition("a1b2c3d4e", "\\d", 4, 2, 6);
        this.assertRegexpPosition("a1b2c3d", "\\d", 4, 3, -1);
        this.assertRegexpPosition("a1b2c3d", "", 1);
        this.assertRegexpPosition("a1b2c3d", "", 2, 2);
        this.assertRegexpPosition("a1b2c3d", "", 2, 2, 3);
        this.assertRegexpPosition("a1b2c3d", "", 2, 6, 7);
        this.assertRegexpPosition("a1b2c3d", "", 2, 7, 8);
        this.assertRegexpPosition("a1b2c3d", "", 2, 8, -1);
        this.assertRegexpPosition("\u884c\u6210\u4e8e\u601dstr\u800c\u6bc1123\u4e8e\u968f", "\u4e8e", 3, 2, 13);
        this.assertRegexpPosition("\u884c\u6210\u4e8e\u601dstr\u800c\u6bc1123\u4e8e\u968f", "", 3, 2, 4);
        this.assertRegexpPosition("\u884c\u6210\u4e8e\u601dstr\u800c\u6bc1123\u4e8e\u968f", "", 3, 1, 3);
        this.assertRegexpPosition("", ", ", -1);
        this.assertRegexpPosition("", ", ", 4, -1);
        this.assertRegexpPosition("", ", ", 4, 2, -1);
        this.assertRegexpPosition("a,b,c", ",", 2, 2);
        this.assertRegexpPosition("a1b2c3d", "\\d", 4, 4);
        this.assertRegexpPosition("\u6709\u670b$%X\u81ea9\u8fdc\u65b9\u6765", "\\d", 7, 7);
        this.assertRegexpPosition("\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765", "\\d", 10, 1, 10);
        this.assertRegexpPosition("\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765", "\\d", 10, 2, -1);
        this.assertRegexpPosition("a,b,c", ", ", 1000, -1);
        this.assertRegexpPosition("a,b,c", ", ", 8, -1);
        this.assertRegexpPosition("\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765", "\u6765", 999, -1);
        this.assertInvalidFunction("REGEXP_POSITION('\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765', '\u6765', -1, 0)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_POSITION('\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765', '\u6765', 1, 0)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("REGEXP_POSITION('\u6709\u670b$%X\u81ea9\u8fdc\u65b99\u6765', '\u6765', 1, -1)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertRegexpPosition("9102, say good bye", "\\s*[a-z]+\\s*", 6);
        this.assertRegexpPosition("natasha, 9102, miss you", "\\s*[a-z]+\\s*", 10, 15);
        this.assertRegexpPosition("natasha, 9102, miss you", "\\s", 10, 2, 20);
    }

    private void assertRegexpCount(String source, String pattern, long expectCount) {
        this.assertFunction(String.format("REGEXP_COUNT('%s', '%s')", source, pattern), (Type)BigintType.BIGINT, expectCount);
        this.assertFunction(String.format("CARDINALITY(REGEXP_EXTRACT_ALL('%s', '%s'))", source, pattern), (Type)BigintType.BIGINT, expectCount);
    }

    private void assertRegexpPosition(String source, String pattern, int expectPosition) {
        this.assertFunction(String.format("REGEXP_POSITION('%s', '%s')", source, pattern), (Type)IntegerType.INTEGER, expectPosition);
    }

    private void assertRegexpPosition(String source, String pattern, int start, int expectPosition) {
        this.assertFunction(String.format("REGEXP_POSITION('%s', '%s', %d)", source, pattern, start), (Type)IntegerType.INTEGER, expectPosition);
    }

    private void assertRegexpPosition(String source, String pattern, int start, int occurrence, int expectPosition) {
        this.assertFunction(String.format("REGEXP_POSITION('%s', '%s', %d, %d)", source, pattern, start, occurrence), (Type)IntegerType.INTEGER, expectPosition);
    }
}

