/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionListBuilder;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.VariableReferenceExpression;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.FunctionType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayFilter {
    private static final int POSITIONS = 100000;
    private static final int ARRAY_SIZE = 4;
    private static final int NUM_TYPES = 1;
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);

    @Benchmark
    @OperationsPerInvocation(value=400000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArrayFilter().benchmark(data);
        Benchmarks.benchmark(BenchmarkArrayFilter.class).run();
    }

    static {
        Verify.verify((1 == TYPES.size() ? 1 : 0) != 0);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"filter", "exact_filter"})
        private String name = "filter";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            TestingFunctionResolution functionResolution = new TestingFunctionResolution().addFunctions(new FunctionListBuilder().function((SqlFunction)ExactArrayFilterFunction.EXACT_ARRAY_FILTER_FUNCTION).getFunctions());
            ExpressionCompiler compiler = functionResolution.getExpressionCompiler();
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            Block[] blocks = new Block[TYPES.size()];
            for (int i = 0; i < TYPES.size(); ++i) {
                Type elementType = TYPES.get(i);
                ArrayType arrayType = new ArrayType(elementType);
                ResolvedFunction resolvedFunction = functionResolution.resolveFunction(QualifiedName.of((String)this.name), TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, new FunctionType((List)ImmutableList.of((Object)BigintType.BIGINT), (Type)BooleanType.BOOLEAN)}));
                ResolvedFunction lessThan = functionResolution.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
                projectionsBuilder.add((Object)new CallExpression(resolvedFunction, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)new LambdaDefinitionExpression((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)"x"), (RowExpression)new CallExpression(lessThan, (List)ImmutableList.of((Object)Expressions.constant((Object)0L, (Type)BigintType.BIGINT), (Object)new VariableReferenceExpression("x", (Type)BigintType.BIGINT)))))));
                blocks[i] = BenchmarkData.createChannel(100000, 4, arrayType);
            }
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(blocks);
        }

        private static Block createChannel(int positionCount, int arraySize, ArrayType arrayType) {
            BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
                for (int i = 0; i < arraySize; ++i) {
                    if (arrayType.getElementType().getJavaType() != Long.TYPE) {
                        throw new UnsupportedOperationException();
                    }
                    arrayType.getElementType().writeLong(entryBuilder, ThreadLocalRandom.current().nextLong());
                }
                blockBuilder.closeEntry();
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }

    public static final class ExactArrayFilterFunction
    extends SqlScalarFunction {
        public static final ExactArrayFilterFunction EXACT_ARRAY_FILTER_FUNCTION = new ExactArrayFilterFunction();
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ExactArrayFilterFunction.class, (String)"filter", (Class[])new Class[]{Type.class, Block.class, MethodHandle.class});

        private ExactArrayFilterFunction() {
            super(new FunctionMetadata(new Signature("exact_filter", (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), (List)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), (Object)TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{BooleanType.BOOLEAN.getTypeSignature()})), false), new FunctionNullability(false, (List)ImmutableList.of((Object)false, (Object)false)), false, false, "return array containing elements that match the given predicate", FunctionKind.SCALAR));
        }

        protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
            Type type = ((ArrayType)boundSignature.getReturnType()).getElementType();
            return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), METHOD_HANDLE.bindTo(type));
        }

        public static Block filter(Type type, Block block, MethodHandle function) {
            int positionCount = block.getPositionCount();
            BlockBuilder resultBuilder = type.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                Boolean keep;
                Long input = (Long)TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
                try {
                    keep = function.invokeExact(input);
                }
                catch (Throwable t) {
                    Throwables.throwIfUnchecked((Throwable)t);
                    throw new RuntimeException(t);
                }
                if (!Boolean.TRUE.equals(keep)) continue;
                block.writePositionTo(position, resultBuilder);
            }
            return resultBuilder.build();
        }
    }
}

