/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.VariableReferenceExpression;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.FunctionType;
import io.trino.util.StructuralTestUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkTransformKey {
    private static final int POSITIONS = 100000;
    private static final int NUM_TYPES = 2;

    @Benchmark
    @OperationsPerInvocation(value=200000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkTransformKey().benchmark(data);
        Benchmarks.benchmark(BenchmarkTransformKey.class, (WarmupMode)WarmupMode.BULK).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"DOUBLE", "BIGINT"})
        private String type = "DOUBLE";
        private String name = "transform_keys";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            Number increment;
            BigintType elementType;
            TestingFunctionResolution functionResolution = new TestingFunctionResolution();
            ExpressionCompiler compiler = functionResolution.getExpressionCompiler();
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            switch (this.type) {
                case "BIGINT": {
                    elementType = BigintType.BIGINT;
                    increment = 1L;
                    break;
                }
                case "DOUBLE": {
                    elementType = DoubleType.DOUBLE;
                    increment = 1.0;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            MapType mapType = StructuralTestUtil.mapType((Type)elementType, (Type)elementType);
            ResolvedFunction resolvedFunction = functionResolution.resolveFunction(QualifiedName.of((String)this.name), TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType, new FunctionType((List)ImmutableList.of((Object)elementType, (Object)elementType), (Type)elementType)}));
            ResolvedFunction add = functionResolution.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)elementType, (Object)elementType));
            projectionsBuilder.add((Object)Expressions.call((ResolvedFunction)resolvedFunction, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)mapType), (Object)new LambdaDefinitionExpression((List)ImmutableList.of((Object)elementType, (Object)elementType), (List)ImmutableList.of((Object)"x", (Object)"y"), (RowExpression)Expressions.call((ResolvedFunction)add, (List)ImmutableList.of((Object)new VariableReferenceExpression("x", (Type)elementType), (Object)Expressions.constant((Object)increment, (Type)elementType)))))));
            Block block = BenchmarkData.createChannel(100000, mapType, (Type)elementType);
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{block});
        }

        private static Block createChannel(int positionCount, MapType mapType, Type elementType) {
            BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 1);
            BlockBuilder singleMapBlockWriter = mapBlockBuilder.beginBlockEntry();
            for (int position = 0; position < positionCount; ++position) {
                Number value;
                if (elementType.equals(BigintType.BIGINT)) {
                    value = ThreadLocalRandom.current().nextLong();
                } else if (elementType.equals(DoubleType.DOUBLE)) {
                    value = ThreadLocalRandom.current().nextDouble();
                } else {
                    throw new UnsupportedOperationException();
                }
                TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)singleMapBlockWriter, (Object)position);
                TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)singleMapBlockWriter, (Object)value);
            }
            mapBlockBuilder.closeEntry();
            return mapBlockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

