/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import org.testng.annotations.Test;

public class TestBitwiseFunctions
extends AbstractTestFunctions {
    @Test
    public void testBitCount() {
        this.assertFunction("bit_count(0, 64)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bit_count(7, 64)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("bit_count(24, 64)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("bit_count(-8, 64)", (Type)BigintType.BIGINT, 61L);
        this.assertFunction("bit_count(2147483647, 64)", (Type)BigintType.BIGINT, 31L);
        this.assertFunction("bit_count(-2147483648, 64)", (Type)BigintType.BIGINT, 33L);
        this.assertFunction("bit_count(9223372036854775807, 64)", (Type)BigintType.BIGINT, 63L);
        this.assertFunction("bit_count(-9223372036854775807-1, 64)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("bit_count(0, 32)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bit_count(7, 32)", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("bit_count(24, 32)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("bit_count(-8, 32)", (Type)BigintType.BIGINT, 29L);
        this.assertFunction("bit_count(2147483647, 32)", (Type)BigintType.BIGINT, 31L);
        this.assertFunction("bit_count(-2147483648, 32)", (Type)BigintType.BIGINT, 1L);
        this.assertInvalidFunction("bit_count(2147483648, 32)", "Number must be representable with the bits specified. 2147483648 cannot be represented with 32 bits");
        this.assertInvalidFunction("bit_count(-2147483649, 32)", "Number must be representable with the bits specified. -2147483649 cannot be represented with 32 bits");
        this.assertFunction("bit_count(1152921504598458367, 62)", (Type)BigintType.BIGINT, 59L);
        this.assertFunction("bit_count(-1, 62)", (Type)BigintType.BIGINT, 62L);
        this.assertFunction("bit_count(33554132, 26)", (Type)BigintType.BIGINT, 20L);
        this.assertFunction("bit_count(-1, 26)", (Type)BigintType.BIGINT, 26L);
        this.assertInvalidFunction("bit_count(1152921504598458367, 60)", "Number must be representable with the bits specified. 1152921504598458367 cannot be represented with 60 bits");
        this.assertInvalidFunction("bit_count(33554132, 25)", "Number must be representable with the bits specified. 33554132 cannot be represented with 25 bits");
        this.assertInvalidFunction("bit_count(0, -1)", "Bits specified in bit_count must be between 2 and 64, got -1");
        this.assertInvalidFunction("bit_count(0, 1)", "Bits specified in bit_count must be between 2 and 64, got 1");
        this.assertInvalidFunction("bit_count(0, 65)", "Bits specified in bit_count must be between 2 and 64, got 65");
    }

    @Test
    public void testBitwiseNot() {
        this.assertFunction("bitwise_not(0)", (Type)BigintType.BIGINT, -1L);
        this.assertFunction("bitwise_not(-1)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bitwise_not(8)", (Type)BigintType.BIGINT, -9L);
        this.assertFunction("bitwise_not(-8)", (Type)BigintType.BIGINT, 7L);
        this.assertFunction("bitwise_not(9223372036854775807)", (Type)BigintType.BIGINT, Long.MIN_VALUE);
        this.assertFunction("bitwise_not(-9223372036854775807-1)", (Type)BigintType.BIGINT, Long.MAX_VALUE);
    }

    @Test
    public void testBitwiseAnd() {
        this.assertFunction("bitwise_and(0, -1)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bitwise_and(3, 8)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bitwise_and(-4, 12)", (Type)BigintType.BIGINT, 12L);
        this.assertFunction("bitwise_and(60, 21)", (Type)BigintType.BIGINT, 20L);
    }

    @Test
    public void testBitwiseOr() {
        this.assertFunction("bitwise_or(0, -1)", (Type)BigintType.BIGINT, -1L);
        this.assertFunction("bitwise_or(3, 8)", (Type)BigintType.BIGINT, 11L);
        this.assertFunction("bitwise_or(-4, 12)", (Type)BigintType.BIGINT, -4L);
        this.assertFunction("bitwise_or(60, 21)", (Type)BigintType.BIGINT, 61L);
    }

    @Test
    public void testBitwiseXor() {
        this.assertFunction("bitwise_xor(0, -1)", (Type)BigintType.BIGINT, -1L);
        this.assertFunction("bitwise_xor(3, 8)", (Type)BigintType.BIGINT, 11L);
        this.assertFunction("bitwise_xor(-4, 12)", (Type)BigintType.BIGINT, -16L);
        this.assertFunction("bitwise_xor(60, 21)", (Type)BigintType.BIGINT, 41L);
    }

    @Test
    public void testBitwiseLeftShift() {
        this.assertFunction("bitwise_left_shift(TINYINT'7', 2)", (Type)TinyintType.TINYINT, (byte)28);
        this.assertFunction("bitwise_left_shift(TINYINT '-7', 2)", (Type)TinyintType.TINYINT, (byte)-28);
        this.assertFunction("bitwise_left_shift(TINYINT '1', 7)", (Type)TinyintType.TINYINT, (byte)-128);
        this.assertFunction("bitwise_left_shift(TINYINT '-128', 1)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("bitwise_left_shift(TINYINT '-65', 1)", (Type)TinyintType.TINYINT, (byte)126);
        this.assertFunction("bitwise_left_shift(TINYINT '-7', 64)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("bitwise_left_shift(TINYINT '-128', 0)", (Type)TinyintType.TINYINT, (byte)-128);
        this.assertFunction("bitwise_left_shift(SMALLINT '7', 2)", (Type)SmallintType.SMALLINT, (short)28);
        this.assertFunction("bitwise_left_shift(SMALLINT '-7', 2)", (Type)SmallintType.SMALLINT, (short)-28);
        this.assertFunction("bitwise_left_shift(SMALLINT '1', 7)", (Type)SmallintType.SMALLINT, (short)128);
        this.assertFunction("bitwise_left_shift(SMALLINT '-32768', 1)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("bitwise_left_shift(SMALLINT '-65', 1)", (Type)SmallintType.SMALLINT, (short)-130);
        this.assertFunction("bitwise_left_shift(SMALLINT '-7', 64)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("bitwise_left_shift(SMALLINT '-32768', 0)", (Type)SmallintType.SMALLINT, (short)Short.MIN_VALUE);
        this.assertFunction("bitwise_left_shift(INTEGER '7', 2)", (Type)IntegerType.INTEGER, 28);
        this.assertFunction("bitwise_left_shift(INTEGER '-7', 2)", (Type)IntegerType.INTEGER, -28);
        this.assertFunction("bitwise_left_shift(INTEGER '1', 7)", (Type)IntegerType.INTEGER, 128);
        this.assertFunction("bitwise_left_shift(INTEGER '-2147483648', 1)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("bitwise_left_shift(INTEGER '-65', 1)", (Type)IntegerType.INTEGER, -130);
        this.assertFunction("bitwise_left_shift(INTEGER '-7', 64)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("bitwise_left_shift(INTEGER '-2147483648', 0)", (Type)IntegerType.INTEGER, Integer.MIN_VALUE);
        this.assertFunction("bitwise_left_shift(BIGINT '7', 2)", (Type)BigintType.BIGINT, 28L);
        this.assertFunction("bitwise_left_shift(BIGINT '-7', 2)", (Type)BigintType.BIGINT, -28L);
        this.assertFunction("bitwise_left_shift(BIGINT '-7', 64)", (Type)BigintType.BIGINT, 0L);
    }

    @Test
    public void testBitwiseRightShift() {
        this.assertFunction("bitwise_right_shift(TINYINT '7', 2)", (Type)TinyintType.TINYINT, (byte)1);
        this.assertFunction("bitwise_right_shift(TINYINT '-7', 2)", (Type)TinyintType.TINYINT, (byte)62);
        this.assertFunction("bitwise_right_shift(TINYINT '-7', 64)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("bitwise_right_shift(TINYINT '-128', 0)", (Type)TinyintType.TINYINT, (byte)-128);
        this.assertFunction("bitwise_right_shift(SMALLINT '7', 2)", (Type)SmallintType.SMALLINT, (short)1);
        this.assertFunction("bitwise_right_shift(SMALLINT '-7', 2)", (Type)SmallintType.SMALLINT, (short)16382);
        this.assertFunction("bitwise_right_shift(SMALLINT '-7', 64)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("bitwise_right_shift(SMALLINT '-32768', 0)", (Type)SmallintType.SMALLINT, (short)Short.MIN_VALUE);
        this.assertFunction("bitwise_right_shift(INTEGER '7', 2)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("bitwise_right_shift(INTEGER '-7', 2)", (Type)IntegerType.INTEGER, 0x3FFFFFFE);
        this.assertFunction("bitwise_right_shift(INTEGER '-7', 64)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("bitwise_right_shift(INTEGER '-2147483648', 0)", (Type)IntegerType.INTEGER, Integer.MIN_VALUE);
        this.assertFunction("bitwise_right_shift(BIGINT '7', 2)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("bitwise_right_shift(BIGINT '-7', 2)", (Type)BigintType.BIGINT, 0x3FFFFFFFFFFFFFFEL);
        this.assertFunction("bitwise_right_shift(BIGINT '-7', 64)", (Type)BigintType.BIGINT, 0L);
    }

    @Test
    public void testBitwiseRightShiftArithmetic() {
        this.assertFunction("bitwise_right_shift_arithmetic(TINYINT '7', 2)", (Type)TinyintType.TINYINT, (byte)1);
        this.assertFunction("bitwise_right_shift_arithmetic(TINYINT '-7', 2)", (Type)TinyintType.TINYINT, (byte)-2);
        this.assertFunction("bitwise_right_shift_arithmetic(TINYINT '7', 64)", (Type)TinyintType.TINYINT, (byte)0);
        this.assertFunction("bitwise_right_shift_arithmetic(TINYINT '-7', 64)", (Type)TinyintType.TINYINT, (byte)-1);
        this.assertFunction("bitwise_right_shift_arithmetic(TINYINT '-128', 0)", (Type)TinyintType.TINYINT, (byte)-128);
        this.assertFunction("bitwise_right_shift_arithmetic(SMALLINT '7', 2)", (Type)SmallintType.SMALLINT, (short)1);
        this.assertFunction("bitwise_right_shift_arithmetic(SMALLINT '-7', 2)", (Type)SmallintType.SMALLINT, (short)-2);
        this.assertFunction("bitwise_right_shift_arithmetic(SMALLINT '7', 64)", (Type)SmallintType.SMALLINT, (short)0);
        this.assertFunction("bitwise_right_shift_arithmetic(SMALLINT '-7', 64)", (Type)SmallintType.SMALLINT, (short)-1);
        this.assertFunction("bitwise_right_shift_arithmetic(SMALLINT '-32768', 0)", (Type)SmallintType.SMALLINT, (short)Short.MIN_VALUE);
        this.assertFunction("bitwise_right_shift_arithmetic(INTEGER '7', 2)", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("bitwise_right_shift_arithmetic(INTEGER '-7', 2)", (Type)IntegerType.INTEGER, -2);
        this.assertFunction("bitwise_right_shift_arithmetic(INTEGER '7', 64)", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("bitwise_right_shift_arithmetic(INTEGER '-7', 64)", (Type)IntegerType.INTEGER, -1);
        this.assertFunction("bitwise_right_shift_arithmetic(INTEGER '-2147483648', 0)", (Type)IntegerType.INTEGER, Integer.MIN_VALUE);
        this.assertFunction("bitwise_right_shift_arithmetic(BIGINT '7', 2)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("bitwise_right_shift_arithmetic(BIGINT '-7', 2)", (Type)BigintType.BIGINT, -2L);
        this.assertFunction("bitwise_right_shift_arithmetic(BIGINT '7', 64)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("bitwise_right_shift_arithmetic(BIGINT '-7', 64)", (Type)BigintType.BIGINT, -1L);
    }
}

