/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import org.testng.annotations.Test;

public class TestDataSizeFunctions
extends AbstractTestFunctions {
    private static final Type DECIMAL = DecimalType.createDecimalType((int)38, (int)0);

    @Test
    public void testParseDataSize() {
        this.assertFunction("parse_data_size('0B')", DECIMAL, TestDataSizeFunctions.decimal("0"));
        this.assertFunction("parse_data_size('1B')", DECIMAL, TestDataSizeFunctions.decimal("1"));
        this.assertFunction("parse_data_size('1.2B')", DECIMAL, TestDataSizeFunctions.decimal("1"));
        this.assertFunction("parse_data_size('1.9B')", DECIMAL, TestDataSizeFunctions.decimal("1"));
        this.assertFunction("parse_data_size('2.2kB')", DECIMAL, TestDataSizeFunctions.decimal("2252"));
        this.assertFunction("parse_data_size('2.23kB')", DECIMAL, TestDataSizeFunctions.decimal("2283"));
        this.assertFunction("parse_data_size('2.23kB')", DECIMAL, TestDataSizeFunctions.decimal("2283"));
        this.assertFunction("parse_data_size('2.234kB')", DECIMAL, TestDataSizeFunctions.decimal("2287"));
        this.assertFunction("parse_data_size('3MB')", DECIMAL, TestDataSizeFunctions.decimal("3145728"));
        this.assertFunction("parse_data_size('4GB')", DECIMAL, TestDataSizeFunctions.decimal("4294967296"));
        this.assertFunction("parse_data_size('4TB')", DECIMAL, TestDataSizeFunctions.decimal("4398046511104"));
        this.assertFunction("parse_data_size('5PB')", DECIMAL, TestDataSizeFunctions.decimal("5629499534213120"));
        this.assertFunction("parse_data_size('6EB')", DECIMAL, TestDataSizeFunctions.decimal("6917529027641081856"));
        this.assertFunction("parse_data_size('7ZB')", DECIMAL, TestDataSizeFunctions.decimal("8264141345021879123968"));
        this.assertFunction("parse_data_size('8YB')", DECIMAL, TestDataSizeFunctions.decimal("9671406556917033397649408"));
        this.assertFunction("parse_data_size('6917529027641081856EB')", DECIMAL, TestDataSizeFunctions.decimal("7975367974709495237422842361682067456"));
        this.assertFunction("parse_data_size('69175290276410818560EB')", DECIMAL, TestDataSizeFunctions.decimal("79753679747094952374228423616820674560"));
        this.assertInvalidFunction("parse_data_size('')", "Invalid data size: ''");
        this.assertInvalidFunction("parse_data_size('0')", "Invalid data size: '0'");
        this.assertInvalidFunction("parse_data_size('10KB')", "Invalid data size: '10KB'");
        this.assertInvalidFunction("parse_data_size('KB')", "Invalid data size: 'KB'");
        this.assertInvalidFunction("parse_data_size('-1B')", "Invalid data size: '-1B'");
        this.assertInvalidFunction("parse_data_size('12345K')", "Invalid data size: '12345K'");
        this.assertInvalidFunction("parse_data_size('A12345B')", "Invalid data size: 'A12345B'");
        this.assertInvalidFunction("parse_data_size('99999999999999YB')", (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Value out of range: '99999999999999YB' ('120892581961461708544797985370825293824B')");
    }
}

