/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.json.JsonCodec;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.FailureInfo;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.testing.LocalQueryRunner;
import io.trino.util.Failures;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestFailureFunction
extends AbstractTestFunctions {
    private static final String FAILURE_INFO = JsonCodec.jsonCodec(FailureInfo.class).toJson((Object)Failures.toFailure((Throwable)new RuntimeException("fail me")).toFailureInfo());

    @Test
    public void testFailure() {
        this.assertInvalidFunction("fail(json_parse('" + FAILURE_INFO + "'))", (ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "fail me");
    }

    @Test
    public void testQuery() {
        try (LocalQueryRunner runner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> runner.execute("select if(x, 78, 0/0) from (values rand() >= 0, rand() < 0) t(x)")).isInstanceOf(TrinoException.class)).hasMessageMatching("Division by zero");
        }
    }
}

