/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.SqlVarbinaryTestingUtil;
import io.trino.util.StructuralTestUtil;
import java.util.Collections;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestStringFunctions
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
    }

    @Description(value="Varchar length")
    @ScalarFunction(value="vl", deterministic=true)
    @LiteralParameters(value={"x"})
    @SqlType(value="bigint")
    public static long varcharLength(@LiteralParameter(value="x") Long param, @SqlType(value="varchar(x)") Slice slice) {
        return param;
    }

    @ScalarFunction(value="utf8", deterministic=false)
    @SqlType(value="varchar")
    public static Slice convertBinaryToVarchar(@SqlType(value="varbinary") Slice binary) {
        return binary;
    }

    public static String padRight(String s, int n) {
        return s + " ".repeat(n - s.codePointCount(0, s.length()));
    }

    @Test
    public void testChr() {
        this.assertFunction("CHR(65)", (Type)VarcharType.createVarcharType((int)1), "A");
        this.assertFunction("CHR(9731)", (Type)VarcharType.createVarcharType((int)1), "\u2603");
        this.assertFunction("CHR(131210)", (Type)VarcharType.createVarcharType((int)1), new String(Character.toChars(131210)));
        this.assertFunction("CHR(0)", (Type)VarcharType.createVarcharType((int)1), "\u0000");
        this.assertInvalidFunction("CHR(-1)", "Not a valid Unicode code point: -1");
        this.assertInvalidFunction("CHR(1234567)", "Not a valid Unicode code point: 1234567");
        this.assertInvalidFunction("CHR(8589934592)", "Not a valid Unicode code point: 8589934592");
    }

    @Test
    public void testCodepoint() {
        this.assertFunction("CODEPOINT('x')", (Type)IntegerType.INTEGER, 120);
        this.assertFunction("CODEPOINT('\u840c')", (Type)IntegerType.INTEGER, 33804);
        this.assertFunction("CODEPOINT(CHR(128077))", (Type)IntegerType.INTEGER, 128077);
        this.assertFunction("CODEPOINT(CHR(33804))", (Type)IntegerType.INTEGER, 33804);
        this.assertInvalidFunction("CODEPOINT('hello')", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("CODEPOINT('\u666e\u5217\u65af\u6258')", (ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND);
        this.assertInvalidFunction("CODEPOINT('')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testConcat() {
        this.assertInvalidFunction("CONCAT('')", "There must be two or more concatenation arguments");
        this.assertFunction("CONCAT('hello', ' world')", (Type)VarcharType.VARCHAR, "hello world");
        this.assertFunction("CONCAT('', '')", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("CONCAT('what', '')", (Type)VarcharType.VARCHAR, "what");
        this.assertFunction("CONCAT('', 'what')", (Type)VarcharType.VARCHAR, "what");
        this.assertFunction("CONCAT(CONCAT('this', ' is'), ' cool')", (Type)VarcharType.VARCHAR, "this is cool");
        this.assertFunction("CONCAT('this', CONCAT(' is', ' cool'))", (Type)VarcharType.VARCHAR, "this is cool");
        this.assertFunction("CONCAT('hello na\u00efve', ' world')", (Type)VarcharType.VARCHAR, "hello na\u00efve world");
        this.assertFunction("CONCAT('\ud801\udc2d', 'end')", (Type)VarcharType.VARCHAR, "\ud801\udc2dend");
        this.assertFunction("CONCAT('\ud801\udc2d', 'end', '\ud801\udc2d')", (Type)VarcharType.VARCHAR, "\ud801\udc2dend\ud801\udc2d");
        this.assertFunction("CONCAT(CONCAT('\u4fe1\u5ff5', ',\u7231'), ',\u5e0c\u671b')", (Type)VarcharType.VARCHAR, "\u4fe1\u5ff5,\u7231,\u5e0c\u671b");
        this.assertFunction("CONCAT(" + Joiner.on((String)", ").join(Collections.nCopies(127, "'x'")) + ")", (Type)VarcharType.VARCHAR, Joiner.on((String)"").join(Collections.nCopies(127, "x")));
        this.assertInvalidFunction("CONCAT(" + Joiner.on((String)", ").join(Collections.nCopies(128, "'x'")) + ")", (ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, "line 1:1: Too many arguments for function call concat()");
    }

    @Test
    public void testLength() {
        this.assertFunction("LENGTH('')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("LENGTH('hello')", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("LENGTH('Quadratically')", (Type)BigintType.BIGINT, 13L);
        this.assertFunction("LENGTH('hello na\u00efve world')", (Type)BigintType.BIGINT, 17L);
        this.assertFunction("LENGTH('\ud801\udc2dend')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("LENGTH('\u4fe1\u5ff5,\u7231,\u5e0c\u671b')", (Type)BigintType.BIGINT, 7L);
    }

    @Test
    public void testCharLength() {
        this.assertFunction("LENGTH(CAST('hello' AS CHAR(5)))", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("LENGTH(CAST('Quadratically' AS CHAR(13)))", (Type)BigintType.BIGINT, 13L);
        this.assertFunction("LENGTH(CAST('' AS CHAR(20)))", (Type)BigintType.BIGINT, 20L);
        this.assertFunction("LENGTH(CAST('hello' AS CHAR(20)))", (Type)BigintType.BIGINT, 20L);
        this.assertFunction("LENGTH(CAST('Quadratically' AS CHAR(20)))", (Type)BigintType.BIGINT, 20L);
        this.assertFunction("LENGTH(CAST('hello na\u00efve world' AS CHAR(17)))", (Type)BigintType.BIGINT, 17L);
        this.assertFunction("LENGTH(CAST('\ud801\udc2dend' AS CHAR(4)))", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("LENGTH(CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(7)))", (Type)BigintType.BIGINT, 7L);
        this.assertFunction("LENGTH(CAST('hello na\u00efve world' AS CHAR(20)))", (Type)BigintType.BIGINT, 20L);
        this.assertFunction("LENGTH(CAST('\ud801\udc2dend' AS CHAR(20)))", (Type)BigintType.BIGINT, 20L);
        this.assertFunction("LENGTH(CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(20)))", (Type)BigintType.BIGINT, 20L);
    }

    @Test
    public void testLevenshteinDistance() {
        this.assertFunction("LEVENSHTEIN_DISTANCE('', '')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('', 'hello')", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('hello', '')", (Type)BigintType.BIGINT, 5L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('hello', 'hello')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('hello', 'hello world')", (Type)BigintType.BIGINT, 6L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('hello world', 'hel wold')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('hello world', 'hellq wodld')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('helo word', 'hello world')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('hello word', 'dello world')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('hello na\u00efve world', 'hello naive world')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('hello na\u00efve world', 'hello na:ive world')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', '\u4fe1\u4ef0,\u7231,\u5e0c\u671b')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('\u4f11\u5ff5,\u7231,\u5e0c\u671b', '\u4fe1\u5ff5,\u7231,\u5e0c\u671b')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', '\u4fe1\u5ff5\u5e0c\u671b')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("LEVENSHTEIN_DISTANCE('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', '\u4fe1\u5ff5,love,\u5e0c\u671b')", (Type)BigintType.BIGINT, 4L);
        this.assertInvalidFunction("LEVENSHTEIN_DISTANCE('hello world', utf8(from_hex('81')))", "Invalid UTF-8 encoding in characters: \ufffd");
        this.assertInvalidFunction("LEVENSHTEIN_DISTANCE('hello wolrd', utf8(from_hex('3281')))", "Invalid UTF-8 encoding in characters: 2\ufffd");
        this.assertFunction(String.format("LEVENSHTEIN_DISTANCE('hello', '%s')", "e".repeat(100000)), (Type)BigintType.BIGINT, 99999L);
        this.assertFunction(String.format("LEVENSHTEIN_DISTANCE('%s', 'hello')", "l".repeat(100000)), (Type)BigintType.BIGINT, 99998L);
        this.assertInvalidFunction(String.format("LEVENSHTEIN_DISTANCE('%s', '%s')", "x".repeat(1001), "x".repeat(1001)), "The combined inputs for Levenshtein distance are too large");
        this.assertInvalidFunction(String.format("LEVENSHTEIN_DISTANCE('hello', '%s')", "x".repeat(500000)), "The combined inputs for Levenshtein distance are too large");
        this.assertInvalidFunction(String.format("LEVENSHTEIN_DISTANCE('%s', 'hello')", "x".repeat(500000)), "The combined inputs for Levenshtein distance are too large");
    }

    @Test
    public void testHammingDistance() {
        this.assertFunction("HAMMING_DISTANCE('', '')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("HAMMING_DISTANCE('hello', 'hello')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("HAMMING_DISTANCE('hello', 'jello')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("HAMMING_DISTANCE('like', 'hate')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("HAMMING_DISTANCE('hello', 'world')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("HAMMING_DISTANCE(NULL, NULL)", (Type)BigintType.BIGINT, null);
        this.assertFunction("HAMMING_DISTANCE('hello', NULL)", (Type)BigintType.BIGINT, null);
        this.assertFunction("HAMMING_DISTANCE(NULL, 'world')", (Type)BigintType.BIGINT, null);
        this.assertFunction("HAMMING_DISTANCE('hello na\u00efve world', 'hello naive world')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("HAMMING_DISTANCE('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', '\u4fe1\u4ef0,\u7231,\u5e0c\u671b')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("HAMMING_DISTANCE('\u4f11\u5ff5,\u7231,\u5e0c\u671b', '\u4fe1\u5ff5,\u7231,\u5e0c\u671b')", (Type)BigintType.BIGINT, 1L);
        this.assertInvalidFunction("HAMMING_DISTANCE('hello', '')", "The input strings to hamming_distance function must have the same length");
        this.assertInvalidFunction("HAMMING_DISTANCE('', 'hello')", "The input strings to hamming_distance function must have the same length");
        this.assertInvalidFunction("HAMMING_DISTANCE('hello', 'o')", "The input strings to hamming_distance function must have the same length");
        this.assertInvalidFunction("HAMMING_DISTANCE('h', 'hello')", "The input strings to hamming_distance function must have the same length");
        this.assertInvalidFunction("HAMMING_DISTANCE('hello na\u00efve world', 'hello na:ive world')", "The input strings to hamming_distance function must have the same length");
        this.assertInvalidFunction("HAMMING_DISTANCE('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', '\u4fe1\u5ff5\u5e0c\u671b')", "The input strings to hamming_distance function must have the same length");
    }

    @Test
    public void testReplace() {
        this.assertFunction("REPLACE('aaa', 'a', 'aa')", (Type)VarcharType.createVarcharType((int)11), "aaaaaa");
        this.assertFunction("REPLACE('abcdefabcdef', 'cd', 'XX')", (Type)VarcharType.createVarcharType((int)38), "abXXefabXXef");
        this.assertFunction("REPLACE('abcdefabcdef', 'cd')", (Type)VarcharType.createVarcharType((int)12), "abefabef");
        this.assertFunction("REPLACE('123123tech', '123')", (Type)VarcharType.createVarcharType((int)10), "tech");
        this.assertFunction("REPLACE('123tech123', '123')", (Type)VarcharType.createVarcharType((int)10), "tech");
        this.assertFunction("REPLACE('222tech', '2', '3')", (Type)VarcharType.createVarcharType((int)15), "333tech");
        this.assertFunction("REPLACE('0000123', '0')", (Type)VarcharType.createVarcharType((int)7), "123");
        this.assertFunction("REPLACE('0000123', '0', ' ')", (Type)VarcharType.createVarcharType((int)15), "    123");
        this.assertFunction("REPLACE('foo', '')", (Type)VarcharType.createVarcharType((int)3), "foo");
        this.assertFunction("REPLACE('foo', '', '')", (Type)VarcharType.createVarcharType((int)3), "foo");
        this.assertFunction("REPLACE('foo', 'foo', '')", (Type)VarcharType.createVarcharType((int)3), "");
        this.assertFunction("REPLACE('abc', '', 'xx')", (Type)VarcharType.createVarcharType((int)11), "xxaxxbxxcxx");
        this.assertFunction("REPLACE('', '', 'xx')", (Type)VarcharType.createVarcharType((int)2), "xx");
        this.assertFunction("REPLACE('', '')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("REPLACE('', '', '')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("REPLACE('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', ',', '\u2014')", (Type)VarcharType.createVarcharType((int)15), "\u4fe1\u5ff5\u2014\u7231\u2014\u5e0c\u671b");
        this.assertFunction("REPLACE('::\ud801\udc2d::', ':', '')", (Type)VarcharType.createVarcharType((int)5), "\ud801\udc2d");
        this.assertFunction("REPLACE('\u00d6sterreich', '\u00d6', 'Oe')", (Type)VarcharType.createVarcharType((int)32), "Oesterreich");
        this.assertFunction("CAST(REPLACE(utf8(from_hex('CE')), '', 'X') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromIso((String)"X\u00ceX"));
        this.assertFunction("CAST(REPLACE('abc' || utf8(from_hex('CE')), '', 'X') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromIso((String)"XaXbXcX\u00ceX"));
        this.assertFunction("CAST(REPLACE(utf8(from_hex('CE')) || 'xyz', '', 'X') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromIso((String)"X\u00ceXxXyXzX"));
        this.assertFunction("CAST(REPLACE('abc' || utf8(from_hex('CE')) || 'xyz', '', 'X') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromIso((String)"XaXbXcX\u00ceXxXyXzX"));
    }

    @Test
    public void testReverse() {
        this.assertFunction("REVERSE('')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("REVERSE('hello')", (Type)VarcharType.createVarcharType((int)5), "olleh");
        this.assertFunction("REVERSE('Quadratically')", (Type)VarcharType.createVarcharType((int)13), "yllacitardauQ");
        this.assertFunction("REVERSE('racecar')", (Type)VarcharType.createVarcharType((int)7), "racecar");
        this.assertFunction("REVERSE('\u4fe1\u5ff5,\u7231,\u5e0c\u671b')", (Type)VarcharType.createVarcharType((int)7), "\u671b\u5e0c,\u7231,\u5ff5\u4fe1");
        this.assertFunction("REVERSE('\u00d6sterreich')", (Type)VarcharType.createVarcharType((int)10), "hcierrets\u00d6");
        this.assertFunction("REVERSE('na\u00efve')", (Type)VarcharType.createVarcharType((int)5), "ev\u00efan");
        this.assertFunction("REVERSE('\ud801\udc2dend')", (Type)VarcharType.createVarcharType((int)4), "dne\ud801\udc2d");
        this.assertFunction("CAST(REVERSE(utf8(from_hex('CE'))) AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{206}));
        this.assertFunction("CAST(REVERSE('hello' || utf8(from_hex('CE'))) AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromIso((String)"\u00ceolleh"));
    }

    @Test
    public void testStringPosition() {
        this.testStrPosAndPosition("high", "ig", 2L);
        this.testStrPosAndPosition("high", "igx", 0L);
        this.testStrPosAndPosition("Quadratically", "a", 3L);
        this.testStrPosAndPosition("foobar", "foobar", 1L);
        this.testStrPosAndPosition("foobar", "obar", 3L);
        this.testStrPosAndPosition("zoo!", "!", 4L);
        this.testStrPosAndPosition("x", "", 1L);
        this.testStrPosAndPosition("", "", 1L);
        this.testStrPosAndPosition("\u4fe1\u5ff5,\u7231,\u5e0c\u671b", "\u7231", 4L);
        this.testStrPosAndPosition("\u4fe1\u5ff5,\u7231,\u5e0c\u671b", "\u5e0c\u671b", 6L);
        this.testStrPosAndPosition("\u4fe1\u5ff5,\u7231,\u5e0c\u671b", "nice", 0L);
        this.testStrPosAndPosition(null, "", null);
        this.testStrPosAndPosition("", null, null);
        this.testStrPosAndPosition(null, null, null);
        this.assertFunction("STARTS_WITH('foo', 'foo')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("STARTS_WITH('foo', 'bar')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("STARTS_WITH('foo', '')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("STARTS_WITH('', 'foo')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("STARTS_WITH('', '')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("STARTS_WITH('foo_bar_baz', 'foo')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("STARTS_WITH('foo_bar_baz', 'bar')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("STARTS_WITH('foo', 'foo_bar_baz')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("STARTS_WITH('\u4fe1\u5ff5 \u7231 \u5e0c\u671b', '\u4fe1\u5ff5')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("STARTS_WITH('\u4fe1\u5ff5 \u7231 \u5e0c\u671b', '\u7231')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("STRPOS(NULL, '')", (Type)BigintType.BIGINT, null);
        this.assertFunction("STRPOS('', NULL)", (Type)BigintType.BIGINT, null);
        this.assertFunction("STRPOS(NULL, NULL)", (Type)BigintType.BIGINT, null);
        this.assertInvalidFunction("STRPOS('abc/xyz/foo/bar', '/', 0)", "'instance' must be a positive or negative number.");
        this.assertInvalidFunction("STRPOS('', '', 0)", "'instance' must be a positive or negative number.");
        this.assertFunction("STRPOS('abc/xyz/foo/bar', '/')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("STRPOS('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', '\u7231')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("STRPOS('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', '\u5e0c\u671b')", (Type)BigintType.BIGINT, 6L);
        this.assertFunction("STRPOS('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', 'nice')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("STRPOS('high', 'ig')", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("STRPOS('high', 'igx')", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("STRPOS('Quadratically', 'a')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("STRPOS('foobar', 'foobar')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("STRPOS('foobar', 'obar')", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("STRPOS('zoo!', '!')", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("STRPOS('x', '')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("STRPOS('', '')", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("STRPOS('abc abc abc', 'abc', 1)", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("STRPOS('abc/xyz/foo/bar', '/', 1)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("STRPOS('abc/xyz/foo/bar', '/', 2)", (Type)BigintType.BIGINT, 8L);
        this.assertFunction("STRPOS('abc/xyz/foo/bar', '/', 3)", (Type)BigintType.BIGINT, 12L);
        this.assertFunction("STRPOS('abc/xyz/foo/bar', '/', 4)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("STRPOS('highhigh', 'ig', 1)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("STRPOS('foobarfoo', 'fb', 1)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("STRPOS('foobarfoo', 'oo', 1)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("STRPOS('abc abc abc', 'abc', -1)", (Type)BigintType.BIGINT, 9L);
        this.assertFunction("STRPOS('abc/xyz/foo/bar', '/', -1)", (Type)BigintType.BIGINT, 12L);
        this.assertFunction("STRPOS('abc/xyz/foo/bar', '/', -2)", (Type)BigintType.BIGINT, 8L);
        this.assertFunction("STRPOS('abc/xyz/foo/bar', '/', -3)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("STRPOS('abc/xyz/foo/bar', '/', -4)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("STRPOS('highhigh', 'ig', -1)", (Type)BigintType.BIGINT, 6L);
        this.assertFunction("STRPOS('highhigh', 'ig', -2)", (Type)BigintType.BIGINT, 2L);
        this.assertFunction("STRPOS('foobarfoo', 'fb', -1)", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("STRPOS('foobarfoo', 'oo', -1)", (Type)BigintType.BIGINT, 8L);
        this.assertFunction("STRPOS('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', '\u7231', -1)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("STRPOS('\u4fe1\u5ff5,\u7231,\u5e0c\u7231\u671b', '\u7231', -1)", (Type)BigintType.BIGINT, 7L);
        this.assertFunction("STRPOS('\u4fe1\u5ff5,\u7231,\u5e0c\u7231\u671b', '\u7231', -2)", (Type)BigintType.BIGINT, 4L);
        this.assertFunction("STRPOS('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', '\u5e0c\u671b', -1)", (Type)BigintType.BIGINT, 6L);
        this.assertFunction("STRPOS('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', 'nice', -1)", (Type)BigintType.BIGINT, 0L);
    }

    private void testStrPosAndPosition(String string, String substring, Long expected) {
        string = string == null ? "NULL" : "'" + (String)string + "'";
        substring = substring == null ? "NULL" : "'" + (String)substring + "'";
        this.assertFunction(String.format("STRPOS(%s, %s)", string, substring), (Type)BigintType.BIGINT, expected);
        this.assertFunction(String.format("POSITION(%s in %s)", substring, string), (Type)BigintType.BIGINT, expected);
    }

    @Test
    public void testSubstring() {
        this.assertFunction("SUBSTR('Quadratically', 5)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTR('Quadratically', 50)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR('Quadratically', -5)", (Type)VarcharType.createVarcharType((int)13), "cally");
        this.assertFunction("SUBSTR('Quadratically', -50)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR('Quadratically', 0)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR('Quadratically', 5, 6)", (Type)VarcharType.createVarcharType((int)13), "ratica");
        this.assertFunction("SUBSTR('Quadratically', 5, 10)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTR('Quadratically', 5, 50)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTR('Quadratically', 50, 10)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR('Quadratically', -5, 4)", (Type)VarcharType.createVarcharType((int)13), "call");
        this.assertFunction("SUBSTR('Quadratically', -5, 40)", (Type)VarcharType.createVarcharType((int)13), "cally");
        this.assertFunction("SUBSTR('Quadratically', -50, 4)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR('Quadratically', 0, 4)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR('Quadratically', 5, 0)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTRING('Quadratically' FROM 5)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTRING('Quadratically' FROM 50)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTRING('Quadratically' FROM -5)", (Type)VarcharType.createVarcharType((int)13), "cally");
        this.assertFunction("SUBSTRING('Quadratically' FROM -50)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTRING('Quadratically' FROM 0)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTRING('Quadratically' FROM 5 FOR 6)", (Type)VarcharType.createVarcharType((int)13), "ratica");
        this.assertFunction("SUBSTRING('Quadratically' FROM 5 FOR 50)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTRING('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' FROM 1 FOR 1)", (Type)VarcharType.createVarcharType((int)7), "\u4fe1");
        this.assertFunction("SUBSTRING('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' FROM 3 FOR 5)", (Type)VarcharType.createVarcharType((int)7), ",\u7231,\u5e0c\u671b");
        this.assertFunction("SUBSTRING('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' FROM 4)", (Type)VarcharType.createVarcharType((int)7), "\u7231,\u5e0c\u671b");
        this.assertFunction("SUBSTRING('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' FROM -2)", (Type)VarcharType.createVarcharType((int)7), "\u5e0c\u671b");
        this.assertFunction("SUBSTRING('\ud801\udc2dend' FROM 1 FOR 1)", (Type)VarcharType.createVarcharType((int)4), "\ud801\udc2d");
        this.assertFunction("SUBSTRING('\ud801\udc2dend' FROM 2 FOR 3)", (Type)VarcharType.createVarcharType((int)4), "end");
    }

    @Test
    public void testCharSubstring() {
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), 5)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), 50)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), -5)", (Type)VarcharType.createVarcharType((int)13), "cally");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), -50)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), 0)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), 5, 6)", (Type)VarcharType.createVarcharType((int)13), "ratica");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), 5, 10)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), 5, 50)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), 50, 10)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), -5, 4)", (Type)VarcharType.createVarcharType((int)13), "call");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), -5, 40)", (Type)VarcharType.createVarcharType((int)13), "cally");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), -50, 4)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), 0, 4)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR(CAST('Quadratically' AS CHAR(13)), 5, 0)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTR(CAST('abc def' AS CHAR(7)), 1, 4)", (Type)VarcharType.createVarcharType((int)7), "abc ");
        this.assertFunction("SUBSTR(CAST('keep trailing' AS CHAR(14)), 1)", (Type)VarcharType.createVarcharType((int)14), "keep trailing ");
        this.assertFunction("SUBSTR(CAST('keep trailing' AS CHAR(14)), 1, 14)", (Type)VarcharType.createVarcharType((int)14), "keep trailing ");
        this.assertFunction("SUBSTRING(CAST('Quadratically' AS CHAR(13)), 5)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTRING(CAST('Quadratically' AS CHAR(13)) FROM 5)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTRING(CAST('Quadratically' AS CHAR(13)) FROM 50)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTRING(CAST('Quadratically' AS CHAR(13)) FROM -5)", (Type)VarcharType.createVarcharType((int)13), "cally");
        this.assertFunction("SUBSTRING(CAST('Quadratically' AS CHAR(13)) FROM -50)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTRING(CAST('Quadratically' AS CHAR(13)) FROM 0)", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("SUBSTRING(CAST('Quadratically' AS CHAR(13)), 5, 6)", (Type)VarcharType.createVarcharType((int)13), "ratica");
        this.assertFunction("SUBSTRING(CAST('Quadratically' AS CHAR(13)) FROM 5 FOR 6)", (Type)VarcharType.createVarcharType((int)13), "ratica");
        this.assertFunction("SUBSTRING(CAST('Quadratically' AS CHAR(13)) FROM 5 FOR 50)", (Type)VarcharType.createVarcharType((int)13), "ratically");
        this.assertFunction("SUBSTRING(CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(7)) FROM 1 FOR 1)", (Type)VarcharType.createVarcharType((int)7), "\u4fe1");
        this.assertFunction("SUBSTRING(CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(7)) FROM 3 FOR 5)", (Type)VarcharType.createVarcharType((int)7), ",\u7231,\u5e0c\u671b");
        this.assertFunction("SUBSTRING(CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(7)) FROM 4)", (Type)VarcharType.createVarcharType((int)7), "\u7231,\u5e0c\u671b");
        this.assertFunction("SUBSTRING(CAST('\u4fe1\u5ff5,\u7231,\u5e0c\u671b' AS CHAR(7)) FROM -2)", (Type)VarcharType.createVarcharType((int)7), "\u5e0c\u671b");
        this.assertFunction("SUBSTRING(CAST('\ud801\udc2dend' AS CHAR(4)) FROM 1 FOR 1)", (Type)VarcharType.createVarcharType((int)4), "\ud801\udc2d");
        this.assertFunction("SUBSTRING(CAST('\ud801\udc2dend' AS CHAR(4)) FROM 2 FOR 3)", (Type)VarcharType.createVarcharType((int)4), "end");
        this.assertFunction("SUBSTRING(CAST('\ud801\udc2dend' AS CHAR(40)) FROM 2 FOR 3)", (Type)VarcharType.createVarcharType((int)40), "end");
    }

    @Test
    public void testSplit() {
        this.assertFunction("SPLIT('a.b.c', '.')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)5)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        this.assertFunction("SPLIT('ab', '.', 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)), ImmutableList.of((Object)"ab"));
        this.assertFunction("SPLIT('a.b', '.', 1)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"a.b"));
        this.assertFunction("SPLIT('a.b.c', '.')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)5)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        this.assertFunction("SPLIT('a..b..c', '..')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        this.assertFunction("SPLIT('a.b.c', '.', 2)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)5)), ImmutableList.of((Object)"a", (Object)"b.c"));
        this.assertFunction("SPLIT('a.b.c', '.', 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)5)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        this.assertFunction("SPLIT('a.b.c', '.', 4)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)5)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        this.assertFunction("SPLIT('a.b.c.', '.', 4)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)6)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)""));
        this.assertFunction("SPLIT('a.b.c.', '.', 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)6)), ImmutableList.of((Object)"a", (Object)"b", (Object)"c."));
        this.assertFunction("SPLIT('...', '.')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"", (Object)"", (Object)"", (Object)""));
        this.assertFunction("SPLIT('..a...a..', '.')", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)9)), ImmutableList.of((Object)"", (Object)"", (Object)"a", (Object)"", (Object)"", (Object)"a", (Object)"", (Object)""));
        this.assertFunction("SPLIT('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', ',', 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"\u4fe1\u5ff5", (Object)"\u7231", (Object)"\u5e0c\u671b"));
        this.assertFunction("SPLIT('\u8b49\u8bc1\u8a3c', '\u8bc1', 2)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), ImmutableList.of((Object)"\u8b49", (Object)"\u8a3c"));
        this.assertFunction("SPLIT('.a.b.c', '.', 4)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)6)), ImmutableList.of((Object)"", (Object)"a", (Object)"b", (Object)"c"));
        this.assertFunction("SPLIT('.a.b.c', '.', 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)6)), ImmutableList.of((Object)"", (Object)"a", (Object)"b.c"));
        this.assertFunction("SPLIT('.a.b.c', '.', 2)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)6)), ImmutableList.of((Object)"", (Object)"a.b.c"));
        this.assertFunction("SPLIT('a..b..c', '.', 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)7)), ImmutableList.of((Object)"a", (Object)"", (Object)"b..c"));
        this.assertFunction("SPLIT('a.b..', '.', 3)", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)5)), ImmutableList.of((Object)"a", (Object)"b", (Object)"."));
        this.assertInvalidFunction("SPLIT('a.b.c', '', 1)", "The delimiter may not be the empty string");
        this.assertInvalidFunction("SPLIT('a.b.c', '.', 0)", "Limit must be positive");
        this.assertInvalidFunction("SPLIT('a.b.c', '.', -1)", "Limit must be positive");
        this.assertInvalidFunction("SPLIT('a.b.c', '.', 2147483648)", "Limit is too large");
    }

    @Test
    public void testSplitToMap() {
        MapType expectedType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR);
        this.assertFunction("SPLIT_TO_MAP('', ',', '=')", (Type)expectedType, ImmutableMap.of());
        this.assertFunction("SPLIT_TO_MAP('a=123,b=.4,c=,=d', ',', '=')", (Type)expectedType, ImmutableMap.of((Object)"a", (Object)"123", (Object)"b", (Object)".4", (Object)"c", (Object)"", (Object)"", (Object)"d"));
        this.assertFunction("SPLIT_TO_MAP('=', ',', '=')", (Type)expectedType, ImmutableMap.of((Object)"", (Object)""));
        this.assertFunction("SPLIT_TO_MAP('key=>value', ',', '=>')", (Type)expectedType, ImmutableMap.of((Object)"key", (Object)"value"));
        this.assertFunction("SPLIT_TO_MAP('key => value', ',', '=>')", (Type)expectedType, ImmutableMap.of((Object)"key ", (Object)" value"));
        this.assertFunction("SPLIT_TO_MAP('\u4ea0\u4eff\u4ea1', '\u4e00', '\u4eff')", (Type)expectedType, ImmutableMap.of((Object)"\u4ea0", (Object)"\u4ea1"));
        this.assertFunction("SPLIT_TO_MAP('\u4ec0\u4eff', '\u4e00', '\u4eff')", (Type)expectedType, ImmutableMap.of((Object)"\u4ec0", (Object)""));
        this.assertFunction("SPLIT_TO_MAP('\u4eff\u4ec1', '\u4e00', '\u4eff')", (Type)expectedType, ImmutableMap.of((Object)"", (Object)"\u4ec1"));
        this.assertInvalidFunction("SPLIT_TO_MAP('', '\u4eff', '\u4eff')", "entryDelimiter and keyValueDelimiter must not be the same");
        this.assertInvalidFunction("SPLIT_TO_MAP('a=123,b=.4,c=', '=', '=')", "entryDelimiter and keyValueDelimiter must not be the same");
        this.assertInvalidFunction("SPLIT_TO_MAP('a=123,a=.4', ',', '=')", "Duplicate keys (a) are not allowed");
        this.assertInvalidFunction("SPLIT_TO_MAP('\u4ea0\u4eff\u4ea1\u4e00\u4ea0\u4eff\u4eb1', '\u4e00', '\u4eff')", "Duplicate keys (\u4ea0) are not allowed");
        this.assertInvalidFunction("SPLIT_TO_MAP('key', ',', '=')", "Key-value delimiter must appear exactly once in each entry. Bad input: 'key'");
        this.assertInvalidFunction("SPLIT_TO_MAP('key==value', ',', '=')", "Key-value delimiter must appear exactly once in each entry. Bad input: 'key==value'");
        this.assertInvalidFunction("SPLIT_TO_MAP('key=va=lue', ',', '=')", "Key-value delimiter must appear exactly once in each entry. Bad input: 'key=va=lue'");
        this.assertCachedInstanceHasBoundedRetainedSize("SPLIT_TO_MAP('a=123,b=.4,c=,=d', ',', '=')");
    }

    @Test
    public void testSplitToMultimap() {
        MapType expectedType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)VarcharType.VARCHAR));
        this.assertFunction("SPLIT_TO_MULTIMAP('', ',', '=')", (Type)expectedType, ImmutableMap.of());
        this.assertFunction("SPLIT_TO_MULTIMAP('a=123,b=.4,c=,=d', ',', '=')", (Type)expectedType, ImmutableMap.of((Object)"a", (Object)ImmutableList.of((Object)"123"), (Object)"b", (Object)ImmutableList.of((Object)".4"), (Object)"c", (Object)ImmutableList.of((Object)""), (Object)"", (Object)ImmutableList.of((Object)"d")));
        this.assertFunction("SPLIT_TO_MULTIMAP('=', ',', '=')", (Type)expectedType, ImmutableMap.of((Object)"", (Object)ImmutableList.of((Object)"")));
        this.assertFunction("SPLIT_TO_MULTIMAP('a=123,a=.4,a=5.67', ',', '=')", (Type)expectedType, ImmutableMap.of((Object)"a", (Object)ImmutableList.of((Object)"123", (Object)".4", (Object)"5.67")));
        this.assertFunction("SPLIT_TO_MULTIMAP('key=>value,key=>value', ',', '=>')", (Type)expectedType, ImmutableMap.of((Object)"key", (Object)ImmutableList.of((Object)"value", (Object)"value")));
        this.assertFunction("SPLIT_TO_MULTIMAP('key => value, key => value', ',', '=>')", (Type)expectedType, ImmutableMap.of((Object)"key ", (Object)ImmutableList.of((Object)" value"), (Object)" key ", (Object)ImmutableList.of((Object)" value")));
        this.assertFunction("SPLIT_TO_MULTIMAP('key => value, key => value', ', ', '=>')", (Type)expectedType, ImmutableMap.of((Object)"key ", (Object)ImmutableList.of((Object)" value", (Object)" value")));
        this.assertFunction("SPLIT_TO_MULTIMAP('\u4ea0\u4eff\u4ea1', '\u4e00', '\u4eff')", (Type)expectedType, ImmutableMap.of((Object)"\u4ea0", (Object)ImmutableList.of((Object)"\u4ea1")));
        this.assertFunction("SPLIT_TO_MULTIMAP('\u4ea0\u4eff\u4ea1\u4e00\u4ea0\u4eff\u4eb1', '\u4e00', '\u4eff')", (Type)expectedType, ImmutableMap.of((Object)"\u4ea0", (Object)ImmutableList.of((Object)"\u4ea1", (Object)"\u4eb1")));
        this.assertInvalidFunction("SPLIT_TO_MULTIMAP('', '\u4eff', '\u4eff')", "entryDelimiter and keyValueDelimiter must not be the same");
        this.assertInvalidFunction("SPLIT_TO_MULTIMAP('a=123,b=.4,c=', '=', '=')", "entryDelimiter and keyValueDelimiter must not be the same");
        this.assertInvalidFunction("SPLIT_TO_MULTIMAP('key', ',', '=')", "Key-value delimiter must appear exactly once in each entry. Bad input: key");
        this.assertInvalidFunction("SPLIT_TO_MULTIMAP('key==value', ',', '=')", "Key-value delimiter must appear exactly once in each entry. Bad input: key==value");
        this.assertInvalidFunction("SPLIT_TO_MULTIMAP('key=va=lue', ',', '=')", "Key-value delimiter must appear exactly once in each entry. Bad input: key=va=lue");
        this.assertCachedInstanceHasBoundedRetainedSize("SPLIT_TO_MULTIMAP('a=123,b=.4,c=,=d', ',', '=')");
    }

    @Test
    public void testSplitPart() {
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 1)", (Type)VarcharType.createVarcharType((int)15), "abc");
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 2)", (Type)VarcharType.createVarcharType((int)15), "def");
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 3)", (Type)VarcharType.createVarcharType((int)15), "ghi");
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 4)", (Type)VarcharType.createVarcharType((int)15), null);
        this.assertFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 99)", (Type)VarcharType.createVarcharType((int)15), null);
        this.assertFunction("SPLIT_PART('abc', 'abc', 1)", (Type)VarcharType.createVarcharType((int)3), "");
        this.assertFunction("SPLIT_PART('abc', 'abc', 2)", (Type)VarcharType.createVarcharType((int)3), "");
        this.assertFunction("SPLIT_PART('abc', 'abc', 3)", (Type)VarcharType.createVarcharType((int)3), null);
        this.assertFunction("SPLIT_PART('abc', '-@-', 1)", (Type)VarcharType.createVarcharType((int)3), "abc");
        this.assertFunction("SPLIT_PART('abc', '-@-', 2)", (Type)VarcharType.createVarcharType((int)3), null);
        this.assertFunction("SPLIT_PART('', 'abc', 1)", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("SPLIT_PART('', '', 1)", (Type)VarcharType.createVarcharType((int)0), null);
        this.assertFunction("SPLIT_PART('abc', '', 1)", (Type)VarcharType.createVarcharType((int)3), "a");
        this.assertFunction("SPLIT_PART('abc', '', 2)", (Type)VarcharType.createVarcharType((int)3), "b");
        this.assertFunction("SPLIT_PART('abc', '', 3)", (Type)VarcharType.createVarcharType((int)3), "c");
        this.assertFunction("SPLIT_PART('abc', '', 4)", (Type)VarcharType.createVarcharType((int)3), null);
        this.assertFunction("SPLIT_PART('abc', '', 99)", (Type)VarcharType.createVarcharType((int)3), null);
        this.assertFunction("SPLIT_PART('abc', 'abcd', 1)", (Type)VarcharType.createVarcharType((int)3), "abc");
        this.assertFunction("SPLIT_PART('abc', 'abcd', 2)", (Type)VarcharType.createVarcharType((int)3), null);
        this.assertFunction("SPLIT_PART('abc--@--def', '-@-', 1)", (Type)VarcharType.createVarcharType((int)11), "abc-");
        this.assertFunction("SPLIT_PART('abc--@--def', '-@-', 2)", (Type)VarcharType.createVarcharType((int)11), "-def");
        this.assertFunction("SPLIT_PART('abc-@-@-@-def', '-@-', 1)", (Type)VarcharType.createVarcharType((int)13), "abc");
        this.assertFunction("SPLIT_PART('abc-@-@-@-def', '-@-', 2)", (Type)VarcharType.createVarcharType((int)13), "@");
        this.assertFunction("SPLIT_PART('abc-@-@-@-def', '-@-', 3)", (Type)VarcharType.createVarcharType((int)13), "def");
        this.assertFunction("SPLIT_PART(' ', ' ', 1)", (Type)VarcharType.createVarcharType((int)1), "");
        this.assertFunction("SPLIT_PART('abcdddddef', 'dd', 1)", (Type)VarcharType.createVarcharType((int)10), "abc");
        this.assertFunction("SPLIT_PART('abcdddddef', 'dd', 2)", (Type)VarcharType.createVarcharType((int)10), "");
        this.assertFunction("SPLIT_PART('abcdddddef', 'dd', 3)", (Type)VarcharType.createVarcharType((int)10), "def");
        this.assertFunction("SPLIT_PART('a/b/c', '/', 4)", (Type)VarcharType.createVarcharType((int)5), null);
        this.assertFunction("SPLIT_PART('a/b/c/', '/', 4)", (Type)VarcharType.createVarcharType((int)6), "");
        this.assertFunction("SPLIT_PART('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', ',', 1)", (Type)VarcharType.createVarcharType((int)7), "\u4fe1\u5ff5");
        this.assertFunction("SPLIT_PART('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', ',', 2)", (Type)VarcharType.createVarcharType((int)7), "\u7231");
        this.assertFunction("SPLIT_PART('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', ',', 3)", (Type)VarcharType.createVarcharType((int)7), "\u5e0c\u671b");
        this.assertFunction("SPLIT_PART('\u4fe1\u5ff5,\u7231,\u5e0c\u671b', ',', 4)", (Type)VarcharType.createVarcharType((int)7), null);
        this.assertFunction("SPLIT_PART('\u8b49\u8bc1\u8a3c', '\u8bc1', 1)", (Type)VarcharType.createVarcharType((int)3), "\u8b49");
        this.assertFunction("SPLIT_PART('\u8b49\u8bc1\u8a3c', '\u8bc1', 2)", (Type)VarcharType.createVarcharType((int)3), "\u8a3c");
        this.assertFunction("SPLIT_PART('\u8b49\u8bc1\u8a3c', '\u8bc1', 3)", (Type)VarcharType.createVarcharType((int)3), null);
        this.assertInvalidFunction("SPLIT_PART('abc', '', 0)", "Index must be greater than zero");
        this.assertInvalidFunction("SPLIT_PART('abc', '', -1)", "Index must be greater than zero");
        this.assertInvalidFunction("SPLIT_PART(utf8(from_hex('CE')), '', 1)", "Invalid UTF-8 encoding");
    }

    @Test
    public void testSplitPartInvalid() {
        this.assertInvalidFunction("SPLIT_PART('abc-@-def-@-ghi', '-@-', 0)", "Index must be greater than zero");
    }

    @Test
    public void testLeftTrim() {
        this.assertFunction("LTRIM('')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("LTRIM('   ')", (Type)VarcharType.createVarcharType((int)3), "");
        this.assertFunction("LTRIM('  hello  ')", (Type)VarcharType.createVarcharType((int)9), "hello  ");
        this.assertFunction("LTRIM('  hello')", (Type)VarcharType.createVarcharType((int)7), "hello");
        this.assertFunction("LTRIM('hello  ')", (Type)VarcharType.createVarcharType((int)7), "hello  ");
        this.assertFunction("LTRIM(' hello world ')", (Type)VarcharType.createVarcharType((int)13), "hello world ");
        this.assertFunction("LTRIM('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ')", (Type)VarcharType.createVarcharType((int)9), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ");
        this.assertFunction("LTRIM(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ')", (Type)VarcharType.createVarcharType((int)9), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b ");
        this.assertFunction("LTRIM('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", (Type)VarcharType.createVarcharType((int)9), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        this.assertFunction("LTRIM(' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", (Type)VarcharType.createVarcharType((int)10), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
    }

    @Test
    public void testCharLeftTrim() {
        this.assertFunction("LTRIM(CAST('' AS CHAR(20)))", (Type)CharType.createCharType((long)20L), TestStringFunctions.padRight("", 20));
        this.assertFunction("LTRIM(CAST('  hello  ' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("hello", 9));
        this.assertFunction("LTRIM(CAST('  hello' AS CHAR(7)))", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("hello", 7));
        this.assertFunction("LTRIM(CAST('hello  ' AS CHAR(7)))", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("hello", 7));
        this.assertFunction("LTRIM(CAST(' hello world ' AS CHAR(13)))", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("hello world", 13));
        this.assertFunction("LTRIM(CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 9));
        this.assertFunction("LTRIM(CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 9));
        this.assertFunction("LTRIM(CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 9));
        this.assertFunction("LTRIM(CAST(' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(10)))", (Type)CharType.createCharType((long)10L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 10));
    }

    @Test
    public void testRightTrim() {
        this.assertFunction("RTRIM('')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("RTRIM('   ')", (Type)VarcharType.createVarcharType((int)3), "");
        this.assertFunction("RTRIM('  hello  ')", (Type)VarcharType.createVarcharType((int)9), "  hello");
        this.assertFunction("RTRIM('  hello')", (Type)VarcharType.createVarcharType((int)7), "  hello");
        this.assertFunction("RTRIM('hello  ')", (Type)VarcharType.createVarcharType((int)7), "hello");
        this.assertFunction("RTRIM(' hello world ')", (Type)VarcharType.createVarcharType((int)13), " hello world");
        this.assertFunction("RTRIM('\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ')", (Type)VarcharType.createVarcharType((int)10), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        this.assertFunction("RTRIM('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ')", (Type)VarcharType.createVarcharType((int)9), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        this.assertFunction("RTRIM(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ')", (Type)VarcharType.createVarcharType((int)9), " \u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        this.assertFunction("RTRIM('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", (Type)VarcharType.createVarcharType((int)9), "  \u4fe1\u5ff5 \u7231 \u5e0c\u671b");
    }

    @Test
    public void testCharRightTrim() {
        this.assertFunction("RTRIM(CAST('' AS CHAR(20)))", (Type)CharType.createCharType((long)20L), TestStringFunctions.padRight("", 20));
        this.assertFunction("RTRIM(CAST('  hello  ' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("  hello", 9));
        this.assertFunction("RTRIM(CAST('  hello' AS CHAR(7)))", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("  hello", 7));
        this.assertFunction("RTRIM(CAST('hello  ' AS CHAR(7)))", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("hello", 7));
        this.assertFunction("RTRIM(CAST(' hello world ' AS CHAR(13)))", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight(" hello world", 13));
        this.assertFunction("RTRIM(CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ' AS CHAR(10)))", (Type)CharType.createCharType((long)10L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 10));
        this.assertFunction("RTRIM(CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 9));
        this.assertFunction("RTRIM(CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight(" \u4fe1\u5ff5 \u7231 \u5e0c\u671b", 9));
        this.assertFunction("RTRIM(CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("  \u4fe1\u5ff5 \u7231 \u5e0c\u671b", 9));
    }

    @Test
    public void testTrim() {
        this.assertFunction("TRIM('')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("TRIM('   ')", (Type)VarcharType.createVarcharType((int)3), "");
        this.assertFunction("TRIM('  hello  ')", (Type)VarcharType.createVarcharType((int)9), "hello");
        this.assertFunction("TRIM('  hello')", (Type)VarcharType.createVarcharType((int)7), "hello");
        this.assertFunction("TRIM('hello  ')", (Type)VarcharType.createVarcharType((int)7), "hello");
        this.assertFunction("TRIM(' hello world ')", (Type)VarcharType.createVarcharType((int)13), "hello world");
        this.assertFunction("TRIM('\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ')", (Type)VarcharType.createVarcharType((int)10), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        this.assertFunction("TRIM('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ')", (Type)VarcharType.createVarcharType((int)9), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        this.assertFunction("TRIM(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ')", (Type)VarcharType.createVarcharType((int)9), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        this.assertFunction("TRIM('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", (Type)VarcharType.createVarcharType((int)9), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
        this.assertFunction("TRIM(' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b')", (Type)VarcharType.createVarcharType((int)10), "\u4fe1\u5ff5 \u7231 \u5e0c\u671b");
    }

    @Test
    public void testCharTrim() {
        this.assertFunction("TRIM(CAST('' AS CHAR(20)))", (Type)CharType.createCharType((long)20L), TestStringFunctions.padRight("", 20));
        this.assertFunction("TRIM(CAST('  hello  ' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("hello", 9));
        this.assertFunction("TRIM(CAST('  hello' AS CHAR(7)))", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("hello", 7));
        this.assertFunction("TRIM(CAST('hello  ' AS CHAR(7)))", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("hello", 7));
        this.assertFunction("TRIM(CAST(' hello world ' AS CHAR(13)))", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("hello world", 13));
        this.assertFunction("TRIM(CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b \u2028 ' AS CHAR(10)))", (Type)CharType.createCharType((long)10L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 10));
        this.assertFunction("TRIM(CAST('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 9));
        this.assertFunction("TRIM(CAST(' \u4fe1\u5ff5 \u7231 \u5e0c\u671b ' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 9));
        this.assertFunction("TRIM(CAST('  \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(9)))", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 9));
        this.assertFunction("TRIM(CAST(' \u2028 \u4fe1\u5ff5 \u7231 \u5e0c\u671b' AS CHAR(10)))", (Type)CharType.createCharType((long)10L), TestStringFunctions.padRight("\u4fe1\u5ff5 \u7231 \u5e0c\u671b", 10));
    }

    @Test
    public void testLeftTrimParametrized() {
        this.assertFunction("LTRIM('', '')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("LTRIM('   ', '')", (Type)VarcharType.createVarcharType((int)3), "   ");
        this.assertFunction("LTRIM('  hello  ', '')", (Type)VarcharType.createVarcharType((int)9), "  hello  ");
        this.assertFunction("LTRIM('  hello  ', ' ')", (Type)VarcharType.createVarcharType((int)9), "hello  ");
        this.assertFunction("LTRIM('  hello  ', CHAR ' ')", (Type)VarcharType.createVarcharType((int)9), "hello  ");
        this.assertFunction("LTRIM('  hello  ', 'he ')", (Type)VarcharType.createVarcharType((int)9), "llo  ");
        this.assertFunction("LTRIM('  hello', ' ')", (Type)VarcharType.createVarcharType((int)7), "hello");
        this.assertFunction("LTRIM('  hello', 'e h')", (Type)VarcharType.createVarcharType((int)7), "llo");
        this.assertFunction("LTRIM('hello  ', 'l')", (Type)VarcharType.createVarcharType((int)7), "hello  ");
        this.assertFunction("LTRIM(' hello world ', ' ')", (Type)VarcharType.createVarcharType((int)13), "hello world ");
        this.assertFunction("LTRIM(' hello world ', ' eh')", (Type)VarcharType.createVarcharType((int)13), "llo world ");
        this.assertFunction("LTRIM(' hello world ', ' ehlowrd')", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("LTRIM(' hello world ', ' x')", (Type)VarcharType.createVarcharType((int)13), "hello world ");
        this.assertFunction("LTRIM('\u017a\u00f3\u0142\u0107', '\u00f3\u017a')", (Type)VarcharType.createVarcharType((int)4), "\u0142\u0107");
        this.assertFunction("CAST(LTRIM(utf8(from_hex('81')), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(129));
        this.assertFunction("CAST(LTRIM(CONCAT(utf8(from_hex('81')), ' '), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(129, 32));
        this.assertFunction("CAST(LTRIM(CONCAT(' ', utf8(from_hex('81'))), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(129));
        this.assertFunction("CAST(LTRIM(CONCAT(' ', utf8(from_hex('81')), ' '), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(129, 32));
        this.assertInvalidFunction("LTRIM('hello world', utf8(from_hex('81')))", "Invalid UTF-8 encoding in characters: \ufffd");
        this.assertInvalidFunction("LTRIM('hello wolrd', utf8(from_hex('3281')))", "Invalid UTF-8 encoding in characters: 2\ufffd");
    }

    @Test
    public void testCharLeftTrimParametrized() {
        this.assertFunction("LTRIM(CAST('' AS CHAR(1)), '')", (Type)CharType.createCharType((long)1L), TestStringFunctions.padRight("", 1));
        this.assertFunction("LTRIM(CAST('   ' AS CHAR(3)), '')", (Type)CharType.createCharType((long)3L), TestStringFunctions.padRight("", 3));
        this.assertFunction("LTRIM(CAST('  hello  ' AS CHAR(9)), '')", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("  hello", 9));
        this.assertFunction("LTRIM(CAST('  hello  ' AS CHAR(9)), ' ')", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("hello", 9));
        this.assertFunction("LTRIM(CAST('  hello  ' AS CHAR(9)), 'he ')", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("llo", 9));
        this.assertFunction("LTRIM(CAST('  hello' AS CHAR(7)), ' ')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("hello", 7));
        this.assertFunction("LTRIM(CAST('  hello' AS CHAR(7)), 'e h')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("llo", 7));
        this.assertFunction("LTRIM(CAST('hello  ' AS CHAR(7)), 'l')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("hello", 7));
        this.assertFunction("LTRIM(CAST(' hello world ' AS CHAR(13)), ' ')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("hello world", 13));
        this.assertFunction("LTRIM(CAST(' hello world ' AS CHAR(13)), ' eh')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("llo world", 13));
        this.assertFunction("LTRIM(CAST(' hello world ' AS CHAR(13)), ' ehlowrd')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("", 13));
        this.assertFunction("LTRIM(CAST(' hello world ' AS CHAR(13)), ' x')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("hello world", 13));
        this.assertFunction("LTRIM(CAST('\u017a\u00f3\u0142\u0107' AS CHAR(4)), '\u00f3\u017a')", (Type)CharType.createCharType((long)4L), TestStringFunctions.padRight("\u0142\u0107", 4));
    }

    private static SqlVarbinary varbinary(int ... bytesAsInts) {
        byte[] bytes = new byte[bytesAsInts.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)bytesAsInts[i];
        }
        return new SqlVarbinary(bytes);
    }

    @Test
    public void testRightTrimParametrized() {
        this.assertFunction("RTRIM('', '')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("RTRIM('   ', '')", (Type)VarcharType.createVarcharType((int)3), "   ");
        this.assertFunction("RTRIM('  hello  ', '')", (Type)VarcharType.createVarcharType((int)9), "  hello  ");
        this.assertFunction("RTRIM('  hello  ', ' ')", (Type)VarcharType.createVarcharType((int)9), "  hello");
        this.assertFunction("RTRIM('  hello  ', 'lo ')", (Type)VarcharType.createVarcharType((int)9), "  he");
        this.assertFunction("RTRIM('hello  ', ' ')", (Type)VarcharType.createVarcharType((int)7), "hello");
        this.assertFunction("RTRIM('hello  ', 'l o')", (Type)VarcharType.createVarcharType((int)7), "he");
        this.assertFunction("RTRIM('hello  ', 'l')", (Type)VarcharType.createVarcharType((int)7), "hello  ");
        this.assertFunction("RTRIM(' hello world ', ' ')", (Type)VarcharType.createVarcharType((int)13), " hello world");
        this.assertFunction("RTRIM(' hello world ', ' ld')", (Type)VarcharType.createVarcharType((int)13), " hello wor");
        this.assertFunction("RTRIM(' hello world ', ' ehlowrd')", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("RTRIM(' hello world ', ' x')", (Type)VarcharType.createVarcharType((int)13), " hello world");
        this.assertFunction("RTRIM(CAST('abc def' AS CHAR(7)), 'def')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("abc", 7));
        this.assertFunction("RTRIM('\u017a\u00f3\u0142\u0107', '\u0107\u0142')", (Type)VarcharType.createVarcharType((int)4), "\u017a\u00f3");
        this.assertFunction("CAST(RTRIM(utf8(from_hex('81')), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(129));
        this.assertFunction("CAST(RTRIM(CONCAT(utf8(from_hex('81')), ' '), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(129));
        this.assertFunction("CAST(RTRIM(CONCAT(' ', utf8(from_hex('81'))), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(32, 129));
        this.assertFunction("CAST(RTRIM(CONCAT(' ', utf8(from_hex('81')), ' '), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(32, 129));
        this.assertInvalidFunction("RTRIM('hello world', utf8(from_hex('81')))", "Invalid UTF-8 encoding in characters: \ufffd");
        this.assertInvalidFunction("RTRIM('hello world', utf8(from_hex('3281')))", "Invalid UTF-8 encoding in characters: 2\ufffd");
    }

    @Test
    public void testCharRightTrimParametrized() {
        this.assertFunction("RTRIM(CAST('' AS CHAR(1)), '')", (Type)CharType.createCharType((long)1L), TestStringFunctions.padRight("", 1));
        this.assertFunction("RTRIM(CAST('   ' AS CHAR(3)), '')", (Type)CharType.createCharType((long)3L), TestStringFunctions.padRight("", 3));
        this.assertFunction("RTRIM(CAST('  hello  ' AS CHAR(9)), '')", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("  hello", 9));
        this.assertFunction("RTRIM(CAST('  hello  ' AS CHAR(9)), ' ')", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("  hello", 9));
        this.assertFunction("RTRIM(CAST('  hello  ' AS CHAR(9)), 'he ')", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("  hello", 9));
        this.assertFunction("RTRIM(CAST('  hello' AS CHAR(7)), ' ')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("  hello", 7));
        this.assertFunction("RTRIM(CAST('  hello' AS CHAR(7)), 'e h')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("  hello", 7));
        this.assertFunction("RTRIM(CAST('hello  ' AS CHAR(7)), 'l')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("hello", 7));
        this.assertFunction("RTRIM(CAST(' hello world ' AS CHAR(13)), ' ')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight(" hello world", 13));
        this.assertFunction("RTRIM(CAST(' hello world ' AS CHAR(13)), ' eh')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight(" hello world", 13));
        this.assertFunction("RTRIM(CAST(' hello world ' AS CHAR(13)), ' ehlowrd')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("", 13));
        this.assertFunction("RTRIM(CAST(' hello world ' AS CHAR(13)), ' x')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight(" hello world", 13));
        this.assertFunction("RTRIM(CAST('\u017a\u00f3\u0142\u0107' AS CHAR(4)), '\u0107\u0142')", (Type)CharType.createCharType((long)4L), TestStringFunctions.padRight("\u017a\u00f3", 4));
    }

    @Test
    public void testTrimParametrized() {
        this.assertFunction("TRIM('', '')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("TRIM('   ', '')", (Type)VarcharType.createVarcharType((int)3), "   ");
        this.assertFunction("TRIM('  hello  ', '')", (Type)VarcharType.createVarcharType((int)9), "  hello  ");
        this.assertFunction("TRIM('  hello  ', ' ')", (Type)VarcharType.createVarcharType((int)9), "hello");
        this.assertFunction("TRIM('  hello  ', 'he ')", (Type)VarcharType.createVarcharType((int)9), "llo");
        this.assertFunction("TRIM('  hello  ', 'lo ')", (Type)VarcharType.createVarcharType((int)9), "he");
        this.assertFunction("TRIM('  hello', ' ')", (Type)VarcharType.createVarcharType((int)7), "hello");
        this.assertFunction("TRIM('hello  ', ' ')", (Type)VarcharType.createVarcharType((int)7), "hello");
        this.assertFunction("TRIM('hello  ', 'l o')", (Type)VarcharType.createVarcharType((int)7), "he");
        this.assertFunction("TRIM('hello  ', 'l')", (Type)VarcharType.createVarcharType((int)7), "hello  ");
        this.assertFunction("TRIM(' hello world ', ' ')", (Type)VarcharType.createVarcharType((int)13), "hello world");
        this.assertFunction("TRIM(' hello world ', ' ld')", (Type)VarcharType.createVarcharType((int)13), "hello wor");
        this.assertFunction("TRIM(' hello world ', ' eh')", (Type)VarcharType.createVarcharType((int)13), "llo world");
        this.assertFunction("TRIM(' hello world ', ' ehlowrd')", (Type)VarcharType.createVarcharType((int)13), "");
        this.assertFunction("TRIM(' hello world ', ' x')", (Type)VarcharType.createVarcharType((int)13), "hello world");
        this.assertFunction("TRIM('\u017a\u00f3\u0142\u0107', '\u0107\u017a')", (Type)VarcharType.createVarcharType((int)4), "\u00f3\u0142");
        this.assertFunction("CAST(TRIM(utf8(from_hex('81')), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(129));
        this.assertFunction("CAST(TRIM(CONCAT(utf8(from_hex('81')), ' '), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(129));
        this.assertFunction("CAST(TRIM(CONCAT(' ', utf8(from_hex('81'))), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(129));
        this.assertFunction("CAST(TRIM(CONCAT(' ', utf8(from_hex('81')), ' '), ' ') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, TestStringFunctions.varbinary(129));
        this.assertInvalidFunction("TRIM('hello world', utf8(from_hex('81')))", "Invalid UTF-8 encoding in characters: \ufffd");
        this.assertInvalidFunction("TRIM('hello world', utf8(from_hex('3281')))", "Invalid UTF-8 encoding in characters: 2\ufffd");
    }

    @Test
    public void testCharTrimParametrized() {
        this.assertFunction("TRIM(CAST('' AS CHAR(1)), '')", (Type)CharType.createCharType((long)1L), TestStringFunctions.padRight("", 1));
        this.assertFunction("TRIM(CAST('   ' AS CHAR(3)), '')", (Type)CharType.createCharType((long)3L), TestStringFunctions.padRight("", 3));
        this.assertFunction("TRIM(CAST('  hello  ' AS CHAR(9)), '')", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("  hello", 9));
        this.assertFunction("TRIM(CAST('  hello  ' AS CHAR(9)), ' ')", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("hello", 9));
        this.assertFunction("TRIM(CAST('  hello  ' AS CHAR(9)), 'he ')", (Type)CharType.createCharType((long)9L), TestStringFunctions.padRight("llo", 9));
        this.assertFunction("TRIM(CAST('  hello' AS CHAR(7)), ' ')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("hello", 7));
        this.assertFunction("TRIM(CAST('  hello' AS CHAR(7)), 'e h')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("llo", 7));
        this.assertFunction("TRIM(CAST('hello  ' AS CHAR(7)), 'l')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("hello", 7));
        this.assertFunction("TRIM(CAST(' hello world ' AS CHAR(13)), ' ')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("hello world", 13));
        this.assertFunction("TRIM(CAST(' hello world ' AS CHAR(13)), ' eh')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("llo world", 13));
        this.assertFunction("TRIM(CAST(' hello world ' AS CHAR(13)), ' ehlowrd')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("", 13));
        this.assertFunction("TRIM(CAST(' hello world ' AS CHAR(13)), ' x')", (Type)CharType.createCharType((long)13L), TestStringFunctions.padRight("hello world", 13));
        this.assertFunction("TRIM(CAST('abc def' AS CHAR(7)), 'def')", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("abc", 7));
        this.assertFunction("TRIM(CAST('\u017a\u00f3\u0142\u0107' AS CHAR(4)), '\u017a\u0107\u0142')", (Type)CharType.createCharType((long)4L), TestStringFunctions.padRight("\u00f3", 4));
    }

    @Test
    public void testVarcharToVarcharX() {
        this.assertFunction("LOWER(VARCHAR 'HELLO')", (Type)VarcharType.createUnboundedVarcharType(), "hello");
    }

    @Test
    public void testLower() {
        this.assertFunction("LOWER('')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("LOWER('Hello World')", (Type)VarcharType.createVarcharType((int)11), "hello world");
        this.assertFunction("LOWER('WHAT!!')", (Type)VarcharType.createVarcharType((int)6), "what!!");
        this.assertFunction("LOWER('\u00d6STERREICH')", (Type)VarcharType.createVarcharType((int)10), TestStringFunctions.lowerByCodePoint("\u00d6sterreich"));
        this.assertFunction("LOWER('From\ud801\udc2dTo')", (Type)VarcharType.createVarcharType((int)7), TestStringFunctions.lowerByCodePoint("from\ud801\udc2dto"));
        this.assertFunction("CAST(LOWER(utf8(from_hex('CE'))) AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{206}));
        this.assertFunction("CAST(LOWER('HELLO' || utf8(from_hex('CE'))) AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromIso((String)"hello\u00ce"));
        this.assertFunction("CAST(LOWER(utf8(from_hex('CE')) || 'HELLO') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromIso((String)"\u00cehello"));
        this.assertFunction("CAST(LOWER(utf8(from_hex('C8BAFF'))) AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{226, 177, 165, 255}));
    }

    @Test
    public void testCharLower() {
        this.assertFunction("LOWER(CAST('' AS CHAR(10)))", (Type)CharType.createCharType((long)10L), TestStringFunctions.padRight("", 10));
        this.assertFunction("LOWER(CAST('Hello World' AS CHAR(11)))", (Type)CharType.createCharType((long)11L), TestStringFunctions.padRight("hello world", 11));
        this.assertFunction("LOWER(CAST('WHAT!!' AS CHAR(6)))", (Type)CharType.createCharType((long)6L), TestStringFunctions.padRight("what!!", 6));
        this.assertFunction("LOWER(CAST('\u00d6STERREICH' AS CHAR(10)))", (Type)CharType.createCharType((long)10L), TestStringFunctions.padRight(TestStringFunctions.lowerByCodePoint("\u00d6sterreich"), 10));
        this.assertFunction("LOWER(CAST('From\ud801\udc2dTo' AS CHAR(7)))", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight(TestStringFunctions.lowerByCodePoint("from\ud801\udc2dto"), 7));
    }

    @Test
    public void testUpper() {
        this.assertFunction("UPPER('')", (Type)VarcharType.createVarcharType((int)0), "");
        this.assertFunction("UPPER('Hello World')", (Type)VarcharType.createVarcharType((int)11), "HELLO WORLD");
        this.assertFunction("UPPER('what!!')", (Type)VarcharType.createVarcharType((int)6), "WHAT!!");
        this.assertFunction("UPPER('\u00d6sterreich')", (Type)VarcharType.createVarcharType((int)10), TestStringFunctions.upperByCodePoint("\u00d6") + "STERREICH");
        this.assertFunction("UPPER('From\ud801\udc2dTo')", (Type)VarcharType.createVarcharType((int)7), "FROM" + TestStringFunctions.upperByCodePoint("\ud801\udc2d") + "TO");
        this.assertFunction("CAST(UPPER(utf8(from_hex('CE'))) AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{206}));
        this.assertFunction("CAST(UPPER('hello' || utf8(from_hex('CE'))) AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromIso((String)"HELLO\u00ce"));
        this.assertFunction("CAST(UPPER(utf8(from_hex('CE')) || 'hello') AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromIso((String)"\u00ceHELLO"));
    }

    @Test
    public void testCharUpper() {
        this.assertFunction("UPPER(CAST('' AS CHAR(10)))", (Type)CharType.createCharType((long)10L), TestStringFunctions.padRight("", 10));
        this.assertFunction("UPPER(CAST('Hello World' AS CHAR(11)))", (Type)CharType.createCharType((long)11L), TestStringFunctions.padRight("HELLO WORLD", 11));
        this.assertFunction("UPPER(CAST('what!!' AS CHAR(6)))", (Type)CharType.createCharType((long)6L), TestStringFunctions.padRight("WHAT!!", 6));
        this.assertFunction("UPPER(CAST('\u00d6sterreich' AS CHAR(10)))", (Type)CharType.createCharType((long)10L), TestStringFunctions.padRight(TestStringFunctions.upperByCodePoint("\u00d6") + "STERREICH", 10));
        this.assertFunction("UPPER(CAST('From\ud801\udc2dTo' AS CHAR(7)))", (Type)CharType.createCharType((long)7L), TestStringFunctions.padRight("FROM" + TestStringFunctions.upperByCodePoint("\ud801\udc2d") + "TO", 7));
    }

    @Test
    public void testLeftPad() {
        this.assertFunction("LPAD('text', 5, 'x')", (Type)VarcharType.VARCHAR, "xtext");
        this.assertFunction("LPAD('text', 4, 'x')", (Type)VarcharType.VARCHAR, "text");
        this.assertFunction("LPAD('text', 6, 'xy')", (Type)VarcharType.VARCHAR, "xytext");
        this.assertFunction("LPAD('text', 7, 'xy')", (Type)VarcharType.VARCHAR, "xyxtext");
        this.assertFunction("LPAD('text', 9, 'xyz')", (Type)VarcharType.VARCHAR, "xyzxytext");
        this.assertFunction("LPAD('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ', 10, '\u671b')", (Type)VarcharType.VARCHAR, "\u671b\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ");
        this.assertFunction("LPAD('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ', 11, '\u671b')", (Type)VarcharType.VARCHAR, "\u671b\u671b\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ");
        this.assertFunction("LPAD('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ', 12, '\u5e0c\u671b')", (Type)VarcharType.VARCHAR, "\u5e0c\u671b\u5e0c\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ");
        this.assertFunction("LPAD('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ', 13, '\u5e0c\u671b')", (Type)VarcharType.VARCHAR, "\u5e0c\u671b\u5e0c\u671b\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ");
        this.assertFunction("LPAD('', 3, 'a')", (Type)VarcharType.VARCHAR, "aaa");
        this.assertFunction("LPAD('abc', 0, 'e')", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("LPAD('text', 3, 'xy')", (Type)VarcharType.VARCHAR, "tex");
        this.assertFunction("LPAD('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ', 5, '\u671b')", (Type)VarcharType.VARCHAR, "\u4fe1\u5ff5 \u7231 ");
        this.assertInvalidFunction("LPAD('abc', 3, '')", "Padding string must not be empty");
        long maxSize = Integer.MAX_VALUE;
        this.assertInvalidFunction("LPAD('abc', -1, 'foo')", "Target length must be in the range [0.." + maxSize + "]");
        this.assertInvalidFunction("LPAD('abc', " + (maxSize + 1L) + ", '')", "Target length must be in the range [0.." + maxSize + "]");
    }

    @Test
    public void testRightPad() {
        this.assertFunction("RPAD('text', 5, 'x')", (Type)VarcharType.VARCHAR, "textx");
        this.assertFunction("RPAD('text', 4, 'x')", (Type)VarcharType.VARCHAR, "text");
        this.assertFunction("RPAD('text', 6, 'xy')", (Type)VarcharType.VARCHAR, "textxy");
        this.assertFunction("RPAD('text', 7, 'xy')", (Type)VarcharType.VARCHAR, "textxyx");
        this.assertFunction("RPAD('text', 9, 'xyz')", (Type)VarcharType.VARCHAR, "textxyzxy");
        this.assertFunction("RPAD('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ', 10, '\u671b')", (Type)VarcharType.VARCHAR, "\u4fe1\u5ff5 \u7231 \u5e0c\u671b  \u671b");
        this.assertFunction("RPAD('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ', 11, '\u671b')", (Type)VarcharType.VARCHAR, "\u4fe1\u5ff5 \u7231 \u5e0c\u671b  \u671b\u671b");
        this.assertFunction("RPAD('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ', 12, '\u5e0c\u671b')", (Type)VarcharType.VARCHAR, "\u4fe1\u5ff5 \u7231 \u5e0c\u671b  \u5e0c\u671b\u5e0c");
        this.assertFunction("RPAD('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ', 13, '\u5e0c\u671b')", (Type)VarcharType.VARCHAR, "\u4fe1\u5ff5 \u7231 \u5e0c\u671b  \u5e0c\u671b\u5e0c\u671b");
        this.assertFunction("RPAD('', 3, 'a')", (Type)VarcharType.VARCHAR, "aaa");
        this.assertFunction("RPAD('abc', 0, 'e')", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("RPAD('text', 3, 'xy')", (Type)VarcharType.VARCHAR, "tex");
        this.assertFunction("RPAD('\u4fe1\u5ff5 \u7231 \u5e0c\u671b  ', 5, '\u671b')", (Type)VarcharType.VARCHAR, "\u4fe1\u5ff5 \u7231 ");
        this.assertInvalidFunction("RPAD('abc', 3, '')", "Padding string must not be empty");
        long maxSize = Integer.MAX_VALUE;
        this.assertInvalidFunction("RPAD('abc', -1, 'foo')", "Target length must be in the range [0.." + maxSize + "]");
        this.assertInvalidFunction("RPAD('abc', " + (maxSize + 1L) + ", '')", "Target length must be in the range [0.." + maxSize + "]");
    }

    @Test
    public void testNormalize() {
        this.assertFunction("normalize('sch\u00f6n', NFD)", (Type)VarcharType.VARCHAR, "scho\u0308n");
        this.assertFunction("normalize('sch\u00f6n')", (Type)VarcharType.VARCHAR, "sch\u00f6n");
        this.assertFunction("normalize('sch\u00f6n', NFC)", (Type)VarcharType.VARCHAR, "sch\u00f6n");
        this.assertFunction("normalize('sch\u00f6n', NFKD)", (Type)VarcharType.VARCHAR, "scho\u0308n");
        this.assertFunction("normalize('sch\u00f6n', NFKC)", (Type)VarcharType.VARCHAR, "sch\u00f6n");
        this.assertFunction("normalize('\u3231\u3327\u3326\u2162', NFKC)", (Type)VarcharType.VARCHAR, "(\u682a)\u30c8\u30f3\u30c9\u30ebIII");
        this.assertFunction("normalize('\uff8a\uff9d\uff76\uff78\uff76\uff85', NFKC)", (Type)VarcharType.VARCHAR, "\u30cf\u30f3\u30ab\u30af\u30ab\u30ca");
    }

    @Test
    public void testFromLiteralParameter() {
        this.assertFunction("vl(cast('aaa' as varchar(3)))", (Type)BigintType.BIGINT, 3L);
        this.assertFunction("vl(cast('aaa' as varchar(7)))", (Type)BigintType.BIGINT, 7L);
        this.assertFunction("vl('aaaa')", (Type)BigintType.BIGINT, 4L);
    }

    private static String lowerByCodePoint(String string) {
        int[] upperCodePoints = string.codePoints().map(Character::toLowerCase).toArray();
        return new String(upperCodePoints, 0, upperCodePoints.length);
    }

    private static String upperByCodePoint(String string) {
        int[] upperCodePoints = string.codePoints().map(Character::toUpperCase).toArray();
        return new String(upperCodePoints, 0, upperCodePoints.length);
    }

    @Test
    public void testFromUtf8() {
        this.assertFunction("from_utf8(to_utf8('hello'))", (Type)VarcharType.VARCHAR, "hello");
        this.assertFunction("from_utf8(from_hex('58BF'))", (Type)VarcharType.VARCHAR, "X\ufffd");
        this.assertFunction("from_utf8(from_hex('58DF'))", (Type)VarcharType.VARCHAR, "X\ufffd");
        this.assertFunction("from_utf8(from_hex('58F7'))", (Type)VarcharType.VARCHAR, "X\ufffd");
        this.assertFunction("from_utf8(from_hex('58BF'), '#')", (Type)VarcharType.VARCHAR, "X#");
        this.assertFunction("from_utf8(from_hex('58DF'), 35)", (Type)VarcharType.VARCHAR, "X#");
        this.assertFunction("from_utf8(from_hex('58BF'), '')", (Type)VarcharType.VARCHAR, "X");
        this.assertInvalidFunction("from_utf8(to_utf8('hello'), 'foo')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_utf8(to_utf8('hello'), 1114112)", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testCharConcat() {
        this.assertFunction("concat('ab ', cast(' ' as char(1)))", (Type)CharType.createCharType((long)4L), "ab  ");
        this.assertFunction("concat('ab ', cast(' ' as char(1))) = 'ab'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("concat('ab ', cast('a' as char(2)))", (Type)CharType.createCharType((long)5L), "ab a ");
        this.assertFunction("concat('ab ', cast('a' as char(2))) = 'ab a'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("concat('ab ', cast('' as char(0)))", (Type)CharType.createCharType((long)3L), "ab ");
        this.assertFunction("concat('ab ', cast('' as char(0))) = 'ab'", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("concat('hello na\u00efve', cast(' world' as char(6)))", (Type)CharType.createCharType((long)17L), "hello na\u00efve world");
        this.assertInvalidFunction("concat(cast('ab ' as char(40000)), cast('' as char(40000)))", "line 1:1: CHAR length must be in range [0, 65536], got 80000");
        this.assertFunction("concat(cast(null as char(1)), cast(' ' as char(1)))", (Type)CharType.createCharType((long)2L), null);
    }

    @Test
    public void testTranslate() {
        this.assertFunction("translate('abcd', '', '')", (Type)VarcharType.VARCHAR, "abcd");
        this.assertFunction("translate('abcd', 'a', 'z')", (Type)VarcharType.VARCHAR, "zbcd");
        this.assertFunction("translate('abcda', 'a', 'z')", (Type)VarcharType.VARCHAR, "zbcdz");
        this.assertFunction("translate('\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00f6\u00fc\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e3\u1ebd\u0129\u00f5\u0169\u00c3\u1ebc\u0128\u00d5\u0168', '\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00f6\u00fc\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e3\u1ebd\u0129\u00f5\u0169\u00c3\u1ebc\u0128\u00d5\u0168','aeiouAEIOUaeiouAEIOUaeiouAEIOUaeiouAEIOU')", (Type)VarcharType.VARCHAR, "aeiouAEIOUaeiouAEIOUaeiouAEIOUaeiouAEIOU");
        this.assertFunction("translate('Goi\u00e2nia', '\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00f6\u00fc\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e3\u1ebd\u0129\u00f5\u0169\u00c3\u1ebc\u0128\u00d5\u0168','aeiouAEIOUaeiouAEIOUaeiouAEIOUaeiouAEIOU')", (Type)VarcharType.VARCHAR, "Goiania");
        this.assertFunction("translate('S\u00e3o Paulo', '\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00f6\u00fc\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e3\u1ebd\u0129\u00f5\u0169\u00c3\u1ebc\u0128\u00d5\u0168','aeiouAEIOUaeiouAEIOUaeiouAEIOUaeiouAEIOU')", (Type)VarcharType.VARCHAR, "Sao Paulo");
        this.assertFunction("translate('Palho\u00e7a', '\u00e7','c')", (Type)VarcharType.VARCHAR, "Palhoca");
        this.assertFunction("translate('V\u00e1rzea Paulista', '\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e4\u00eb\u00ef\u00f6\u00fc\u00c4\u00cb\u00cf\u00d6\u00dc\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e3\u1ebd\u0129\u00f5\u0169\u00c3\u1ebc\u0128\u00d5\u0168','aeiouAEIOUaeiouAEIOUaeiouAEIOUaeiouAEIOU')", (Type)VarcharType.VARCHAR, "Varzea Paulista");
        this.assertFunction("translate('\ud840\udc00bcd', '\ud840\udc00', 'z')", (Type)VarcharType.VARCHAR, "zbcd");
        this.assertFunction("translate('\ud840\udc00bcd\ud840\udc00', '\ud840\udc00', 'z')", (Type)VarcharType.VARCHAR, "zbcdz");
        this.assertFunction("translate('abcd', 'b', '\ud840\udc00')", (Type)VarcharType.VARCHAR, "a\ud840\udc00cd");
        this.assertFunction("translate('abcd', 'a', '')", (Type)VarcharType.VARCHAR, "bcd");
        this.assertFunction("translate('abcd', 'a', 'zy')", (Type)VarcharType.VARCHAR, "zbcd");
        this.assertFunction("translate('abcd', 'ac', 'z')", (Type)VarcharType.VARCHAR, "zbd");
        this.assertFunction("translate('abcd', 'aac', 'zq')", (Type)VarcharType.VARCHAR, "zbd");
    }

    @Test
    public void testSoundex() {
        this.assertFunction("soundex('jim')", (Type)VarcharType.createVarcharType((int)4), "J500");
        this.assertFunction("soundex('jIM')", (Type)VarcharType.createVarcharType((int)4), "J500");
        this.assertFunction("soundex('JIM')", (Type)VarcharType.createVarcharType((int)4), "J500");
        this.assertFunction("soundex('Jim')", (Type)VarcharType.createVarcharType((int)4), "J500");
        this.assertFunction("soundex('John')", (Type)VarcharType.createVarcharType((int)4), "J500");
        this.assertFunction("soundex('johannes')", (Type)VarcharType.createVarcharType((int)4), "J520");
        this.assertFunction("soundex('Sarah')", (Type)VarcharType.createVarcharType((int)4), "S600");
        this.assertFunction("soundex(null)", (Type)VarcharType.createVarcharType((int)4), null);
        this.assertFunction("soundex('')", (Type)VarcharType.createVarcharType((int)4), "");
        this.assertFunction("soundex('123')", (Type)VarcharType.createVarcharType((int)4), "");
        this.assertFunction("soundex('\ud83d\ude80')", (Type)VarcharType.createVarcharType((int)4), "");
        this.assertFunction("soundex('j~im')", (Type)VarcharType.createVarcharType((int)4), "J500");
        this.assertInvalidFunction("soundex('j\u0105mes')", "The character is not mapped: \u0104 (index=195)");
        this.assertFunction("soundex('x123')", (Type)VarcharType.createVarcharType((int)4), "X000");
    }
}

