/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import com.google.common.io.Resources;
import io.airlift.security.pem.PemReader;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import io.trino.server.security.jwt.EcCurve;
import io.trino.server.security.jwt.JwkDecoder;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJwkDecoder {
    @Test
    public void testReadRsaKeys() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"e\": \"AQAB\",\n      \"n\": \"mvj-0waJ2owQlFWrlC06goLs9PcNehIzCF0QrkdsYZJXOsipcHCFlXBsgQIdTdLvlCzNI07jSYA-zggycYi96lfDX-FYv_CqC8dRLf9TBOPvUgCyFMCFNUTC69hsrEYMR_J79Wj0MIOffiVr6eX-AaCG3KhBMZMh15KCdn3uVrl9coQivy7bk2Uw-aUJ_b26C0gWYj1DnpO4UEEKBk1X-lpeUMh0B_XorqWeq0NYK2pN6CoEIh0UrzYKlGfdnMU1pJJCsNxMiha-Vw3qqxez6oytOV_AswlWvQc7TkSX6cHfqepNskQb7pGxpgQpy9sA34oIxB_S-O7VS7_h0Qh4vQ\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"example-rsa\"\n    },\n    {\n      \"kty\": \"EC\",\n      \"use\": \"sig\",\n      \"crv\": \"P-256\",\n      \"kid\": \"example-ec\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\",\n      \"alg\": \"ES256\"\n    }\n  ]\n}");
        Assert.assertEquals((int)keys.size(), (int)2);
        Assert.assertTrue((boolean)(keys.get("example-rsa") instanceof JwkDecoder.JwkRsaPublicKey));
        Assert.assertTrue((boolean)(keys.get("example-ec") instanceof JwkDecoder.JwkEcPublicKey));
    }

    @Test
    public void testNoKeyId() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"e\": \"AQAB\",\n      \"n\": \"mvj-0waJ2owQlFWrlC06goLs9PcNehIzCF0QrkdsYZJXOsipcHCFlXBsgQIdTdLvlCzNI07jSYA-zggycYi96lfDX-FYv_CqC8dRLf9TBOPvUgCyFMCFNUTC69hsrEYMR_J79Wj0MIOffiVr6eX-AaCG3KhBMZMh15KCdn3uVrl9coQivy7bk2Uw-aUJ_b26C0gWYj1DnpO4UEEKBk1X-lpeUMh0B_XorqWeq0NYK2pN6CoEIh0UrzYKlGfdnMU1pJJCsNxMiha-Vw3qqxez6oytOV_AswlWvQc7TkSX6cHfqepNskQb7pGxpgQpy9sA34oIxB_S-O7VS7_h0Qh4vQ\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\"\n    },\n    {\n      \"kty\": \"EC\",\n      \"use\": \"sig\",\n      \"crv\": \"P-256\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\",\n      \"alg\": \"ES256\"\n    }\n  ]\n}");
        Assert.assertEquals((int)keys.size(), (int)0);
    }

    @Test
    public void testRsaNoModulus() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"e\": \"AQAB\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"2c6fa6f5950a7ce465fcf247aa0b094828ac952c\"\n    }\n  ]\n}");
        Assert.assertEquals((int)keys.size(), (int)0);
    }

    @Test
    public void testRsaNoExponent() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"n\": \"mvj-0waJ2owQlFWrlC06goLs9PcNehIzCF0QrkdsYZJXOsipcHCFlXBsgQIdTdLvlCzNI07jSYA-zggycYi96lfDX-FYv_CqC8dRLf9TBOPvUgCyFMCFNUTC69hsrEYMR_J79Wj0MIOffiVr6eX-AaCG3KhBMZMh15KCdn3uVrl9coQivy7bk2Uw-aUJ_b26C0gWYj1DnpO4UEEKBk1X-lpeUMh0B_XorqWeq0NYK2pN6CoEIh0UrzYKlGfdnMU1pJJCsNxMiha-Vw3qqxez6oytOV_AswlWvQc7TkSX6cHfqepNskQb7pGxpgQpy9sA34oIxB_S-O7VS7_h0Qh4vQ\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"2c6fa6f5950a7ce465fcf247aa0b094828ac952c\"\n    }\n  ]\n}");
        Assert.assertEquals((int)keys.size(), (int)0);
    }

    @Test
    public void testRsaInvalidModulus() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"e\": \"AQAB\",\n      \"n\": \"!!INVALID!!\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"2c6fa6f5950a7ce465fcf247aa0b094828ac952c\"\n    }\n  ]\n}");
        Assert.assertEquals((int)keys.size(), (int)0);
    }

    @Test
    public void testRsaInvalidExponent() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"e\": \"!!INVALID!!\",\n      \"n\": \"mvj-0waJ2owQlFWrlC06goLs9PcNehIzCF0QrkdsYZJXOsipcHCFlXBsgQIdTdLvlCzNI07jSYA-zggycYi96lfDX-FYv_CqC8dRLf9TBOPvUgCyFMCFNUTC69hsrEYMR_J79Wj0MIOffiVr6eX-AaCG3KhBMZMh15KCdn3uVrl9coQivy7bk2Uw-aUJ_b26C0gWYj1DnpO4UEEKBk1X-lpeUMh0B_XorqWeq0NYK2pN6CoEIh0UrzYKlGfdnMU1pJJCsNxMiha-Vw3qqxez6oytOV_AswlWvQc7TkSX6cHfqepNskQb7pGxpgQpy9sA34oIxB_S-O7VS7_h0Qh4vQ\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"2c6fa6f5950a7ce465fcf247aa0b094828ac952c\"\n    }\n  ]\n}");
        Assert.assertEquals((int)keys.size(), (int)0);
    }

    @Test
    public void testJwtRsa() throws Exception {
        String jwkKeys = Resources.toString((URL)Resources.getResource((String)"jwk/jwk-public.json"), (Charset)StandardCharsets.UTF_8);
        Map keys = JwkDecoder.decodeKeys((String)jwkKeys);
        final RSAPublicKey publicKey = (RSAPublicKey)keys.get("test-rsa");
        Assert.assertNotNull((Object)publicKey);
        RSAPublicKey expectedPublicKey = (RSAPublicKey)PemReader.loadPublicKey((File)new File(Resources.getResource((String)"jwk/jwk-rsa-public.pem").getPath()));
        Assert.assertEquals((Object)publicKey.getPublicExponent(), (Object)expectedPublicKey.getPublicExponent());
        Assert.assertEquals((Object)publicKey.getModulus(), (Object)expectedPublicKey.getModulus());
        PrivateKey privateKey = PemReader.loadPrivateKey((File)new File(Resources.getResource((String)"jwk/jwk-rsa-private.pem").getPath()), Optional.empty());
        String jwt = Jwts.builder().signWith((Key)privateKey).setHeaderParam("kid", (Object)"test-rsa").setSubject("test-user").setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
        Jws claimsJws = Jwts.parserBuilder().setSigningKeyResolver(new SigningKeyResolver(){

            public Key resolveSigningKey(JwsHeader header, Claims claims) {
                return this.getKey(header);
            }

            public Key resolveSigningKey(JwsHeader header, String plaintext) {
                return this.getKey(header);
            }

            private Key getKey(JwsHeader<?> header) {
                String keyId = header.getKeyId();
                Assert.assertEquals((String)keyId, (String)"test-rsa");
                return publicKey;
            }
        }).build().parseClaimsJws(jwt);
        Assert.assertEquals((String)((Claims)claimsJws.getBody()).getSubject(), (String)"test-user");
    }

    @Test
    public void testEcKey() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"kid\": \"test-ec\",\n      \"kty\": \"EC\",\n      \"crv\": \"P-256\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\"\n    }\n  ]\n}");
        Assert.assertEquals((int)keys.size(), (int)1);
        Assert.assertTrue((boolean)(keys.get("test-ec") instanceof JwkDecoder.JwkEcPublicKey));
    }

    @Test
    public void testEcInvalidCurve() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"kid\": \"test-ec\",\n      \"kty\": \"EC\",\n      \"crv\": \"taco\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\"\n    }\n  ]\n}");
        Assert.assertEquals((int)keys.size(), (int)0);
    }

    @Test
    public void testEcInvalidX() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"kid\": \"test-ec\",\n      \"kty\": \"EC\",\n      \"crv\": \"P-256\",\n      \"x\": \"!!INVALID!!\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\"\n    }\n  ]\n}");
        Assert.assertEquals((int)keys.size(), (int)0);
    }

    @Test
    public void testEcInvalidY() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"kid\": \"test-ec\",\n      \"kty\": \"EC\",\n      \"crv\": \"P-256\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"!!INVALID!!\"\n    }\n  ]\n}");
        Assert.assertEquals((int)keys.size(), (int)0);
    }

    @Test
    public void testJwtEc() throws Exception {
        TestJwkDecoder.assertJwtEc("jwk-ec-p256", EcCurve.P_256);
        TestJwkDecoder.assertJwtEc("jwk-ec-p384", EcCurve.P_384);
        TestJwkDecoder.assertJwtEc("jwk-ec-p512", EcCurve.P_521);
    }

    private static void assertJwtEc(final String keyName, ECParameterSpec expectedSpec) throws Exception {
        String jwkKeys = Resources.toString((URL)Resources.getResource((String)"jwk/jwk-public.json"), (Charset)StandardCharsets.UTF_8);
        Map keys = JwkDecoder.decodeKeys((String)jwkKeys);
        final ECPublicKey publicKey = (ECPublicKey)keys.get(keyName);
        Assert.assertNotNull((Object)publicKey);
        Assert.assertSame((Object)publicKey.getParams(), (Object)expectedSpec);
        ECPublicKey expectedPublicKey = (ECPublicKey)PemReader.loadPublicKey((File)new File(Resources.getResource((String)("jwk/" + keyName + "-public.pem")).getPath()));
        Assert.assertEquals((Object)publicKey.getW(), (Object)expectedPublicKey.getW());
        Assert.assertEquals((Object)publicKey.getParams().getCurve(), (Object)expectedPublicKey.getParams().getCurve());
        Assert.assertEquals((Object)publicKey.getParams().getGenerator(), (Object)expectedPublicKey.getParams().getGenerator());
        Assert.assertEquals((Object)publicKey.getParams().getOrder(), (Object)expectedPublicKey.getParams().getOrder());
        Assert.assertEquals((int)publicKey.getParams().getCofactor(), (int)expectedPublicKey.getParams().getCofactor());
        PrivateKey privateKey = PemReader.loadPrivateKey((File)new File(Resources.getResource((String)("jwk/" + keyName + "-private.pem")).getPath()), Optional.empty());
        String jwt = Jwts.builder().signWith((Key)privateKey).setHeaderParam("kid", (Object)keyName).setSubject("test-user").setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
        Jws claimsJws = Jwts.parserBuilder().setSigningKeyResolver(new SigningKeyResolver(){

            public Key resolveSigningKey(JwsHeader header, Claims claims) {
                return this.getKey(header);
            }

            public Key resolveSigningKey(JwsHeader header, String plaintext) {
                return this.getKey(header);
            }

            private Key getKey(JwsHeader<?> header) {
                String keyId = header.getKeyId();
                Assert.assertEquals((String)keyId, (String)keyName);
                return publicKey;
            }
        }).build().parseClaimsJws(jwt);
        Assert.assertEquals((String)((Claims)claimsJws.getBody()).getSubject(), (String)"test-user");
    }
}

