/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.server.security.oauth2.OAuth2Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestOAuth2Config {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OAuth2Config)ConfigAssertions.recordDefaults(OAuth2Config.class)).setStateKey(null).setIssuer(null).setAccessTokenIssuer(null).setAuthUrl(null).setTokenUrl(null).setJwksUrl(null).setUserinfoUrl(null).setClientId(null).setClientSecret(null).setScopes("openid").setChallengeTimeout(new Duration(15.0, TimeUnit.MINUTES)).setPrincipalField("sub").setAdditionalAudiences(Collections.emptyList()).setUserMappingPattern(null).setUserMappingFile(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path userMappingFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"http-server.authentication.oauth2.state-key", (Object)"key-secret").put((Object)"http-server.authentication.oauth2.issuer", (Object)"http://127.0.0.1:9000/oauth2").put((Object)"http-server.authentication.oauth2.access-token-issuer", (Object)"http://127.0.0.1:9000/oauth2/access-token").put((Object)"http-server.authentication.oauth2.auth-url", (Object)"http://127.0.0.1:9000/oauth2/auth").put((Object)"http-server.authentication.oauth2.token-url", (Object)"http://127.0.0.1:9000/oauth2/token").put((Object)"http-server.authentication.oauth2.jwks-url", (Object)"http://127.0.0.1:9000/.well-known/jwks.json").put((Object)"http-server.authentication.oauth2.userinfo-url", (Object)"http://127.0.0.1:9000/oauth2/userinfo").put((Object)"http-server.authentication.oauth2.client-id", (Object)"another-consumer").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"consumer-secret").put((Object)"http-server.authentication.oauth2.scopes", (Object)"email,offline").put((Object)"http-server.authentication.oauth2.principal-field", (Object)"some-field").put((Object)"http-server.authentication.oauth2.additional-audiences", (Object)"test-aud1,test-aud2").put((Object)"http-server.authentication.oauth2.challenge-timeout", (Object)"90s").put((Object)"http-server.authentication.oauth2.user-mapping.pattern", (Object)"(.*)@something").put((Object)"http-server.authentication.oauth2.user-mapping.file", (Object)userMappingFile.toString()).build();
        OAuth2Config expected = new OAuth2Config().setStateKey("key-secret").setIssuer("http://127.0.0.1:9000/oauth2").setAccessTokenIssuer("http://127.0.0.1:9000/oauth2/access-token").setAuthUrl("http://127.0.0.1:9000/oauth2/auth").setTokenUrl("http://127.0.0.1:9000/oauth2/token").setJwksUrl("http://127.0.0.1:9000/.well-known/jwks.json").setUserinfoUrl("http://127.0.0.1:9000/oauth2/userinfo").setClientId("another-consumer").setClientSecret("consumer-secret").setScopes("email, offline").setPrincipalField("some-field").setAdditionalAudiences(List.of("test-aud1", "test-aud2")).setChallengeTimeout(new Duration(90.0, TimeUnit.SECONDS)).setUserMappingPattern("(.*)@something").setUserMappingFile(userMappingFile.toFile());
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

