/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.Resources;
import com.google.inject.Binder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.node.NodeInfo;
import io.airlift.security.pem.PemReader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import io.trino.client.OkHttpUtil;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.security.AccessControl;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.server.ui.FormAuthenticator;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.BasicPrincipal;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PasswordAuthenticator;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.SecretKey;
import javax.inject.Inject;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestWebUi {
    private static final String LOCALHOST_KEYSTORE = Resources.getResource((String)"cert/localhost.pem").getPath();
    private static final String ALLOWED_USER_MAPPING_PATTERN = "(.*)@allowed";
    private static final ImmutableMap<String, String> SECURE_PROPERTIES = ImmutableMap.builder().put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.process-forwarded", (Object)"true").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").build();
    private static final String STATE_KEY = "test-state-key";
    public static final String TOKEN_ISSUER = "http://example.com/";
    public static final String OAUTH_CLIENT_ID = "client";
    private static final ImmutableMap<String, String> OAUTH2_PROPERTIES = ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.authentication.type", (Object)"oauth2").put((Object)"http-server.authentication.oauth2.state-key", (Object)"test-state-key").put((Object)"http-server.authentication.oauth2.issuer", (Object)"http://example.com/").put((Object)"http-server.authentication.oauth2.auth-url", (Object)"http://example.com/").put((Object)"http-server.authentication.oauth2.token-url", (Object)"http://example.com/").put((Object)"http-server.authentication.oauth2.client-id", (Object)"client").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"client-secret").build();
    private static final String TEST_USER = "test-user";
    private static final String AUTHENTICATED_USER = "test-user@allowed";
    private static final String FORM_LOGIN_USER = "form-login-user";
    private static final String TEST_PASSWORD = "test-password";
    private static final String TEST_PASSWORD2 = "test-password2";
    private static final String HMAC_KEY = Resources.getResource((String)"hmac_key.txt").getPath();
    private static final PrivateKey JWK_PRIVATE_KEY;
    private OkHttpClient client;
    private Path passwordConfigDummy;

    @BeforeClass
    public void setup() throws IOException {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().followRedirects(false);
        OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty());
        this.client = clientBuilder.build();
        this.passwordConfigDummy = Files.createTempFile("passwordConfigDummy", "", new FileAttribute[0]);
        this.passwordConfigDummy.toFile().deleteOnExit();
    }

    @Test
    public void testInsecureAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.insecure.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).build()).setAdditionalModule(binder -> JaxrsBinder.jaxrsBinder((Binder)binder).bind(TestResource.class)).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testFormAuthentication(server, httpServerInfo, AUTHENTICATED_USER, TEST_PASSWORD, false);
        }
    }

    @Test
    public void testPasswordAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).build()).setAdditionalModule(binder -> JaxrsBinder.jaxrsBinder((Binder)binder).bind(TestResource.class)).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestWebUi::authenticate});
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testFormAuthentication(server, httpServerInfo, AUTHENTICATED_USER, TEST_PASSWORD, true);
        }
    }

    @Test
    public void testMultiplePasswordAuthenticators() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).put((Object)"http-server.authentication.password.user-mapping.pattern", (Object)ALLOWED_USER_MAPPING_PATTERN).build()).setAdditionalModule(binder -> JaxrsBinder.jaxrsBinder((Binder)binder).bind(TestResource.class)).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticators(new PasswordAuthenticator[]{TestWebUi::authenticate, TestWebUi::authenticate2});
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testFormAuthentication(server, httpServerInfo, AUTHENTICATED_USER, TEST_PASSWORD, true);
            this.testFormAuthentication(server, httpServerInfo, AUTHENTICATED_USER, TEST_PASSWORD2, true);
        }
    }

    private void testFormAuthentication(TestingTrinoServer server, HttpServerInfo httpServerInfo, String username, String password, boolean sendPasswordForHttps) throws Exception {
        TestWebUi.testRootRedirect(httpServerInfo.getHttpUri(), this.client);
        TestWebUi.testRootRedirect(httpServerInfo.getHttpsUri(), this.client);
        String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
        this.testWorkerResource(nodeId, httpServerInfo.getHttpUri(), username, password, false);
        this.testWorkerResource(nodeId, httpServerInfo.getHttpsUri(), username, password, sendPasswordForHttps);
        this.testLoggedOut(httpServerInfo.getHttpUri());
        this.testLoggedOut(httpServerInfo.getHttpsUri());
        this.testLogIn(httpServerInfo.getHttpUri(), username, password, false);
        this.testLogIn(httpServerInfo.getHttpsUri(), username, password, sendPasswordForHttps);
        this.testFailedLogin(httpServerInfo.getHttpUri(), false, password);
        this.testFailedLogin(httpServerInfo.getHttpsUri(), sendPasswordForHttps, password);
        this.testUserMapping(httpServerInfo.getHttpsUri(), username, password, sendPasswordForHttps);
    }

    private static void testRootRedirect(URI baseUri, OkHttpClient client) throws IOException {
        TestWebUi.assertRedirect(client, HttpUriBuilder.uriBuilderFrom((URI)baseUri).toString(), TestWebUi.getUiLocation(baseUri));
    }

    private void testLoggedOut(URI baseUri) throws IOException {
        TestWebUi.assertRedirect(this.client, TestWebUi.getUiLocation(baseUri), TestWebUi.getLoginHtmlLocation(baseUri));
        TestWebUi.assertRedirect(this.client, TestWebUi.getLocation(baseUri, "/ui/query.html", "abc123"), TestWebUi.getLocation(baseUri, "/ui/login.html", "/ui/query.html?abc123"), false);
        TestWebUi.assertResponseCode(this.client, TestWebUi.getValidApiLocation(baseUri), 401);
        TestWebUi.assertOk(this.client, TestWebUi.getValidAssetsLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidVendorLocation(baseUri));
    }

    private void testLogIn(URI baseUri, String username, String password, boolean sendPassword) throws Exception {
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        String body = TestWebUi.assertOk(client, TestWebUi.getLoginHtmlLocation(baseUri)).orElseThrow(() -> new AssertionError((Object)"No response body"));
        Assertions.assertThat((String)body).contains(new CharSequence[]{"action=\"/ui/login\""});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"method=\"post\""});
        Assertions.assertThat((String)body).doesNotContain(new CharSequence[]{"// This value will be replaced"});
        if (sendPassword) {
            Assertions.assertThat((String)body).contains(new CharSequence[]{"var hidePassword = false;"});
        } else {
            Assertions.assertThat((String)body).contains(new CharSequence[]{"var hidePassword = true;"});
        }
        TestWebUi.logIn(baseUri, client, username, password, sendPassword);
        HttpCookie cookie = (HttpCookie)Iterables.getOnlyElement(cookieManager.getCookieStore().getCookies());
        io.trino.testing.assertions.Assert.assertEquals((String)cookie.getPath(), (String)"/ui");
        io.trino.testing.assertions.Assert.assertEquals((String)cookie.getDomain(), (String)baseUri.getHost());
        io.trino.testing.assertions.Assert.assertEquals((long)cookie.getMaxAge(), (long)-1L);
        Assert.assertTrue((boolean)cookie.isHttpOnly());
        TestWebUi.assertOk(client, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(client, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
        TestWebUi.assertRedirect(client, TestWebUi.getLogoutLocation(baseUri), TestWebUi.getLoginHtmlLocation(baseUri), false);
        Assertions.assertThat(cookieManager.getCookieStore().getCookies()).isEmpty();
    }

    private void testFailedLogin(URI uri, boolean passwordAllowed, String password) throws IOException {
        this.testFailedLogin(uri, Optional.empty(), Optional.empty());
        this.testFailedLogin(uri, Optional.empty(), Optional.of(password));
        this.testFailedLogin(uri, Optional.empty(), Optional.of("unknown"));
        if (passwordAllowed) {
            this.testFailedLogin(uri, Optional.of(TEST_USER), Optional.of("unknown"));
            this.testFailedLogin(uri, Optional.of(AUTHENTICATED_USER), Optional.of("unknown"));
            this.testFailedLogin(uri, Optional.of(FORM_LOGIN_USER), Optional.of("unknown"));
            this.testFailedLogin(uri, Optional.of("unknown"), Optional.of(password));
            this.testFailedLogin(uri, Optional.of(TEST_USER), Optional.empty());
            this.testFailedLogin(uri, Optional.of(AUTHENTICATED_USER), Optional.empty());
            this.testFailedLogin(uri, Optional.of(FORM_LOGIN_USER), Optional.empty());
            this.testFailedLogin(uri, Optional.of("unknown"), Optional.empty());
        }
    }

    private void testFailedLogin(URI httpsUrl, Optional<String> username, Optional<String> password) throws IOException {
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        FormBody.Builder formData = new FormBody.Builder();
        username.ifPresent(value -> formData.add("username", value));
        password.ifPresent(value -> formData.add("password", value));
        Request request = new Request.Builder().url(TestWebUi.getLoginLocation(httpsUrl)).post((RequestBody)formData.build()).build();
        try (Response response = client.newCall(request).execute();){
            io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
            io.trino.testing.assertions.Assert.assertEquals((String)response.header("Location"), (String)TestWebUi.getLoginHtmlLocation(httpsUrl));
            Assert.assertTrue((boolean)cookieManager.getCookieStore().getCookies().isEmpty());
        }
    }

    private void testWorkerResource(String nodeId, URI baseUri, String username, String password, boolean sendPassword) throws Exception {
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)new CookieManager())).build();
        TestWebUi.logIn(baseUri, client, username, password, sendPassword);
        TestWebUi.testWorkerResource(nodeId, baseUri, client);
    }

    private static void testWorkerResource(String nodeId, URI baseUri, OkHttpClient authorizedClient) throws IOException {
        TestWebUi.assertOk(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/worker/" + nodeId + "/status"));
        TestWebUi.assertOk(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/worker/" + nodeId + "/thread"));
    }

    private void testUserMapping(URI baseUri, String username, String password, boolean sendPassword) throws Exception {
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)new CookieManager())).build();
        TestWebUi.logIn(baseUri, client, username, password, sendPassword);
        Request request = new Request.Builder().url(TestWebUi.getLocation(baseUri, "/ui/username/")).build();
        try (Response response = client.newCall(request).execute();){
            io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)200);
            io.trino.testing.assertions.Assert.assertEquals((String)response.header("user"), (String)TEST_USER);
        }
    }

    private static void logIn(URI baseUri, OkHttpClient client, String username, String password, boolean sendPassword) throws IOException {
        FormBody.Builder formData = new FormBody.Builder().add("username", username);
        if (sendPassword) {
            formData.add("password", password);
        }
        Request request = new Request.Builder().url(TestWebUi.getLoginLocation(baseUri)).post((RequestBody)formData.build()).build();
        Response response = client.newCall(request).execute();
        io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
        io.trino.testing.assertions.Assert.assertEquals((String)response.header("Location"), (String)TestWebUi.getUiLocation(baseUri));
    }

    @Test
    public void testDisabled() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.enabled", (Object)"false").build()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testDisabled(httpServerInfo.getHttpUri());
            this.testDisabled(httpServerInfo.getHttpsUri());
        }
    }

    private void testDisabled(URI baseUri) throws Exception {
        TestWebUi.assertRedirect(this.client, TestWebUi.getUiLocation(baseUri), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertRedirect(this.client, TestWebUi.getLocation(baseUri, "/ui/query.html", "abc123"), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertResponseCode(this.client, TestWebUi.getValidApiLocation(baseUri), 401);
        TestWebUi.assertRedirect(this.client, TestWebUi.getLoginLocation(baseUri), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertRedirect(this.client, TestWebUi.getLogoutLocation(baseUri), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidAssetsLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidVendorLocation(baseUri));
    }

    @Test
    public void testNoPasswordAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").put((Object)"password-authenticator.config-files", (Object)this.passwordConfigDummy.toString()).build()).build();){
            FormAuthenticator formAuthenticator = (FormAuthenticator)server.getInstance(com.google.inject.Key.get(FormAuthenticator.class));
            Assertions.assertThatThrownBy(() -> formAuthenticator.isValidCredential(TEST_USER, TEST_USER, true)).hasMessage("authenticators were not loaded").isInstanceOf(IllegalStateException.class);
            Assert.assertTrue((boolean)formAuthenticator.isLoginEnabled(true));
        }
    }

    @Test
    public void testFixedAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.authentication.type", (Object)"fixed").put((Object)"web-ui.user", (Object)TEST_USER).build()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpUri(), this.client, nodeId);
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), this.client, nodeId);
            this.testFixedAuthenticator(httpServerInfo.getHttpUri());
            this.testFixedAuthenticator(httpServerInfo.getHttpsUri());
        }
    }

    private void testFixedAuthenticator(URI baseUri) throws Exception {
        TestWebUi.assertOk(this.client, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertResponseCode(this.client, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(this.client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
    }

    @Test
    public void testCertAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"certificate").put((Object)"http-server.https.truststore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.truststore.key", (Object)"").build()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            this.testLogIn(httpServerInfo.getHttpUri(), FORM_LOGIN_USER, TEST_PASSWORD, false);
            TestWebUi.testNeverAuthorized(httpServerInfo.getHttpsUri(), this.client);
            OkHttpClient.Builder clientBuilder = this.client.newBuilder();
            OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty());
            OkHttpClient clientWithCert = clientBuilder.build();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), clientWithCert, nodeId);
        }
    }

    @Test
    public void testJwtAuthenticator() throws Exception {
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)HMAC_KEY).build()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            this.testLogIn(httpServerInfo.getHttpUri(), FORM_LOGIN_USER, TEST_PASSWORD, false);
            TestWebUi.testNeverAuthorized(httpServerInfo.getHttpsUri(), this.client);
            SecretKey hmac = Keys.hmacShaKeyFor((byte[])Base64.getDecoder().decode(Files.readString(Paths.get(HMAC_KEY, new String[0])).trim()));
            String token = Jwts.builder().signWith((Key)hmac).setSubject(TEST_USER).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), clientWithJwt, nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJwtWithJwkAuthenticator() throws Exception {
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)jwkServer.getBaseUrl().toString()).build()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            this.testLogIn(httpServerInfo.getHttpUri(), FORM_LOGIN_USER, TEST_PASSWORD, false);
            TestWebUi.testNeverAuthorized(httpServerInfo.getHttpsUri(), this.client);
            String token = Jwts.builder().signWith((Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)"test-rsa").setSubject(TEST_USER).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), clientWithJwt, nodeId);
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOAuth2Authenticator() throws Exception {
        String accessToken = TestWebUi.createTokenBuilder().compact();
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(OAUTH2_PROPERTIES).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).build()).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)new OAuth2ClientStub(accessToken))).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuth2Authentication(httpServerInfo, accessToken);
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOAuth2AuthenticatorWithoutOpenIdScope() throws Exception {
        String accessToken = TestWebUi.createTokenBuilder().compact();
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(OAUTH2_PROPERTIES).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.scopes", (Object)"").build()).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)new OAuth2ClientStub(accessToken))).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuth2Authentication(httpServerInfo, accessToken);
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCustomPrincipalField() throws Exception {
        String accessToken = TestWebUi.createTokenBuilder().setSubject("unknown").addClaims((Map)ImmutableMap.of((Object)"preferred_username", (Object)"test-user@email.com")).compact();
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingTrinoServer server = TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(OAUTH2_PROPERTIES).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.principal-field", (Object)"preferred_username").put((Object)"http-server.authentication.oauth2.user-mapping.pattern", (Object)"(.*)@.*").build()).setAdditionalModule(binder -> {
            OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)new OAuth2ClientStub(accessToken));
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(AuthenticatedIdentityCapturingFilter.class);
        }).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.assertAuth2Authentication(httpServerInfo, accessToken);
            Identity identity = ((AuthenticatedIdentityCapturingFilter)server.getInstance(com.google.inject.Key.get(AuthenticatedIdentityCapturingFilter.class))).getAuthenticatedIdentity();
            Assertions.assertThat((String)identity.getUser()).isEqualTo(TEST_USER);
            Assertions.assertThat((Optional)identity.getPrincipal()).isEqualTo(Optional.of(new BasicPrincipal("test-user@email.com")));
        }
        finally {
            jwkServer.stop();
        }
    }

    private void assertAuth2Authentication(HttpServerInfo httpServerInfo, String accessToken) throws Exception {
        String state = Jwts.builder().signWith((Key)Keys.hmacShaKeyFor((byte[])Hashing.sha256().hashString((CharSequence)STATE_KEY, StandardCharsets.UTF_8).asBytes())).setAudience("trino_oauth_ui").setExpiration(Date.from(ZonedDateTime.now().plusMinutes(10L).toInstant())).compact();
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        this.testDisabled(httpServerInfo.getHttpUri());
        URI baseUri = httpServerInfo.getHttpsUri();
        TestWebUi.testRootRedirect(baseUri, client);
        TestWebUi.assertRedirect(client, TestWebUi.getUiLocation(baseUri), "http://example.com/authorize", false);
        TestWebUi.assertResponseCode(client, TestWebUi.getValidApiLocation(baseUri), Response.Status.UNAUTHORIZED.getStatusCode());
        TestWebUi.assertRedirect(client, TestWebUi.getLocation(baseUri, "/ui/unknown"), "http://example.com/authorize", false);
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), Response.Status.UNAUTHORIZED.getStatusCode());
        TestWebUi.assertRedirect(client, HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath("/oauth2/callback").addParameter("code", new String[]{"TEST_CODE"}).addParameter("state", new String[]{state}).toString(), TestWebUi.getUiLocation(baseUri), false);
        HttpCookie cookie = (HttpCookie)Iterables.getOnlyElement(cookieManager.getCookieStore().getCookies());
        io.trino.testing.assertions.Assert.assertEquals((String)cookie.getValue(), (String)accessToken);
        io.trino.testing.assertions.Assert.assertEquals((String)cookie.getPath(), (String)"/ui/");
        io.trino.testing.assertions.Assert.assertEquals((String)cookie.getDomain(), (String)baseUri.getHost());
        Assert.assertTrue((cookie.getMaxAge() > 0L && cookie.getMaxAge() < TimeUnit.MINUTES.toSeconds(5L) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cookie.isHttpOnly());
        TestWebUi.testRootRedirect(baseUri, client);
        TestWebUi.assertOk(client, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(client, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(client, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
        TestWebUi.assertOk(client, TestWebUi.getLogoutLocation(baseUri));
        Assertions.assertThat(cookieManager.getCookieStore().getCookies()).isEmpty();
        TestWebUi.assertRedirect(client, TestWebUi.getUiLocation(baseUri), "http://example.com/authorize", false);
    }

    private static void testAlwaysAuthorized(URI baseUri, OkHttpClient authorizedClient, String nodeId) throws IOException {
        TestWebUi.testRootRedirect(baseUri, authorizedClient);
        TestWebUi.testWorkerResource(nodeId, baseUri, authorizedClient);
        TestWebUi.assertOk(authorizedClient, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(authorizedClient, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertRedirect(authorizedClient, TestWebUi.getLoginHtmlLocation(baseUri), TestWebUi.getUiLocation(baseUri), false);
        TestWebUi.assertRedirect(authorizedClient, TestWebUi.getLoginLocation(baseUri), TestWebUi.getUiLocation(baseUri), false);
        TestWebUi.assertRedirect(authorizedClient, TestWebUi.getLogoutLocation(baseUri), TestWebUi.getUiLocation(baseUri), false);
        TestWebUi.assertResponseCode(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
    }

    private static void testNeverAuthorized(URI baseUri, OkHttpClient notAuthorizedClient) throws IOException {
        TestWebUi.testRootRedirect(baseUri, notAuthorizedClient);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getUiLocation(baseUri), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getValidApiLocation(baseUri), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLoginLocation(baseUri), 401, true);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLogoutLocation(baseUri), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLocation(baseUri, "/ui/unknown"), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 401);
    }

    private static Optional<String> assertOk(OkHttpClient client, String url) throws IOException {
        return TestWebUi.assertResponseCode(client, url, 200);
    }

    private static void assertRedirect(OkHttpClient client, String url, String redirectLocation) throws IOException {
        TestWebUi.assertRedirect(client, url, redirectLocation, true);
    }

    private static void assertRedirect(OkHttpClient client, String url, String redirectLocation, boolean testProxy) throws IOException {
        Request request = new Request.Builder().url(url).build();
        if (url.endsWith("/ui/login")) {
            FormBody formBody = new FormBody.Builder().add("username", "test").add("password", "test").build();
            request = request.newBuilder().post((RequestBody)formBody).build();
        }
        try (Response response = client.newCall(request).execute();){
            io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
            io.trino.testing.assertions.Assert.assertEquals((String)response.header("Location"), (String)redirectLocation);
        }
        if (testProxy) {
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").header("X-Forwarded-Host", "my-load-balancer.local").header("X-Forwarded-Port", "123").build();
            response = client.newCall(request).execute();
            try {
                io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
                io.trino.testing.assertions.Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").header("X-Forwarded-Host", "my-load-balancer.local:123").build();
            response = client.newCall(request).execute();
            try {
                io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
                io.trino.testing.assertions.Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").header("X-Forwarded-Port", "123").build();
            response = client.newCall(request).execute();
            try {
                io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
                io.trino.testing.assertions.Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").build();
            response = client.newCall(request).execute();
            try {
                io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
                io.trino.testing.assertions.Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Host", "my-load-balancer.local").header("X-Forwarded-Port", "123").build();
            response = client.newCall(request).execute();
            try {
                io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
                io.trino.testing.assertions.Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Host", "my-load-balancer.local:123").build();
            response = client.newCall(request).execute();
            try {
                io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
                io.trino.testing.assertions.Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Host", "my-load-balancer.local").build();
            response = client.newCall(request).execute();
            try {
                io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)303);
                io.trino.testing.assertions.Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).host("my-load-balancer.local").defaultPort().toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    private static Optional<String> assertResponseCode(OkHttpClient client, String url, int expectedCode) throws IOException {
        return TestWebUi.assertResponseCode(client, url, expectedCode, false);
    }

    private static Optional<String> assertResponseCode(OkHttpClient client, String url, int expectedCode, boolean postLogin) throws IOException {
        Request request = new Request.Builder().url(url).build();
        if (postLogin) {
            FormBody formBody = new FormBody.Builder().add("username", "fake").add("password", "bad").build();
            request = request.newBuilder().post((RequestBody)formBody).build();
        }
        try (Response response = client.newCall(request).execute();){
            io.trino.testing.assertions.Assert.assertEquals((int)response.code(), (int)expectedCode, (String)url);
            Optional<String> optional = Optional.ofNullable(response.body()).map(responseBody -> {
                try {
                    return responseBody.string();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return optional;
        }
    }

    private static Principal authenticate(String user, String password) {
        if (AUTHENTICATED_USER.equals(user) && TEST_PASSWORD.equals(password)) {
            return new BasicPrincipal(AUTHENTICATED_USER);
        }
        throw new AccessDeniedException("Invalid credentials");
    }

    private static Principal authenticate2(String user, String password) {
        if (AUTHENTICATED_USER.equals(user) && TEST_PASSWORD2.equals(password)) {
            return new BasicPrincipal(user);
        }
        throw new AccessDeniedException("Invalid credentials");
    }

    private static String getUiLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/");
    }

    private static String getLoginHtmlLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/login.html");
    }

    private static String getLoginLocation(URI httpsUrl) {
        return TestWebUi.getLocation(httpsUrl, "/ui/login");
    }

    private static String getLogoutLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/logout");
    }

    private static String getDisabledLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/disabled.html");
    }

    private static String getValidApiLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/api/cluster");
    }

    private static String getValidAssetsLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/assets/favicon.ico");
    }

    private static String getValidVendorLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/vendor/bootstrap/css/bootstrap.css");
    }

    private static String getLocation(URI baseUri, String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath(path).toString();
    }

    private static String getLocation(URI baseUri, String path, String query) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath(path).replaceParameter(query, new String[0]).toString();
    }

    private static JwtBuilder createTokenBuilder() {
        Date tokenExpiration = Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant());
        return Jwts.builder().signWith((Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)"test-rsa").setIssuer(TOKEN_ISSUER).setAudience(OAUTH_CLIENT_ID).setSubject(TEST_USER).setExpiration(tokenExpiration);
    }

    private static TestingHttpServer createTestingJwkServer() throws IOException {
        NodeInfo nodeInfo = new NodeInfo("test");
        HttpServerConfig config = new HttpServerConfig().setHttpPort(0);
        HttpServerInfo httpServerInfo = new HttpServerInfo(config, nodeInfo);
        return new TestingHttpServer(httpServerInfo, nodeInfo, config, (Servlet)new JwkServlet(), (Map)ImmutableMap.of());
    }

    static {
        try {
            JWK_PRIVATE_KEY = PemReader.loadPrivateKey((File)new File(Resources.getResource((String)"jwk/jwk-rsa-private.pem").getPath()), Optional.empty());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class AuthenticatedIdentityCapturingFilter
    implements ContainerRequestFilter {
        @GuardedBy(value="this")
        private Identity authenticatedIdentity;

        private AuthenticatedIdentityCapturingFilter() {
        }

        public synchronized void filter(ContainerRequestContext request) throws IOException {
            Optional<Identity> identity = Optional.ofNullable((Identity)request.getProperty("trino.authenticated-identity"));
            if (identity.map(Identity::getUser).filter(Predicate.not("<internal>"::equals)).isPresent()) {
                if (this.authenticatedIdentity == null) {
                    this.authenticatedIdentity = identity.get();
                }
                Preconditions.checkState((boolean)this.authenticatedIdentity.equals((Object)identity.get()), (Object)"Detected more than one user identity");
            }
        }

        public synchronized Identity getAuthenticatedIdentity() {
            return this.authenticatedIdentity;
        }
    }

    private static class JwkServlet
    extends HttpServlet {
        private JwkServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            String jwkKeys = Resources.toString((URL)Resources.getResource((String)"jwk/jwk-public.json"), (Charset)StandardCharsets.UTF_8);
            response.getWriter().println(jwkKeys);
        }
    }

    private static class OAuth2ClientStub
    implements OAuth2Client {
        private final String accessToken;
        private Optional<JwtBuilder> idTokenBuilder = Optional.empty();

        public OAuth2ClientStub(String accessToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken is null");
        }

        public URI getAuthorizationUri(String state, URI callbackUri, Optional<String> nonceHash) {
            nonceHash.ifPresent(nonce -> {
                this.idTokenBuilder = Optional.of(TestWebUi.createTokenBuilder().claim("nonce", nonce));
            });
            return URI.create("http://example.com/authorize");
        }

        public OAuth2Client.OAuth2Response getOAuth2Response(String code, URI callbackUri) {
            if (!"TEST_CODE".equals(code)) {
                throw new IllegalArgumentException("Expected TEST_CODE");
            }
            return new OAuth2Client.OAuth2Response(this.accessToken, Optional.empty(), this.idTokenBuilder.map(JwtBuilder::compact));
        }
    }

    @javax.ws.rs.Path(value="/ui/username")
    public static class TestResource {
        private final HttpRequestSessionContextFactory sessionContextFactory;

        @Inject
        public TestResource(AccessControl accessControl) {
            this.sessionContextFactory = new HttpRequestSessionContextFactory((Metadata)MetadataManager.createTestMetadataManager(), ImmutableSet::of, accessControl);
        }

        @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
        @GET
        public javax.ws.rs.core.Response echoToken(@Context HttpServletRequest servletRequest, @Context HttpHeaders httpHeaders) {
            Identity identity = this.sessionContextFactory.extractAuthorizedIdentity(servletRequest, httpHeaders, Optional.empty());
            return javax.ws.rs.core.Response.ok().header("user", (Object)identity.getUser()).build();
        }
    }
}

