/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import io.airlift.units.DataSize;
import io.trino.ExceededSpillLimitException;
import io.trino.spiller.SpillSpaceTracker;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSpillSpaceTracker {
    private static final DataSize MAX_DATA_SIZE = DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private SpillSpaceTracker spillSpaceTracker;

    @BeforeMethod
    public void setUp() {
        this.spillSpaceTracker = new SpillSpaceTracker(MAX_DATA_SIZE);
    }

    @Test
    public void testSpillSpaceTracker() {
        Assert.assertEquals((long)this.spillSpaceTracker.getCurrentBytes(), (long)0L);
        Assert.assertEquals((long)this.spillSpaceTracker.getMaxBytes(), (long)MAX_DATA_SIZE.toBytes());
        long reservedBytes = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
        this.spillSpaceTracker.reserve(reservedBytes);
        Assert.assertEquals((long)this.spillSpaceTracker.getCurrentBytes(), (long)reservedBytes);
        long otherReservedBytes = DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
        this.spillSpaceTracker.reserve(otherReservedBytes);
        Assert.assertEquals((long)this.spillSpaceTracker.getCurrentBytes(), (long)(reservedBytes + otherReservedBytes));
        this.spillSpaceTracker.reserve(otherReservedBytes);
        Assert.assertEquals((long)this.spillSpaceTracker.getCurrentBytes(), (long)(reservedBytes + 2L * otherReservedBytes));
        this.spillSpaceTracker.free(otherReservedBytes);
        this.spillSpaceTracker.free(otherReservedBytes);
        Assert.assertEquals((long)this.spillSpaceTracker.getCurrentBytes(), (long)reservedBytes);
        this.spillSpaceTracker.free(reservedBytes);
        Assert.assertEquals((long)this.spillSpaceTracker.getCurrentBytes(), (long)0L);
    }

    @Test
    public void testSpillOutOfSpace() {
        Assert.assertEquals((long)this.spillSpaceTracker.getCurrentBytes(), (long)0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.spillSpaceTracker.reserve(MAX_DATA_SIZE.toBytes() + 1L)).isInstanceOf(ExceededSpillLimitException.class)).hasMessageMatching("Query exceeded local spill limit of.*");
    }

    @Test
    public void testFreeToMuch() {
        Assert.assertEquals((long)this.spillSpaceTracker.getCurrentBytes(), (long)0L);
        this.spillSpaceTracker.reserve(1000L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.spillSpaceTracker.free(1001L)).isInstanceOf(IllegalArgumentException.class)).hasMessage("tried to free more disk space than is reserved");
    }
}

