/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestConnectorExpressionTranslator {
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final TypeAnalyzer TYPE_ANALYZER = TypeAnalyzer.createTestingTypeAnalyzer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT);
    private static final Type ROW_TYPE = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"int_symbol_1", (Type)IntegerType.INTEGER), RowType.field((String)"varchar_symbol_1", (Type)VarcharType.createVarcharType((int)5))});
    private static final LiteralEncoder LITERAL_ENCODER = new LiteralEncoder(TestingPlannerContext.PLANNER_CONTEXT);
    private static final Map<Symbol, Type> symbols = ImmutableMap.builder().put((Object)new Symbol("double_symbol_1"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("row_symbol_1"), (Object)ROW_TYPE).build();
    private static final TypeProvider TYPE_PROVIDER = TypeProvider.copyOf(symbols);
    private static final Map<String, Symbol> variableMappings = (Map)symbols.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((Symbol)entry.getKey()).getName(), Map.Entry::getKey));

    @Test
    public void testTranslationToConnectorExpression() {
        this.assertTranslationToConnectorExpression((Expression)new SymbolReference("double_symbol_1"), Optional.of(new Variable("double_symbol_1", (Type)DoubleType.DOUBLE)));
        this.assertTranslationToConnectorExpression((Expression)new SubscriptExpression((Expression)new SymbolReference("row_symbol_1"), (Expression)new LongLiteral("1")), Optional.of(new FieldDereference((Type)IntegerType.INTEGER, (ConnectorExpression)new Variable("row_symbol_1", ROW_TYPE), 0)));
    }

    @Test
    public void testTranslationFromConnectorExpression() {
        this.assertTranslationFromConnectorExpression((ConnectorExpression)new Variable("double_symbol_1", (Type)DoubleType.DOUBLE), (Expression)new SymbolReference("double_symbol_1"));
        this.assertTranslationFromConnectorExpression((ConnectorExpression)new FieldDereference((Type)IntegerType.INTEGER, (ConnectorExpression)new Variable("row_symbol_1", ROW_TYPE), 0), (Expression)new SubscriptExpression((Expression)new SymbolReference("row_symbol_1"), (Expression)new LongLiteral("1")));
    }

    private void assertTranslationToConnectorExpression(Expression expression, Optional<ConnectorExpression> connectorExpression) {
        Optional translation = ConnectorExpressionTranslator.translate((Session)TEST_SESSION, (Expression)expression, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER);
        Assert.assertEquals((boolean)connectorExpression.isPresent(), (boolean)translation.isPresent());
        translation.ifPresent(value -> Assert.assertEquals((Object)value, connectorExpression.get()));
    }

    private void assertTranslationFromConnectorExpression(ConnectorExpression connectorExpression, Expression expected) {
        Expression translation = ConnectorExpressionTranslator.translate((Session)TEST_SESSION, (ConnectorExpression)connectorExpression, variableMappings, (LiteralEncoder)LITERAL_ENCODER);
        Assert.assertEquals((Object)translation, (Object)expected);
    }
}

