/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Joiner;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.io.Closeable;
import java.util.Collections;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLocalExecutionPlanner {
    private LocalQueryRunner runner;

    @BeforeClass
    public void setUp() {
        this.runner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.runner});
        this.runner = null;
    }

    @Test
    public void testProjectionCompilerFailure() {
        String inner = "(" + Joiner.on((String)" + ").join(Collections.nCopies(100, "rand()")) + ")";
        String outer = "x + x + " + Joiner.on((String)" + ").join(Collections.nCopies(100, inner));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.runner.execute("SELECT " + outer + " FROM (VALUES rand()) t(x)")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR).hasMessageStartingWith("Query exceeded maximum columns");
    }

    @Test
    public void testFilterCompilerFailure() {
        String filterQueryInner = "FROM (SELECT rand() as c1, rand() as c2, rand() as c3)";
        String filterQueryWhere = "WHERE c1 = rand() OR " + Joiner.on((String)" AND ").join(Collections.nCopies(1000, "c1 = rand()")) + " OR " + Joiner.on((String)" AND ").join(Collections.nCopies(1000, " c2 = rand()")) + " OR " + Joiner.on((String)" AND ").join(Collections.nCopies(1000, " c3 = rand()"));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.runner.execute("SELECT * " + filterQueryInner + filterQueryWhere)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR).hasMessageStartingWith("Query exceeded maximum filters");
    }
}

