/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import io.airlift.slice.Slices;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.optimizations.AddLocalExchanges;
import io.trino.sql.planner.optimizations.CheckSubqueryNodesAreRewritten;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrQuantified;
import io.trino.sql.planner.rowpattern.ir.IrQuantifier;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.WindowFrame;
import io.trino.tests.QueryTemplate;
import io.trino.util.MorePredicates;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLogicalPlanner
extends BasePlanTest {
    @Test
    public void testAnalyze() {
        this.assertDistributedPlan("ANALYZE orders", PlanMatchPattern.anyTree(PlanMatchPattern.node(StatisticsWriterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of()))))))))));
    }

    @Test
    public void testLikePredicate() {
        this.assertPlan("SELECT type FROM part WHERE type LIKE 'LARGE PLATED %'", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan(tableHandle -> {
            Map domains = (Map)((TpchTableHandle)tableHandle).getConstraint().getDomains().orElseThrow(() -> new AssertionError((Object)"Unexpected none TupleDomain"));
            Domain domain = (Domain)((Optional)domains.entrySet().stream().filter(entry -> ((TpchColumnHandle)entry.getKey()).getColumnName().equals("type")).map(Map.Entry::getValue).collect(MoreCollectors.toOptional())).orElseThrow(() -> new AssertionError((Object)"No domain for 'type'"));
            Assert.assertEquals((Object)domain, (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)25), (List)((List)ImmutableList.of((Object)"LARGE PLATED BRASS", (Object)"LARGE PLATED COPPER", (Object)"LARGE PLATED NICKEL", (Object)"LARGE PLATED STEEL", (Object)"LARGE PLATED TIN").stream().map(Slices::utf8Slice).collect(ImmutableList.toImmutableList()))));
            return true;
        }, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.withColumnDomains((Map)ImmutableMap.of(tableHandle -> ((TpchColumnHandle)tableHandle).getColumnName().equals("type"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.createVarcharType((int)25), (Object)Slices.utf8Slice((String)"LARGE PLATED "), (boolean)true, (Object)Slices.utf8Slice((String)"LARGE PLATED!"), (boolean)false), (Range[])new Range[0]), (boolean)false))), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of())));
    }

    @Test
    public void testAggregation() {
        this.assertDistributedPlan("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice")))))))));
        this.assertDistributedPlan("SELECT orderstatus, sum(totalprice) FROM orders WHERE orderstatus='O' GROUP BY orderstatus", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"partial_sum"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_sum", PlanMatchPattern.functionCall("sum", (List<String>)ImmutableList.of((Object)"totalprice"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice", (Object)"totalprice")))))))));
    }

    @Test
    public void testAllFieldsDereferenceOnSubquery() {
        this.assertPlan("SELECT (SELECT (min(regionkey), max(name)) FROM nation).*", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output_1", (Object)PlanMatchPattern.expression("row[1]"), (Object)"output_2", (Object)PlanMatchPattern.expression("row[2]")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row", (Object)PlanMatchPattern.expression("ROW(min, max)")), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"min", PlanMatchPattern.functionCall("min", (List<String>)ImmutableList.of((Object)"min_regionkey")), (Object)"max", PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"max_name"))), AggregationNode.Step.FINAL, PlanMatchPattern.any(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"min_regionkey", PlanMatchPattern.functionCall("min", (List<String>)ImmutableList.of((Object)"REGIONKEY")), (Object)"max_name", PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"NAME"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name", (Object)"REGIONKEY", (Object)"regionkey")))))))));
    }

    @Test
    public void testAllFieldsDereferenceFromNonDeterministic() {
        FunctionCall randomFunction = new FunctionCall(this.getQueryRunner().getMetadata().resolveFunction(SessionTestUtils.TEST_SESSION, QualifiedName.of((String)"rand"), (List)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of());
        this.assertPlan("SELECT (x, x).* FROM (SELECT rand()) T(x)", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output_1", (Object)PlanMatchPattern.expression("row[1]"), (Object)"output_2", (Object)PlanMatchPattern.expression("row[2]")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"row", (Object)PlanMatchPattern.expression("ROW(\"rand\", \"rand\")")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rand"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)randomFunction)))))));
        this.assertPlan("SELECT (rand(), rand()).* FROM (VALUES 1) t(x)", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output_1", (Object)PlanMatchPattern.expression("r[1]"), (Object)"output_2", (Object)PlanMatchPattern.expression("r[2]")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"r"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction, (Object)randomFunction))))))));
        this.assertPlan("SELECT (rand(), rand()).* FROM (VALUES 1, 2) t(x) ORDER BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(SortNode.class, PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output_1", (Object)PlanMatchPattern.expression("row[1]"), (Object)"output_2", (Object)PlanMatchPattern.expression("row[2]")), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"row"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction, (Object)randomFunction))), (Object)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction, (Object)randomFunction))))))))));
    }

    @Test
    public void testTrivialFilterOverDuplicateSymbol() {
        this.assertPlan("WITH t AS (SELECT DISTINCT cast(null AS varchar), cast(null AS varchar)) SELECT * FROM t WHERE 1 = 0", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"expr", (Object)"expr"), PlanMatchPattern.values("expr")));
        this.assertPlan("SELECT * FROM (SELECT DISTINCT 1, 1) WHERE 1 = 0", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"expr", (Object)"expr"), PlanMatchPattern.values("expr")));
    }

    @Test
    public void testDistinctLimitOverInequalityJoin() {
        this.assertPlan("SELECT DISTINCT o.orderkey FROM orders o JOIN lineitem l ON o.orderkey < l.orderkey LIMIT 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY < L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), (List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("O_ORDERKEY", ComparisonExpression.Operator.LESS_THAN, "L_ORDERKEY")), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))).withExactOutputs((List<String>)ImmutableList.of((Object)"O_ORDERKEY", (Object)"L_ORDERKEY")))))));
        this.assertPlan("SELECT DISTINCT o.orderkey FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey LIMIT 1", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_SHIPPRIORITY", "L_LINENUMBER")), Optional.of("O_ORDERKEY < L_ORDERKEY"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey")))).withExactOutputs((List<String>)ImmutableList.of((Object)"O_ORDERKEY"))))));
    }

    @Test
    public void testDistinctOverConstants() {
        this.assertPlan("SELECT count(*), count(distinct orderstatus) FROM (SELECT * FROM orders WHERE orderstatus = 'F')", PlanMatchPattern.anyTree(PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"orderstatus"), "hash", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', coalesce(\"$operator$hash_code\"(orderstatus), 0))")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")))))));
    }

    @Test
    public void testInnerInequalityJoinNoEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.orderkey < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY < L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), (List<PlanMatchPattern.DynamicFilterPattern>)ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("O_ORDERKEY", ComparisonExpression.Operator.LESS_THAN, "L_ORDERKEY")), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testInnerInequalityJoinWithEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o JOIN lineitem l ON o.shippriority = l.linenumber AND o.orderkey < l.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("O_SHIPPRIORITY", "L_LINENUMBER")), Optional.of("O_ORDERKEY < L_ORDERKEY"), Optional.of(ImmutableList.of((Object)new PlanMatchPattern.DynamicFilterPattern("O_SHIPPRIORITY", ComparisonExpression.Operator.EQUAL, "L_LINENUMBER"), (Object)new PlanMatchPattern.DynamicFilterPattern("O_ORDERKEY", ComparisonExpression.Operator.LESS_THAN, "L_ORDERKEY"))), Optional.empty(), Optional.empty(), PlanMatchPattern.project(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_SHIPPRIORITY", (Object)"shippriority", (Object)"O_ORDERKEY", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_LINENUMBER", (Object)"linenumber", (Object)"L_ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testLeftConvertedToInnerInequalityJoinNoEquiJoinConjuncts() {
        this.assertPlan("SELECT 1 FROM orders o LEFT JOIN lineitem l ON o.orderkey < l.orderkey WHERE l.orderkey IS NOT NULL", PlanMatchPattern.anyTree(PlanMatchPattern.filter("O_ORDERKEY < L_ORDERKEY", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O_ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.any(PlanMatchPattern.filter("NOT (L_ORDERKEY IS NULL)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L_ORDERKEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testJoin() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testJoinWithOrderBySameKey() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey ORDER BY l.orderkey ASC, o.orderkey ASC", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey"))))));
    }

    @Test
    public void testTopNPushdownToJoinSource() {
        this.assertPlan("SELECT n.name, r.name FROM nation n LEFT JOIN region r ON n.regionkey = r.regionkey ORDER BY n.comment LIMIT 1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("N_COMM", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("N_KEY", "R_KEY")), PlanMatchPattern.project(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("N_COMM", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"N_NAME", (Object)"name", (Object)"N_KEY", (Object)"regionkey", (Object)"N_COMM", (Object)"comment")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"R_NAME", (Object)"name", (Object)"R_KEY", (Object)"regionkey")))))))));
    }

    @Test
    public void testUncorrelatedSubqueries() {
        this.assertPlan("SELECT * FROM orders WHERE orderkey = (SELECT orderkey FROM lineitem ORDER BY orderkey LIMIT 1)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("X", "Y")), PlanMatchPattern.project(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")))), PlanMatchPattern.project(PlanMatchPattern.node(EnforceSingleRowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
        this.assertPlan("SELECT * FROM orders WHERE orderkey IN (SELECT orderkey FROM lineitem WHERE linenumber % 4 = 0)", this.noSemiJoinRewrite(), PlanMatchPattern.anyTree(PlanMatchPattern.filter("S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
        this.assertPlan("SELECT * FROM orders WHERE orderkey NOT IN (SELECT orderkey FROM lineitem WHERE linenumber < 0)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"Y", (Object)"orderkey"))))))));
    }

    @Test
    public void testPushDownJoinConditionConjunctsToInnerSideBasedOnInheritedPredicate() {
        this.assertPlan("SELECT nationkey FROM nation LEFT OUTER JOIN region ON nation.regionkey = region.regionkey and nation.name = region.name WHERE nation.name = 'blah'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("NATION_NAME", "REGION_NAME"), PlanMatchPattern.equiJoinClause("NATION_REGIONKEY", "REGION_REGIONKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("NATION_NAME = CAST ('blah' AS varchar(25))", PlanMatchPattern.constrainedTableScan("nation", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"NATION_NAME", (Object)"name", (Object)"NATION_REGIONKEY", (Object)"regionkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("REGION_NAME = CAST ('blah' AS varchar(25))", PlanMatchPattern.constrainedTableScan("region", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"REGION_NAME", (Object)"name", (Object)"REGION_REGIONKEY", (Object)"regionkey")))))));
    }

    @Test
    public void testSameScalarSubqueryIsAppliedOnlyOnce() {
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders WHERE CAST(orderkey AS INTEGER) = (SELECT 1 FROM orders LIMIT 1) AND custkey = (SELECT 2 FROM orders LIMIT 1) AND CAST(custkey as REAL) != (SELECT 1 FROM orders LIMIT 1)"), TableScanNode.class::isInstance), (int)3);
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON   o1.orderkey = (SELECT 1 FROM orders LIMIT 1)   AND o2.orderkey = (SELECT 1 FROM orders LIMIT 1)   AND o1.orderkey + o2.orderkey > (SELECT 1 FROM orders LIMIT 1)"), TableScanNode.class::isInstance), (int)3);
    }

    @Test
    public void testSameInSubqueryIsAppliedOnlyOnce() {
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey NOT IN (SELECT 1) AND (o1.orderkey NOT IN (SELECT 1) OR o1.orderkey NOT IN (SELECT 1))"), SemiJoinNode.class::isInstance), (int)1);
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT 1 NOT IN (SELECT 1), 2 NOT IN (SELECT 1) WHERE 1 NOT IN (SELECT 1)"), SemiJoinNode.class::isInstance), (int)2);
    }

    @Test
    public void testSameQualifiedSubqueryIsAppliedOnlyOnce() {
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT * FROM orders o1 JOIN orders o2 ON o1.orderkey <= ALL(SELECT 1) AND (o1.orderkey <= ALL(SELECT 1) OR o1.orderkey <= ALL(SELECT 1))"), AggregationNode.class::isInstance), (int)1);
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT 1 <= ALL(SELECT 1), 2 <= ALL(SELECT 1) WHERE 1 <= ALL(SELECT 1)"), AggregationNode.class::isInstance), (int)2);
    }

    @Test
    public void testSameExistsAppliedOnlyOnce() {
        this.assertPlan("SELECT EXISTS (SELECT 1 FROM orders), EXISTS (SELECT 1 FROM orders)", PlanMatchPattern.anyTree(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.tableScan("orders"))));
    }

    @Test
    public void testReferenceToSameFieldAppliedOnlyOnce() {
        Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(this.plan("SELECT (SELECT 1 FROM orders WHERE orderkey = x) + (SELECT 1 FROM orders WHERE orderkey = t.x) + (SELECT 1 FROM orders WHERE orderkey = T.x) + (SELECT 1 FROM orders WHERE orderkey = t.X) + (SELECT 1 FROM orders WHERE orderkey = T.X)FROM (VALUES 1, 2) t(x)"), JoinNode.class::isInstance), (int)1);
    }

    private static int countOfMatchingNodes(Plan plan, Predicate<PlanNode> predicate) {
        return PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(predicate).count();
    }

    @Test
    public void testRemoveUnreferencedScalarInputApplyNodes() {
        this.assertPlanContainsNoApplyOrAnyJoin("SELECT (SELECT 1)");
    }

    @Test
    public void testSubqueryPruning() {
        List<QueryTemplate.Parameter> subqueries = QueryTemplate.parameter("subquery").of("orderkey IN (SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)", "EXISTS(SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)", "0 = (SELECT orderkey FROM lineitem WHERE orderkey % 2 = 0)");
        QueryTemplate.queryTemplate("SELECT COUNT(*) FROM (SELECT %subquery% FROM orders)", new QueryTemplate.Parameter[0]).replaceAll(subqueries).forEach(this::assertPlanContainsNoApplyOrAnyJoin);
        QueryTemplate.queryTemplate("SELECT * FROM orders WHERE true OR %subquery%", new QueryTemplate.Parameter[0]).replaceAll(subqueries).forEach(this::assertPlanContainsNoApplyOrAnyJoin);
    }

    @Test
    public void testJoinOutputPruning() {
        this.assertPlan("SELECT nationkey FROM nation JOIN region ON nation.regionkey = region.regionkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("REGIONKEY_LEFT", "REGIONKEY_RIGHT")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY_LEFT", (Object)"regionkey", (Object)"NATIONKEY", (Object)"nationkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY_RIGHT", (Object)"regionkey"))))).withNumberOfOutputColumns(1).withOutputs((List<String>)ImmutableList.of((Object)"NATIONKEY")));
    }

    private void assertPlanContainsNoApplyOrAnyJoin(String sql) {
        this.assertPlanDoesNotContain(sql, ApplyNode.class, JoinNode.class, IndexJoinNode.class, SemiJoinNode.class, CorrelatedJoinNode.class);
    }

    private void assertPlanDoesNotContain(String sql, Class<?> ... classes) {
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(sql, LogicalPlanner.Stage.OPTIMIZED).getRoot()).where(MorePredicates.isInstanceOfAny((Class[])classes)).matches(), (String)("Unexpected node for query: " + sql));
    }

    @Test
    public void testCorrelatedSubqueries() {
        this.assertPlan("SELECT orderkey FROM orders WHERE 3 = (SELECT orderkey)", LogicalPlanner.Stage.OPTIMIZED, PlanMatchPattern.any(PlanMatchPattern.filter("X = BIGINT '3'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey")))));
    }

    @Test
    public void testCorrelatedJoinWithLimit() {
        this.assertPlan("SELECT regionkey, n.name FROM region LEFT JOIN LATERAL (SELECT name FROM nation WHERE region.regionkey = regionkey LIMIT 2) n ON TRUE", PlanMatchPattern.any(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("region_regionkey", "nation_regionkey")), PlanMatchPattern.any(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey"))), PlanMatchPattern.any(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"nation_regionkey")).maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_name", (Object)"name", (Object)"nation_regionkey", (Object)"regionkey"))))))));
        this.assertPlan("SELECT regionkey, n.nationkey FROM region LEFT JOIN LATERAL (SELECT nationkey FROM nation WHERE region.regionkey = 3 LIMIT 2) n ON TRUE", PlanMatchPattern.any(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("region_regionkey = BIGINT '3'"), PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey")), PlanMatchPattern.limit(2L, PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_nationkey", (Object)"nationkey")))))));
    }

    @Test
    public void testCorrelatedJoinWithTopN() {
        this.assertPlan("SELECT regionkey, n.name FROM region LEFT JOIN LATERAL (SELECT name FROM nation WHERE region.regionkey = regionkey ORDER BY name LIMIT 2) n ON TRUE", PlanMatchPattern.any(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("region_regionkey", "nation_regionkey")), PlanMatchPattern.any(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey"))), PlanMatchPattern.any(PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of((Object)"nation_regionkey"), (List<String>)ImmutableList.of((Object)"nation_name"), (Map<String, SortOrder>)ImmutableMap.of((Object)"nation_name", (Object)SortOrder.ASC_NULLS_LAST)).rankingType(TopNRankingNode.RankingType.ROW_NUMBER).maxRankingPerPartition(2).partial(false), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_name", (Object)"name", (Object)"nation_regionkey", (Object)"regionkey"))))))));
        this.assertPlan("SELECT regionkey, n.name FROM region LEFT JOIN LATERAL (SELECT name FROM nation WHERE region.regionkey = regionkey ORDER BY regionkey LIMIT 2) n ON TRUE", PlanMatchPattern.any(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("region_regionkey", "nation_regionkey")), PlanMatchPattern.any(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey"))), PlanMatchPattern.any(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"nation_regionkey")).maxRowCountPerPartition(Optional.of(2)), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_name", (Object)"name", (Object)"nation_regionkey", (Object)"regionkey"))))))));
    }

    @Test
    public void testCorrelatedScalarSubqueryInSelect() {
        this.assertDistributedPlan("SELECT name, (SELECT name FROM region WHERE regionkey = nation.regionkey) FROM nation", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.filter(String.format("CASE \"is_distinct\" WHEN true THEN true ELSE CAST(fail(%s, 'Scalar sub-query has returned multiple rows') AS boolean) END", StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.toErrorCode().getCode()), PlanMatchPattern.project(PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"unique"), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("n_regionkey", "r_regionkey")), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_regionkey", (Object)"regionkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_regionkey", (Object)"regionkey")))))))));
        this.assertDistributedPlan("SELECT name, (SELECT name FROM region WHERE regionkey = nation.regionkey) FROM nation", this.automaticJoinDistribution(), PlanMatchPattern.anyTree(PlanMatchPattern.filter(String.format("CASE \"is_distinct\" WHEN true THEN true ELSE CAST(fail(%s, 'Scalar sub-query has returned multiple rows') AS boolean) END", StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.toErrorCode().getCode()), PlanMatchPattern.project(PlanMatchPattern.markDistinct("is_distinct", (List<String>)ImmutableList.of((Object)"unique"), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("n_regionkey", "r_regionkey")), PlanMatchPattern.project(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_regionkey", (Object)"regionkey", (Object)"n_name", (Object)"name")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_regionkey", (Object)"regionkey")))))))));
    }

    @Test
    public void testStreamingAggregationForCorrelatedSubquery() {
        this.assertDistributedPlan("SELECT name, (SELECT max(name) FROM region WHERE regionkey = nation.regionkey AND length(name) > length(nation.name)) FROM nation", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("n_name", "n_regionkey", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"r_name"))), (List<String>)ImmutableList.of((Object)"n_name", (Object)"n_regionkey", (Object)"unique"), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_name", (Object)"name", (Object)"n_regionkey", (Object)"regionkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_name", (Object)"name"))))))));
        this.assertDistributedPlan("SELECT name, (SELECT max(name) FROM region WHERE regionkey > nation.regionkey) FROM nation", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("n_name", "n_regionkey", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("max"), PlanMatchPattern.functionCall("max", (List<String>)ImmutableList.of((Object)"r_name"))), (List<String>)ImmutableList.of((Object)"n_name", (Object)"n_regionkey", (Object)"unique"), (List<String>)ImmutableList.of((Object)"non_null"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"n_name", (Object)"name", (Object)"n_regionkey", (Object)"regionkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non_null", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"r_name", (Object)"name"))))))));
    }

    @Test
    public void testStreamingAggregationOverJoin() {
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o, lineitem l WHERE o.orderkey=l.orderkey GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"o_orderkey"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("o_orderkey", "l_orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey")))))));
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o LEFT JOIN lineitem l ON o.orderkey=l.orderkey GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("o_orderkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"o_orderkey"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("o_orderkey", "l_orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"o_orderkey", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"l_orderkey", (Object)"orderkey")))))));
        this.assertPlan("SELECT o.orderkey, count(*) FROM orders o, lineitem l GROUP BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("orderkey"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.empty(), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
    }

    @Test
    public void testCorrelatedInUncorrelatedFiltersPushDown() {
        this.assertPlan("SELECT orderkey, comment IN (SELECT clerk FROM orders s WHERE s.orderkey = o.orderkey AND s.orderkey < 7) FROM lineitem o", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")), PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderkey < BIGINT '7'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))))));
    }

    @Test
    public void testSymbolsPrunedInCorrelatedInPredicateSource() {
        this.assertPlan("SELECT orderkey, comment IN (SELECT clerk FROM orders s WHERE s.orderkey = o.orderkey AND s.orderkey < 7) FROM lineitem o", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.strictTableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"comment", (Object)"comment"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void testDoubleNestedCorrelatedSubqueries() {
        this.assertPlan("SELECT orderkey FROM orders o WHERE 3 IN (SELECT o.custkey FROM lineitem l WHERE (SELECT l.orderkey = o.orderkey))", LogicalPlanner.Stage.OPTIMIZED, PlanMatchPattern.anyTree(PlanMatchPattern.filter("OUTER_FILTER", PlanMatchPattern.project(PlanMatchPattern.apply((List<String>)ImmutableList.of((Object)"O", (Object)"C"), (Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"OUTER_FILTER", (Object)PlanMatchPattern.expression("THREE IN (C)")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"THREE", (Object)PlanMatchPattern.expression("BIGINT '3'")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"O", (Object)"orderkey", (Object)"C", (Object)"custkey"))), PlanMatchPattern.project(PlanMatchPattern.any(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"L", (Object)"orderkey")))))))), MorePredicates.isInstanceOfAny((Class[])new Class[]{AddLocalExchanges.class, CheckSubqueryNodesAreRewritten.class}).negate());
    }

    @Test
    public void testCorrelatedScalarAggregationRewriteToLeftOuterJoin() {
        this.assertPlan("SELECT orderkey FROM orders WHERE EXISTS(SELECT 1 WHERE orderkey = 3)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("FINAL_COUNT > BIGINT '0'", PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("ORDERKEY", "UNIQUE"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("FINAL_COUNT"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"UNIQUE"), (List<String>)ImmutableList.of((Object)"NON_NULL"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("BIGINT '3' = ORDERKEY"), PlanMatchPattern.assignUniqueId("UNIQUE", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"NON_NULL", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0]))))))));
    }

    @Test
    public void testRemovesTrivialFilters() {
        this.assertPlan("SELECT * FROM nation WHERE 1 = 1", PlanMatchPattern.output(PlanMatchPattern.tableScan("nation")));
        this.assertPlan("SELECT * FROM nation WHERE 1 = 0", PlanMatchPattern.output(PlanMatchPattern.values("nationkey", "name", "regionkey", "comment")));
    }

    @Test
    public void testPruneCountAggregationOverScalar() {
        this.assertPlan("SELECT count(*) FROM (SELECT sum(orderkey) FROM orders)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"_col0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1"))))));
        this.assertPlan("SELECT count(s) FROM (SELECT sum(orderkey) AS s FROM orders)", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")));
        this.assertPlan("SELECT count(*) FROM (SELECT sum(orderkey) FROM orders GROUP BY custkey)", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")));
    }

    @Test
    public void testInlineCountOverConstantExpression() {
        this.assertPlan("SELECT regionkey, count(1) FROM nation GROUP BY regionkey", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count_0", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey")))));
    }

    @Test
    public void testPickTableLayoutWithFilter() {
        this.assertPlan("SELECT orderkey FROM orders WHERE orderkey=5", PlanMatchPattern.output(PlanMatchPattern.filter("orderkey = BIGINT '5'", PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
        this.assertPlan("SELECT orderkey FROM orders WHERE orderstatus='F'", PlanMatchPattern.output(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))));
    }

    @Test
    public void testBroadcastCorrelatedSubqueryAvoidsRemoteExchangeBeforeAggregation() {
        Session broadcastJoin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("force_single_node_output", Boolean.toString(false)).build();
        PlanMatchPattern joinBuildSideWithRemoteExchange = PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
        Consumer<Plan> validateSingleRemoteExchange = plan -> Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE), (int)1);
        Consumer<Plan> validateSingleStreamingAggregation = plan -> Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof AggregationNode && ((AggregationNode)node).getGroupingKeys().contains(new Symbol("unique")) && ((AggregationNode)node).isStreamable()), (int)1);
        this.assertPlanWithSession("SELECT (SELECT count(*) FROM region r2 WHERE r2.regionkey > r1.regionkey) FROM region r1", broadcastJoin, false, joinBuildSideWithRemoteExchange, validateSingleRemoteExchange.andThen(validateSingleStreamingAggregation));
        this.assertPlanWithSession("SELECT count(count) FROM (SELECT o1.orderkey orderkey, (SELECT count(*) FROM orders o2 WHERE o2.orderkey > o1.orderkey) count FROM orders o1) GROUP BY orderkey", broadcastJoin, false, joinBuildSideWithRemoteExchange, validateSingleRemoteExchange.andThen(validateSingleStreamingAggregation));
    }

    @Test
    public void testUsesDistributedJoinIfNaturallyPartitionedOnProbeSymbols() {
        Session broadcastJoin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("force_single_node_output", Boolean.toString(false)).setSystemProperty("optimize_hash_generation", Boolean.toString(false)).build();
        this.assertPlanWithSession("SELECT r1.regionkey FROM (SELECT regionkey FROM region GROUP BY regionkey) r1, region r2 WHERE r2.regionkey = r1.regionkey", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LEFT_REGIONKEY", "RIGHT_REGIONKEY")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"LEFT_REGIONKEY", (Object)"regionkey")))))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"RIGHT_REGIONKEY", (Object)"regionkey")))))), plan -> Assert.assertEquals((int)TestLogicalPlanner.countOfMatchingNodes(plan, node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE), (int)2));
        this.assertPlanWithSession("SELECT * FROM (VALUES 1, 2, 3) t(a), region r WHERE r.regionkey = t.a", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
        this.assertPlanWithSession("SELECT * FROM (SELECT regionkey FROM region GROUP BY regionkey) r1, region r2 WHERE r2.regionkey > r1.regionkey", broadcastJoin, false, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
    }

    @Test
    public void testDistributedSort() {
        ImmutableList orderBy = ImmutableList.of((Object)PlanMatchPattern.sort("ORDERKEY", SortItem.Ordering.DESCENDING, SortItem.NullOrdering.LAST));
        this.assertDistributedPlan("SELECT orderkey FROM orders ORDER BY orderkey DESC", PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))))));
        this.assertDistributedPlan("SELECT orderkey FROM orders ORDER BY orderkey DESC", Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("distributed_sort", Boolean.toString(false)).build(), PlanMatchPattern.output(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)orderBy, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.GATHER, PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))))));
    }

    @Test
    public void testRemoveAggregationInSemiJoin() {
        this.assertPlanDoesNotContain("SELECT custkey FROM orders WHERE custkey NOT IN (SELECT distinct custkey FROM customer)", AggregationNode.class);
    }

    @Test
    public void testFilteringSemiJoinRewriteToInnerJoin() {
        this.assertPlan("SELECT custkey FROM orders WHERE custkey IN (SELECT custkey FROM customer)", PlanMatchPattern.any(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("CUSTOMER_CUSTKEY", "ORDER_CUSTKEY")), PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("CUSTOMER_CUSTKEY"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"CUSTOMER_CUSTKEY", (Object)"custkey"))))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDER_CUSTKEY", (Object)"custkey"))))));
    }

    @Test
    public void testCorrelatedIn() {
        this.assertPlan("SELECT name FROM region r WHERE regionkey IN (SELECT regionkey FROM nation WHERE name < r.name)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("count_matches > BIGINT '0'", PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("region_regionkey", "region_name", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("count_matches"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"region_regionkey", (Object)"region_name", (Object)"unique"), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression("((NOT (region_regionkey IS NULL)) AND (NOT (nation_regionkey IS NULL)))")), PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("(region_regionkey IS NULL OR region_regionkey = nation_regionkey OR nation_regionkey IS NULL) AND nation_name < region_name"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey", (Object)"region_name", (Object)"name"))), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_name", (Object)"name", (Object)"nation_regionkey", (Object)"regionkey"))))))))));
    }

    @Test
    public void testCorrelatedExists() {
        this.assertPlan("SELECT regionkey, name FROM region r WHERE EXISTS(SELECT regionkey FROM nation WHERE name < r.name)", PlanMatchPattern.anyTree(PlanMatchPattern.filter("count_matches > BIGINT '0'", PlanMatchPattern.project(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("region_regionkey", "region_name", "unique"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("count_matches"), PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), (List<String>)ImmutableList.of((Object)"region_regionkey", (Object)"region_name", (Object)"unique"), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("nation_name < region_name"), PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"region_regionkey", (Object)"regionkey", (Object)"region_name", (Object)"name"))), PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"mask", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nation_name", (Object)"name"))))))))));
    }

    @Test
    public void testOrderByFetch() {
        this.assertPlan("SELECT * FROM nation ORDER BY name FETCH FIRST 2 ROWS ONLY", PlanMatchPattern.anyTree(PlanMatchPattern.topN(2L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("NAME", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.PARTIAL, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)"name")))));
    }

    @Test
    public void testFetch() {
        this.assertPlan("SELECT * FROM nation FETCH FIRST 2 ROWS ONLY", PlanMatchPattern.anyTree(PlanMatchPattern.limit(2L, PlanMatchPattern.any(PlanMatchPattern.tableScan("nation")))));
    }

    @Test
    public void testOffset() {
        this.assertPlan("SELECT name FROM nation OFFSET 2 ROWS", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)new ExpressionMatcher("name")), PlanMatchPattern.filter("row_num > BIGINT '2'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name")))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
        this.assertPlan("SELECT name FROM nation ORDER BY regionkey OFFSET 2 ROWS", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)new ExpressionMatcher("name")), PlanMatchPattern.filter("row_num > BIGINT '2'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.anyTree(PlanMatchPattern.sort((List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("regionkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
        this.assertPlan("SELECT name FROM nation ORDER BY regionkey OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)new ExpressionMatcher("name")), PlanMatchPattern.filter("row_num > BIGINT '2'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.any(PlanMatchPattern.topN(7L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("regionkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
        this.assertPlan("SELECT name FROM nation OFFSET 2 ROWS FETCH NEXT 5 ROWS ONLY", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)new ExpressionMatcher("name")), PlanMatchPattern.filter("row_num > BIGINT '2'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.limit(7L, PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name"))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
    }

    @Test
    public void testWithTies() {
        this.assertPlan("SELECT name, regionkey FROM nation ORDER BY regionkey FETCH FIRST 6 ROWS WITH TIES", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)new ExpressionMatcher("name"), (Object)"regionkey", (Object)new ExpressionMatcher("regionkey")), PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"regionkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"regionkey", (Object)SortOrder.ASC_NULLS_LAST)).rankingType(TopNRankingNode.RankingType.RANK).maxRankingPerPartition(6).partial(false), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))));
        this.assertPlan("SELECT name, regionkey FROM nation ORDER BY regionkey OFFSET 10 ROWS FETCH FIRST 6 ROWS WITH TIES", PlanMatchPattern.any(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)new ExpressionMatcher("name"), (Object)"regionkey", (Object)new ExpressionMatcher("regionkey")), PlanMatchPattern.filter("row_num > BIGINT '10'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)new ExpressionMatcher("name"), (Object)"regionkey", (Object)new ExpressionMatcher("regionkey")), PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"regionkey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"regionkey", (Object)SortOrder.ASC_NULLS_LAST)).rankingType(TopNRankingNode.RankingType.RANK).maxRankingPerPartition(16).partial(false), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
    }

    @Test
    public void testRedundantLimitNodeRemoval() {
        String query = "SELECT count(*) FROM orders LIMIT 10";
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, LogicalPlanner.Stage.OPTIMIZED).getRoot()).where(LimitNode.class::isInstance).matches(), (String)String.format("Unexpected limit node for query: '%s'", query));
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
        this.assertPlan("SELECT * FROM (VALUES 1,2,3,4,5,6) AS t1 LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x"))));
    }

    @Test
    public void testRemoveSingleRowSort() {
        String query = "SELECT count(*) FROM orders ORDER BY 1";
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, LogicalPlanner.Stage.OPTIMIZED).getRoot()).where(MorePredicates.isInstanceOfAny((Class[])new Class[]{SortNode.class})).matches(), (String)String.format("Unexpected sort node for query: '%s'", query));
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1", PlanMatchPattern.anyTree(PlanMatchPattern.node(SortNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
    }

    @Test
    public void testRedundantTopNNodeRemoval() {
        String query = "SELECT count(*) FROM orders ORDER BY 1 LIMIT 10";
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, LogicalPlanner.Stage.OPTIMIZED).getRoot()).where(MorePredicates.isInstanceOfAny((Class[])new Class[]{TopNNode.class, SortNode.class})).matches(), (String)String.format("Unexpected TopN node for query: '%s'", query));
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1 LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.node(TopNNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
        this.assertPlan("SELECT orderkey, count(*) FROM orders GROUP BY orderkey ORDER BY 1 LIMIT 0", PlanMatchPattern.output(PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])));
        this.assertPlan("SELECT * FROM (VALUES 1,2,3,4,5,6) AS t1 ORDER BY 1 LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.node(SortNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x")))))));
    }

    @Test
    public void testRedundantDistinctLimitNodeRemoval() {
        String query = "SELECT distinct(c) FROM (SELECT count(*) as c FROM orders) LIMIT 10";
        Assert.assertFalse((boolean)PlanNodeSearcher.searchFrom((PlanNode)this.plan(query, LogicalPlanner.Stage.OPTIMIZED).getRoot()).where(MorePredicates.isInstanceOfAny((Class[])new Class[]{DistinctLimitNode.class})).matches(), (String)String.format("Unexpected DistinctLimit node for query: '%s'", query));
        this.assertPlan("SELECT distinct(c) FROM (SELECT count(*) as c FROM orders GROUP BY orderkey) LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.node(DistinctLimitNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")))));
        this.assertPlan("SELECT distinct(id) FROM (VALUES 1, 2, 3, 4, 5, 6) as t1 (id) LIMIT 10", PlanMatchPattern.output(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"x")))))));
    }

    @Test
    public void testRedundantHashRemovalForUnionAll() {
        this.assertPlan("SELECT count(*) FROM ((SELECT nationkey FROM customer) UNION ALL (SELECT nationkey FROM customer)) GROUP BY nationkey", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', coalesce(\"$operator$hash_code\"(nationkey), 0))")), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash_1", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', coalesce(\"$operator$hash_code\"(nationkey_6), 0))")), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"nationkey_6", (Object)"nationkey")))))))));
    }

    @Test
    public void testRedundantHashRemovalForMarkDistinct() {
        this.assertDistributedPlan("select count(*), count(distinct orderkey), count(distinct partkey), count(distinct suppkey) from lineitem", Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("task_concurrency", "16").build(), PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.identityProject(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash_1", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', coalesce(\"$operator$hash_code\"(suppkey), 0))"), (Object)"hash_2", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', coalesce(\"$operator$hash_code\"(partkey), 0))")), PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"suppkey", (Object)"suppkey", (Object)"partkey", (Object)"partkey"))))))))));
    }

    @Test
    public void testRedundantHashRemovalForUnionAllAndMarkDistinct() {
        this.assertDistributedPlan("SELECT count(distinct(custkey)), count(distinct(nationkey)) FROM ((SELECT custkey, nationkey FROM customer) UNION ALL ( SELECT custkey, custkey FROM customer))", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"hash_custkey", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', COALESCE(\"$operator$hash_code\"(custkey), 0))"), (Object)"hash_nationkey", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', COALESCE(\"$operator$hash_code\"(nationkey), 0))")), PlanMatchPattern.tableScan("customer", (Map<String, String>)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))))))));
    }

    @Test
    public void testRemoveRedundantFilter() {
        this.assertPlan("SELECT orderkey, t2.s FROM orders JOIN (VALUES CAST('' || 'O' AS varchar(1)), CAST('' || 'F' AS varchar(1))) t2(s) ON orders.orderstatus = t2.s", PlanMatchPattern.any(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr", "ORDER_STATUS")), PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("O")), (Object)ImmutableList.of((Object)new StringLiteral("F"))))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.strictConstrainedTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDER_STATUS", (Object)"orderstatus", (Object)"ORDER_KEY", (Object)"orderkey"), (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)1), (List)ImmutableList.of((Object)Slices.utf8Slice((String)"F"), (Object)Slices.utf8Slice((String)"O"))))))))));
    }

    @Test
    public void testRemoveRedundantCrossJoin() {
        this.assertPlan("SELECT regionkey FROM nation, (SELECT 1 as a) temp WHERE regionkey = temp.a", PlanMatchPattern.output(PlanMatchPattern.filter("REGIONKEY = BIGINT '1'", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY", (Object)"regionkey")))));
        this.assertPlan("SELECT regionkey FROM (SELECT 1 as a) temp, nation WHERE regionkey > temp.a", PlanMatchPattern.output(PlanMatchPattern.filter("REGIONKEY > BIGINT '1'", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY", (Object)"regionkey")))));
        this.assertPlan("SELECT * FROM nation, (SELECT 1 as a) temp WHERE regionkey = a", PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("1")), PlanMatchPattern.filter("REGIONKEY = BIGINT '1'", PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"REGIONKEY", (Object)"regionkey"))))));
    }

    @Test
    public void testRemoveRedundantInnerJoin() {
        this.assertPlan("SELECT regionkey FROM nation INNER JOIN (SELECT nationkey FROM customer LIMIT 0) USING (nationkey)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"regionkey"))));
        this.assertPlan("SELECT regionkey FROM (SELECT * FROM nation LIMIT 0) INNER JOIN customer USING (nationkey)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"regionkey"))));
    }

    @Test
    public void testRemoveRedundantLeftJoin() {
        this.assertPlan("SELECT regionkey FROM (SELECT * FROM nation LIMIT 0) LEFT JOIN customer USING (nationkey)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"regionkey"))));
    }

    @Test
    public void testRemoveRedundantRightJoin() {
        this.assertPlan("SELECT regionkey FROM nation RIGHT JOIN (SELECT nationkey FROM customer LIMIT 0) USING (nationkey)", PlanMatchPattern.output(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"regionkey"))));
    }

    @Test
    public void testMergeProjectWithValues() {
        this.assertPlan("SELECT * FROM nation, (SELECT a * 2 FROM (VALUES 1, 2, 3) t(a))", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("2")), (Object)ImmutableList.of((Object)new LongLiteral("4")), (Object)ImmutableList.of((Object)new LongLiteral("6")))))));
        this.assertPlan("SELECT orderkey, t2.s FROM orders JOIN (SELECT '' || x FROM (VALUES 'F') t(x)) t2(s) ON orders.orderstatus = t2.s", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast", (Object)PlanMatchPattern.expression("CAST(ORDER_STATUS AS varchar)")), PlanMatchPattern.strictConstrainedTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDER_STATUS", (Object)"orderstatus", (Object)"ORDER_KEY", (Object)"orderkey"), (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F")))))));
        this.assertPlan("SELECT orderkey, t2.s FROM orders JOIN (SELECT CAST('' || x AS varchar(1)) FROM (VALUES 'O', 'F') t(x)) t2(s) ON orders.orderstatus = t2.s", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr", "ORDER_STATUS")), PlanMatchPattern.project(PlanMatchPattern.filter("expr IN ('F', 'O')", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new StringLiteral("O")), (Object)ImmutableList.of((Object)new StringLiteral("F")))))), PlanMatchPattern.exchange(PlanMatchPattern.project(PlanMatchPattern.strictConstrainedTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDER_STATUS", (Object)"orderstatus", (Object)"ORDER_KEY", (Object)"orderkey"), (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.multipleValues((Type)VarcharType.createVarcharType((int)1), (List)ImmutableList.of((Object)Slices.utf8Slice((String)"F"), (Object)Slices.utf8Slice((String)"O"))))))))));
        this.assertPlan("SELECT orderstatus, t2.s FROM orders JOIN (SELECT x * 1 FROM (VALUES BIGINT '1', BIGINT '2') t(x)) t2(s) ON orders.orderkey = t2.s", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("expr", "ORDER_KEY")), PlanMatchPattern.project(PlanMatchPattern.filter("expr IN (BIGINT '1', BIGINT '2')", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1")), (Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "2")))))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDER_KEY IN (BIGINT '1', BIGINT '2')", PlanMatchPattern.strictConstrainedTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDER_STATUS", (Object)"orderstatus", (Object)"ORDER_KEY", (Object)"orderkey"), (Map<String, Domain>)ImmutableMap.of()))))));
    }

    @Test
    public void testReplaceJoinWithProject() {
        this.assertPlan("SELECT * FROM nation, (SELECT a * 2 FROM (VALUES 1) t(a))", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("2")), PlanMatchPattern.tableScan("nation"))));
        this.assertPlan("SELECT * FROM nation, (SELECT b * 3 FROM (SELECT a * 2 FROM (VALUES 1) t1(a)) t2(b))", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("6")), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testGroupingSetsWithDefaultValue() {
        this.assertDistributedPlan("SELECT orderkey, COUNT(DISTINCT k) FROM (SELECT orderkey, 1 k FROM orders) GROUP BY GROUPING SETS ((), orderkey)", PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"final_count", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"partial_count"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"partial_count", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"CONSTANT"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"CONSTANT", (Object)PlanMatchPattern.expression("1")), PlanMatchPattern.tableScan("orders"))))))))));
    }

    @Test
    public void testSizeBasedJoin() {
        this.assertDistributedPlan("SELECT custkey FROM local.\"sf42.5\".nation, local.\"sf42.5\".orders WHERE nation.nationkey = orders.custkey", this.automaticJoinDistribution(), PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("NATIONKEY", "CUSTKEY")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NATIONKEY", (Object)"nationkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey")))))));
        this.assertDistributedPlan("SELECT custkey FROM (VALUES CAST(1 AS BIGINT), CAST(2 AS BIGINT)) t(a), local.\"sf42.5\".orders WHERE t.a = orders.custkey", this.automaticJoinDistribution(), PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("CUSTKEY", "T_A")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.values("T_A"))))));
    }

    @Test
    public void testSizeBasedSemiJoin() {
        this.assertDistributedPlan("SELECT custkey FROM local.\"sf42.5\".orders WHERE orders.custkey NOT IN (SELECT nationkey FROM local.\"sf42.5\".nation)", this.automaticJoinDistribution(), PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("CUSTKEY", "NATIONKEY", "OUT", Optional.of(SemiJoinNode.DistributionType.PARTITIONED), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NATIONKEY", (Object)"nationkey")))))));
        this.assertDistributedPlan("SELECT custkey FROM local.\"sf42.5\".orders WHERE orders.custkey NOT IN (SELECT t.a FROM (VALUES CAST(1 AS BIGINT), CAST(2 AS BIGINT)) t(a))", this.automaticJoinDistribution(), PlanMatchPattern.output(PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("CUSTKEY", "T_A", "OUT", Optional.of(SemiJoinNode.DistributionType.REPLICATED), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUSTKEY", (Object)"custkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.values("T_A"))))));
    }

    @Test
    public void testExplainAnalyze() {
        this.assertPlan("EXPLAIN ANALYZE SELECT regionkey FROM nation", PlanMatchPattern.output(PlanMatchPattern.node(ExplainAnalyzeNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.strictTableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))));
    }

    @Test
    public void testValuesCoercions() {
        this.assertPlan("VALUES TINYINT '1', REAL '1'", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"field"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Cast((Expression)new GenericLiteral("TINYINT", "1"), TypeSignatureTranslator.toSqlType((Type)RealType.REAL))), (Object)ImmutableList.of((Object)new GenericLiteral("REAL", "1"))))));
        this.assertPlan("VALUES (TINYINT '1', REAL '1'), (DOUBLE '2', SMALLINT '2')", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"field", (Object)"field0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Cast((Expression)new GenericLiteral("TINYINT", "1"), TypeSignatureTranslator.toSqlType((Type)DoubleType.DOUBLE)), (Object)new GenericLiteral("REAL", "1")), (Object)ImmutableList.of((Object)new GenericLiteral("DOUBLE", "2"), (Object)new Cast((Expression)new GenericLiteral("SMALLINT", "2"), TypeSignatureTranslator.toSqlType((Type)RealType.REAL)))))));
        this.assertPlan("VALUES DOUBLE '1', CAST(ROW(2) AS row(bigint))", LogicalPlanner.Stage.CREATED, PlanMatchPattern.anyTree(PlanMatchPattern.values(PlanMatchPattern.aliasToIndex((List<String>)ImmutableList.of((Object)"field")), Optional.of(1), Optional.of(ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new GenericLiteral("DOUBLE", "1"))), (Object)new Cast((Expression)new Cast((Expression)new Row((List)ImmutableList.of((Object)new LongLiteral("2"))), TypeSignatureTranslator.toSqlType((Type)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT)))), TypeSignatureTranslator.toSqlType((Type)RowType.anonymous((List)ImmutableList.of((Object)DoubleType.DOUBLE)))))))));
    }

    @Test
    public void testDoNotPlanUnreferencedRowPatternMeasures() {
        this.assertPlan("SELECT val OVER w           FROM (VALUES (1, 90)) t(id, value)           WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("val", "LAST(value)", (Type)IntegerType.INTEGER).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(PlanMatchPattern.windowFrame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), "true"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"value"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("90"))))))));
        this.assertPlan("SELECT min(value) OVER w           FROM (VALUES (1, 90)) t(id, value)           WINDOW w AS (                    ORDER BY id                    MEASURES CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("min", PlanMatchPattern.functionCall("min", (List<String>)ImmutableList.of((Object)"value"))).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(PlanMatchPattern.windowFrame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), "true"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"value"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("90"))))))));
    }

    @Test
    public void testPruneUnreferencedRowPatternWindowFunctions() {
        this.assertPlan("SELECT id, min FROM        (SELECT id, min(value) OVER w min, row_number() OVER w           FROM (VALUES (1, 90)) t(id, value)           WINDOW w AS (                    ORDER BY id                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )       )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addFunction("min", PlanMatchPattern.functionCall("min", (List<String>)ImmutableList.of((Object)"value"))).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(PlanMatchPattern.windowFrame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), "true"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"value"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("90"))))))));
    }

    @Test
    public void testPruneUnreferencedRowPatternMeasures() {
        this.assertPlan("SELECT id, val FROM        (SELECT id, val OVER w val, label OVER w           FROM (VALUES (1, 90)) t(id, value)           WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )       )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("val", "LAST(value)", (Type)IntegerType.INTEGER).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(PlanMatchPattern.windowFrame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), "true"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"value"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("90"))))))));
    }

    @Test
    public void testMergePatternRecognitionNodes() {
        this.assertPlan("SELECT id, val OVER w, label OVER w, row_number() OVER w           FROM (VALUES (1, 90)) t(id, value)           WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(value) AS val,                             CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )", PlanMatchPattern.output(PlanMatchPattern.project(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("val", "LAST(value)", (Type)IntegerType.INTEGER).addMeasure("label", "CLASSIFIER()", (Type)VarcharType.VARCHAR).addFunction("row_number", PlanMatchPattern.functionCall("row_number", (List<String>)ImmutableList.of())).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(PlanMatchPattern.windowFrame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), "true"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"value"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("90"))))))));
    }

    @Test
    public void testMergePatternRecognitionNodesWithProjections() {
        this.assertPlan("SELECT id, 2 * value OVER w, lower(label OVER w), 1 + min(input1) OVER w           FROM (VALUES (1, 2, 3)) t(id, input1, input2)           WINDOW w AS (                    ORDER BY id                    MEASURES                             RUNNING LAST(input2) AS value,                             CLASSIFIER() AS label                    ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING                    PATTERN (A+)                    DEFINE A AS true           )", PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output1", (Object)PlanMatchPattern.expression("id"), (Object)"output2", (Object)PlanMatchPattern.expression("value * 2"), (Object)"output3", (Object)PlanMatchPattern.expression("lower(label)"), (Object)"output4", (Object)PlanMatchPattern.expression("min + 1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"id", (Object)PlanMatchPattern.expression("id"), (Object)"value", (Object)PlanMatchPattern.expression("value"), (Object)"label", (Object)PlanMatchPattern.expression("label"), (Object)"min", (Object)PlanMatchPattern.expression("min")), PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"id"), (Map<String, SortOrder>)ImmutableMap.of((Object)"id", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("value", "LAST(input2)", (Type)IntegerType.INTEGER).addMeasure("label", "CLASSIFIER()", (Type)VarcharType.VARCHAR).addFunction("min", PlanMatchPattern.functionCall("min", (List<String>)ImmutableList.of((Object)"input1"))).rowsPerMatch(PatternRecognitionRelation.RowsPerMatch.WINDOW).frame(PlanMatchPattern.windowFrame(WindowFrame.Type.ROWS, FrameBound.Type.CURRENT_ROW, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrQuantified((IrRowPattern)new IrLabel("A"), IrQuantifier.oneOrMore((boolean)true))).addVariableDefinition(new IrLabel("A"), "true"), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"id", (Object)"input1", (Object)"input2"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2"), (Object)new LongLiteral("3")))))))));
    }

    private Session noJoinReordering() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build();
    }

    private Session automaticJoinDistribution() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).build();
    }

    private Session noSemiJoinRewrite() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("rewrite_filtering_semi_join_to_inner_join", "false").build();
    }
}

