/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestPlanMatchingFramework
extends BasePlanTest {
    @Test
    public void testOutput() {
        this.assertMinimallyOptimizedPlan("SELECT orderkey FROM lineitem", PlanMatchPattern.node(OutputNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).withAlias("ORDERKEY", PlanMatchPattern.columnReference("lineitem", "orderkey"))).withOutputs((List<String>)ImmutableList.of((Object)"ORDERKEY")));
    }

    @Test
    public void testOutputSameColumnMultipleTimes() {
        this.assertMinimallyOptimizedPlan("SELECT orderkey, orderkey FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"ORDERKEY"), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))));
    }

    @Test
    public void testOutputSameColumnMultipleTimesWithOtherOutputs() {
        this.assertMinimallyOptimizedPlan("SELECT extendedprice, orderkey, discount, orderkey, linenumber FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"ORDERKEY"), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))));
    }

    @Test
    public void testStrictOutput() {
        this.assertMinimallyOptimizedPlan("SELECT orderkey, extendedprice FROM lineitem", PlanMatchPattern.strictOutput((List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"EXTENDEDPRICE"), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey", (Object)"EXTENDEDPRICE", (Object)"extendedprice"))));
    }

    @Test
    public void testStrictTableScan() {
        this.assertMinimallyOptimizedPlan("SELECT orderkey, extendedprice FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"EXTENDEDPRICE"), PlanMatchPattern.strictTableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey", (Object)"EXTENDEDPRICE", (Object)"extendedprice"))));
    }

    @Test
    public void testUnreferencedSymbolsDontNeedBinding() {
        this.assertMinimallyOptimizedPlan("SELECT orderkey, 2 FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY"), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))));
    }

    @Test
    public void testAliasConstantFromProject() {
        this.assertMinimallyOptimizedPlan("SELECT orderkey, 2 FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"TWO"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"TWO", (Object)PlanMatchPattern.expression("2")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))));
    }

    @Test
    public void testAliasExpressionFromProject() {
        this.assertMinimallyOptimizedPlan("SELECT orderkey, 1 + orderkey FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"EXPRESSION"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"EXPRESSION", (Object)PlanMatchPattern.expression("CAST(1 AS bigint) + ORDERKEY")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))));
    }

    @Test
    public void testStrictProject() {
        this.assertMinimallyOptimizedPlan("SELECT orderkey, 1 + orderkey FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"EXPRESSION"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"EXPRESSION", (Object)PlanMatchPattern.expression("CAST(1 AS BIGINT) + ORDERKEY"), (Object)"ORDERKEY", (Object)PlanMatchPattern.expression("ORDERKEY")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))));
    }

    @Test
    public void testIdentityAliasFromProject() {
        this.assertMinimallyOptimizedPlan("SELECT orderkey, 1 + orderkey FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"EXPRESSION"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ORDERKEY", (Object)PlanMatchPattern.expression("ORDERKEY"), (Object)"EXPRESSION", (Object)PlanMatchPattern.expression("CAST(1 AS bigint) + ORDERKEY")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))));
    }

    @Test
    public void testTableScan() {
        this.assertMinimallyOptimizedPlan("SELECT orderkey FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY"), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))));
    }

    @Test
    public void testJoinMatcher() {
        this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders").withAlias("ORDERS_OK", PlanMatchPattern.columnReference("orders", "orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem").withAlias("LINEITEM_OK", PlanMatchPattern.columnReference("lineitem", "orderkey"))))));
    }

    @Test
    public void testSelfJoin() {
        this.assertPlan("SELECT l.orderkey FROM orders l, orders r WHERE l.orderkey = r.orderkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("L_ORDERS_OK", "R_ORDERS_OK")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders").withAlias("L_ORDERS_OK", PlanMatchPattern.columnReference("orders", "orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders").withAlias("R_ORDERS_OK", PlanMatchPattern.columnReference("orders", "orderkey"))))));
    }

    @Test
    public void testAggregation() {
        this.assertMinimallyOptimizedPlan("SELECT COUNT(nationkey) FROM nation", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"COUNT"), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"COUNT", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"NATIONKEY"))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"NATIONKEY", (Object)"nationkey")))));
    }

    @Test
    public void testValues() {
        this.assertMinimallyOptimizedPlan("SELECT * from (VALUES 1, 2)", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"VALUE"), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"VALUE", (Object)0))));
    }

    @Test
    public void testAliasNonexistentColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertMinimallyOptimizedPlan("SELECT orderkey FROM lineitem", PlanMatchPattern.node(OutputNode.class, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).withAlias("ORDERKEY", PlanMatchPattern.columnReference("lineitem", "NXCOLUMN"))))).isInstanceOf(IllegalStateException.class)).hasMessageMatching(".* doesn't have column .*");
    }

    @Test
    public void testReferenceNonexistentAlias() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertMinimallyOptimizedPlan("SELECT orderkey FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"NXALIAS"), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))).isInstanceOf(IllegalStateException.class)).hasMessageMatching("missing expression for alias .*");
    }

    @Test
    public void testStrictOutputExtraSymbols() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertMinimallyOptimizedPlan("SELECT orderkey, extendedprice FROM lineitem", PlanMatchPattern.strictOutput((List<String>)ImmutableList.of((Object)"ORDERKEY"), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey", (Object)"EXTENDEDPRICE", (Object)"extendedprice"))))).isInstanceOf(AssertionError.class)).hasMessageStartingWith("Plan does not match");
    }

    @Test
    public void testStrictTableScanExtraSymbols() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertMinimallyOptimizedPlan("SELECT orderkey, extendedprice FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"EXTENDEDPRICE"), PlanMatchPattern.strictTableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))).isInstanceOf(AssertionError.class)).hasMessageStartingWith("Plan does not match");
    }

    @Test
    public void testStrictProjectExtraSymbols() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertMinimallyOptimizedPlan("SELECT discount, orderkey, 1 + orderkey FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY", (Object)"EXPRESSION"), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"EXPRESSION", (Object)PlanMatchPattern.expression("1 + ORDERKEY"), (Object)"ORDERKEY", (Object)PlanMatchPattern.expression("ORDERKEY")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))))).isInstanceOf(AssertionError.class)).hasMessageStartingWith("Plan does not match");
    }

    @Test
    public void testDuplicateAliases() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertPlan("SELECT o.orderkey FROM orders o, lineitem l WHERE l.orderkey = o.orderkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("LINEITEM_OK", "ORDERS_OK")), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders").withAlias("ORDERS_OK", PlanMatchPattern.columnReference("orders", "orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem").withAlias("ORDERS_OK", PlanMatchPattern.columnReference("lineitem", "orderkey"))))))).isInstanceOf(IllegalStateException.class)).hasMessageMatching(".*already bound to expression.*");
    }

    @Test
    public void testProjectLimitsScope() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertMinimallyOptimizedPlan("SELECT 1 + orderkey FROM lineitem", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"ORDERKEY"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"EXPRESSION", (Object)PlanMatchPattern.expression("CAST(1 AS bigint) + ORDERKEY")), PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey")))))).isInstanceOf(IllegalStateException.class)).hasMessageMatching("missing expression for alias .*");
    }

    private Session noJoinReordering() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build();
    }
}

