/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTablePartitioning;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.tree.FunctionCall;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTableScanNodePartitioning
extends BasePlanTest {
    public static final String MOCK_CATALOG = "mock_catalog";
    public static final String TEST_SCHEMA = "test_schema";
    public static final Session ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").setSystemProperty("use_table_scan_node_partitioning", "true").build();
    public static final Session DISABLE_PLAN_WITH_TABLE_NODE_PARTITIONING = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").setSystemProperty("use_table_scan_node_partitioning", "false").build();
    public static final int BUCKET_COUNT = 10;
    public static final String PARTITIONED_TABLE = "partitioned_table";
    public static final String SINGLE_BUCKET_TABLE = "single_bucket_table";
    public static final String FIXED_PARTITIONED_TABLE = "fixed_partitioned_table";
    public static final String UNPARTITIONED_TABLE = "unpartitioned_table";
    public static final ConnectorPartitioningHandle PARTITIONING_HANDLE = new ConnectorPartitioningHandle(){};
    public static final ConnectorPartitioningHandle SINGLE_BUCKET_HANDLE = new ConnectorPartitioningHandle(){};
    public static final ConnectorPartitioningHandle FIXED_PARTITIONING_HANDLE = new ConnectorPartitioningHandle(){};
    public static final ConnectorTableHandle CONNECTOR_PARTITIONED_TABLE_HANDLE = new MockConnectorTableHandle(new SchemaTableName("test_schema", "partitioned_table"));
    public static final ConnectorTableHandle CONNECTOR_SINGLE_BUCKET_TABLE_HANDLE = new MockConnectorTableHandle(new SchemaTableName("test_schema", "single_bucket_table"));
    public static final ConnectorTableHandle CONNECTOR_FIXED_PARTITIONED_TABLE_HANDLE = new MockConnectorTableHandle(new SchemaTableName("test_schema", "fixed_partitioned_table"));
    public static final ConnectorTableHandle CONNECTOR_UNPARTITIONED_TABLE_HANDLE = new MockConnectorTableHandle(new SchemaTableName("test_schema", "unpartitioned_table"));
    public static final TableHandle PARTITIONED_TABLE_HANDLE = TestTableScanNodePartitioning.tableHandle(CONNECTOR_PARTITIONED_TABLE_HANDLE);
    public static final TableHandle SINGLE_BUCKET_TABLE_HANDLE = TestTableScanNodePartitioning.tableHandle(CONNECTOR_SINGLE_BUCKET_TABLE_HANDLE);
    public static final TableHandle FIXED_PARTITIONED_TABLE_HANDLE = TestTableScanNodePartitioning.tableHandle(CONNECTOR_FIXED_PARTITIONED_TABLE_HANDLE);
    public static final TableHandle UNPARTITIONED_TABLE_HANDLE = TestTableScanNodePartitioning.tableHandle(CONNECTOR_UNPARTITIONED_TABLE_HANDLE);
    public static final String COLUMN_A = "column_a";
    public static final String COLUMN_B = "column_b";
    public static final ColumnHandle COLUMN_HANDLE_A = new MockConnectorColumnHandle("column_a", (Type)BigintType.BIGINT);
    public static final ColumnHandle COLUMN_HANDLE_B = new MockConnectorColumnHandle("column_b", (Type)VarcharType.VARCHAR);

    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog(MOCK_CATALOG).setSchema(TEST_SCHEMA);
        LocalQueryRunner queryRunner = LocalQueryRunner.builder((Session)sessionBuilder.build()).withNodeCountForStats(10).build();
        queryRunner.createCatalog(MOCK_CATALOG, (ConnectorFactory)TestTableScanNodePartitioning.createMockFactory(), (Map)ImmutableMap.of());
        queryRunner.getNodePartitioningManager().addPartitioningProvider(new CatalogName(MOCK_CATALOG), (ConnectorNodePartitioningProvider)new TestPartitioningProvider((InternalNodeManager)new InMemoryNodeManager()));
        return queryRunner;
    }

    @Test
    public void testEnablePlanWithTableNodePartitioning() {
        this.assertTableScanPlannedWithPartitioning(ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, PARTITIONED_TABLE, PARTITIONING_HANDLE);
    }

    @Test
    public void testDisablePlanWithTableNodePartitioning() {
        this.assertTableScanPlannedWithoutPartitioning(DISABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, PARTITIONED_TABLE);
    }

    @Test
    public void testTableScanWithoutConnectorPartitioning() {
        this.assertTableScanPlannedWithoutPartitioning(ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, UNPARTITIONED_TABLE);
    }

    @Test
    public void testTableScanWithFixedConnectorPartitioning() {
        this.assertTableScanPlannedWithPartitioning(DISABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, FIXED_PARTITIONED_TABLE, FIXED_PARTITIONING_HANDLE);
    }

    @Test
    public void testTableScanWithInsufficientBucketToTaskRatio() {
        this.assertTableScanPlannedWithoutPartitioning(ENABLE_PLAN_WITH_TABLE_NODE_PARTITIONING, SINGLE_BUCKET_TABLE);
    }

    void assertTableScanPlannedWithPartitioning(Session session, String table, ConnectorPartitioningHandle expectedPartitioning) {
        String query = "SELECT count(column_b) FROM " + table + " GROUP BY column_a";
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"COUNT", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"COUNT_PART"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"COUNT_PART", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"B"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan(table, (Map<String, String>)ImmutableMap.of((Object)"A", (Object)COLUMN_A, (Object)"B", (Object)COLUMN_B))))))));
        SubPlan subPlan = this.subplan(query, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false, session);
        Assertions.assertThat((List)subPlan.getAllFragments()).hasSize(2);
        Assertions.assertThat((Object)((PlanFragment)subPlan.getAllFragments().get(1)).getPartitioning().getConnectorHandle()).isEqualTo((Object)expectedPartitioning);
    }

    void assertTableScanPlannedWithoutPartitioning(Session session, String table) {
        String query = "SELECT count(column_b) FROM " + table + " GROUP BY column_a";
        this.assertDistributedPlan("SELECT count(column_b) FROM " + table + " GROUP BY column_a", session, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"COUNT", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"COUNT_PART"))), AggregationNode.Step.FINAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"COUNT_PART", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"B"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.tableScan(table, (Map<String, String>)ImmutableMap.of((Object)"A", (Object)COLUMN_A, (Object)"B", (Object)COLUMN_B)))))))));
        SubPlan subPlan = this.subplan(query, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, false, session);
        Assertions.assertThat((List)subPlan.getAllFragments()).hasSize(3);
        Assertions.assertThat((Object)((PlanFragment)subPlan.getAllFragments().get(2)).getPartitioning().getConnectorHandle()).isEqualTo((Object)SystemPartitioningHandle.SOURCE_DISTRIBUTION.getConnectorHandle());
    }

    public static MockConnectorFactory createMockFactory() {
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder();
        builder.withGetColumns(schemaTableName -> ImmutableList.of((Object)new ColumnMetadata(COLUMN_A, (Type)BigintType.BIGINT), (Object)new ColumnMetadata(COLUMN_B, (Type)VarcharType.VARCHAR))).withGetTableProperties((session, tableHandle) -> {
            if (tableHandle.equals(CONNECTOR_PARTITIONED_TABLE_HANDLE)) {
                return new ConnectorTableProperties(TupleDomain.all(), Optional.of(new ConnectorTablePartitioning(PARTITIONING_HANDLE, (List)ImmutableList.of((Object)COLUMN_HANDLE_A))), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
            }
            if (tableHandle.equals(CONNECTOR_SINGLE_BUCKET_TABLE_HANDLE)) {
                return new ConnectorTableProperties(TupleDomain.all(), Optional.of(new ConnectorTablePartitioning(SINGLE_BUCKET_HANDLE, (List)ImmutableList.of((Object)COLUMN_HANDLE_A))), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
            }
            if (tableHandle.equals(CONNECTOR_FIXED_PARTITIONED_TABLE_HANDLE)) {
                return new ConnectorTableProperties(TupleDomain.all(), Optional.of(new ConnectorTablePartitioning(FIXED_PARTITIONING_HANDLE, (List)ImmutableList.of((Object)COLUMN_HANDLE_A))), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
            }
            return new ConnectorTableProperties();
        });
        return builder.build();
    }

    private static TableHandle tableHandle(ConnectorTableHandle connectorTableHandle) {
        return new TableHandle(new CatalogName(MOCK_CATALOG), connectorTableHandle, (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
    }

    public static class TestPartitioningProvider
    implements ConnectorNodePartitioningProvider {
        private final InternalNodeManager nodeManager;

        public TestPartitioningProvider(InternalNodeManager nodeManager) {
            this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        }

        public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
            if (partitioningHandle.equals(PARTITIONING_HANDLE)) {
                return ConnectorBucketNodeMap.createBucketNodeMap((int)10);
            }
            if (partitioningHandle.equals(SINGLE_BUCKET_HANDLE)) {
                return ConnectorBucketNodeMap.createBucketNodeMap((int)1);
            }
            if (partitioningHandle.equals(FIXED_PARTITIONING_HANDLE)) {
                return ConnectorBucketNodeMap.createBucketNodeMap((List)ImmutableList.of((Object)this.nodeManager.getCurrentNode()));
            }
            throw new IllegalArgumentException();
        }

        public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
            throw new UnsupportedOperationException();
        }

        public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
            throw new UnsupportedOperationException();
        }
    }
}

