/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.Session;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import java.util.Arrays;
import java.util.Objects;
import org.testng.annotations.Test;

public class TestUnwrapCastInComparison
extends BasePlanTest {
    @Test
    public void testEquals() {
        this.testUnwrap("smallint", "a = DOUBLE '1'", "a = SMALLINT '1'");
        this.testUnwrap("bigint", "a = DOUBLE '1'", "a = BIGINT '1'");
        this.testUnwrap("smallint", "a = DOUBLE '1.1'", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a = DOUBLE '1.9'", "a IS NULL AND NULL");
        this.testUnwrap("bigint", "a = DOUBLE '1.1'", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a = DOUBLE '32766'", "a = SMALLINT '32766'");
        this.testUnwrap("smallint", "a = DOUBLE '32766.9'", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a = DOUBLE '32767'", "a = SMALLINT '32767'");
        this.testUnwrap("smallint", "a = DOUBLE '32768.1'", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a = DOUBLE '-32767'", "a = SMALLINT '-32767'");
        this.testUnwrap("smallint", "a = DOUBLE '-32767.9'", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a = DOUBLE '-32768'", "a = SMALLINT '-32768'");
        this.testUnwrap("smallint", "a = DOUBLE '-32768.1'", "a IS NULL AND NULL");
        this.testUnwrap("bigint", "a = DOUBLE '-18446744073709551616'", "a IS NULL AND NULL");
        this.testNoUnwrap("varchar(1)", "= CAST('abc' AS char(3))", "char(3)");
        this.testUnwrap("varchar(3)", "a = CAST('abc' AS char(3))", "a = 'abc'");
        this.testNoUnwrap("varchar(3)", "= CAST('ab' AS char(3))", "char(3)");
        this.testUnwrap("varchar(10)", "a = CAST('abc' AS char(3))", "CAST(a AS char(10)) = CAST('abc' AS char(10))");
        this.testUnwrap("varchar", "a = CAST('abc' AS char(3))", "CAST(a AS char(65536)) = CAST('abc' AS char(65536))");
        this.testNoUnwrap("varchar", String.format("= CAST('abc' AS char(%s))", 65536), "char(65536)");
    }

    @Test
    public void testNotEquals() {
        this.testUnwrap("smallint", "a <> DOUBLE '1'", "a <> SMALLINT '1'");
        this.testUnwrap("bigint", "a <> DOUBLE '1'", "a <> BIGINT '1'");
        this.testUnwrap("smallint", "a <> DOUBLE '1.1'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("smallint", "a <> DOUBLE '1.9'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("bigint", "a <> DOUBLE '1.1'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("smallint", "a <> DOUBLE '32766'", "a <> SMALLINT '32766'");
        this.testUnwrap("smallint", "a <> DOUBLE '32766.9'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("smallint", "a <> DOUBLE '32767'", "a <> SMALLINT '32767'");
        this.testUnwrap("smallint", "a <> DOUBLE '32768.1'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("bigint", "a <> DOUBLE '18446744073709551616'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("smallint", "a <> DOUBLE '-32767'", "a <> SMALLINT '-32767'");
        this.testUnwrap("smallint", "a <> DOUBLE '-32767.9'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("smallint", "a <> DOUBLE '-32768'", "a <> SMALLINT '-32768'");
        this.testUnwrap("smallint", "a <> DOUBLE '-32768.1'", "NOT (a IS NULL) OR NULL");
    }

    @Test
    public void testLessThan() {
        this.testUnwrap("smallint", "a < DOUBLE '1'", "a < SMALLINT '1'");
        this.testUnwrap("bigint", "a < DOUBLE '1'", "a < BIGINT '1'");
        this.testUnwrap("smallint", "a < DOUBLE '1.1'", "a <= SMALLINT '1'");
        this.testUnwrap("bigint", "a < DOUBLE '1.1'", "a <= BIGINT '1'");
        this.testUnwrap("smallint", "a < DOUBLE '1.9'", "a < SMALLINT '2'");
        this.testUnwrap("smallint", "a < DOUBLE '32766'", "a < SMALLINT '32766'");
        this.testUnwrap("smallint", "a < DOUBLE '32766.9'", "a < SMALLINT '32767'");
        this.testUnwrap("smallint", "a < DOUBLE '32767'", "a <> SMALLINT '32767'");
        this.testUnwrap("smallint", "a < DOUBLE '32768.1'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("smallint", "a < DOUBLE '-32767'", "a < SMALLINT '-32767'");
        this.testUnwrap("smallint", "a < DOUBLE '-32767.9'", "a = SMALLINT '-32768'");
        this.testUnwrap("smallint", "a < DOUBLE '-32768'", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a < DOUBLE '-32768.1'", "a IS NULL AND NULL");
        this.testUnwrap("bigint", "a < DOUBLE '-18446744073709551616'", "a IS NULL AND NULL");
    }

    @Test
    public void testLessThanOrEqual() {
        this.testUnwrap("smallint", "a <= DOUBLE '1'", "a <= SMALLINT '1'");
        this.testUnwrap("bigint", "a <= DOUBLE '1'", "a <= BIGINT '1'");
        this.testUnwrap("smallint", "a <= DOUBLE '1.1'", "a <= SMALLINT '1'");
        this.testUnwrap("bigint", "a <= DOUBLE '1.1'", "a <= BIGINT '1'");
        this.testUnwrap("smallint", "a <= DOUBLE '1.9'", "a < SMALLINT '2'");
        this.testUnwrap("smallint", "a <= DOUBLE '32766'", "a <= SMALLINT '32766'");
        this.testUnwrap("smallint", "a <= DOUBLE '32766.9'", "a < SMALLINT '32767'");
        this.testUnwrap("smallint", "a <= DOUBLE '32767'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("smallint", "a <= DOUBLE '32768.1'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("bigint", "a <= DOUBLE '18446744073709551616'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("smallint", "a <= DOUBLE '-32767'", "a <= SMALLINT '-32767'");
        this.testUnwrap("smallint", "a <= DOUBLE '-32767.9'", "a = SMALLINT '-32768'");
        this.testUnwrap("smallint", "a <= DOUBLE '-32768'", "a = SMALLINT '-32768'");
        this.testUnwrap("smallint", "a <= DOUBLE '-32768.1'", "a IS NULL AND NULL");
    }

    @Test
    public void testGreaterThan() {
        this.testUnwrap("smallint", "a > DOUBLE '1'", "a > SMALLINT '1'");
        this.testUnwrap("bigint", "a > DOUBLE '1'", "a > BIGINT '1'");
        this.testUnwrap("smallint", "a > DOUBLE '1.1'", "a > SMALLINT '1'");
        this.testUnwrap("smallint", "a > DOUBLE '1.9'", "a >= SMALLINT '2'");
        this.testUnwrap("bigint", "a > DOUBLE '1.9'", "a >= BIGINT '2'");
        this.testUnwrap("smallint", "a > DOUBLE '32766'", "a > SMALLINT '32766'");
        this.testUnwrap("smallint", "a > DOUBLE '32766.9'", "a = SMALLINT '32767'");
        this.testUnwrap("smallint", "a > DOUBLE '32767'", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a > DOUBLE '32768.1'", "a IS NULL AND NULL");
        this.testUnwrap("bigint", "a > DOUBLE '18446744073709551616'", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a > DOUBLE '-32767'", "a > SMALLINT '-32767'");
        this.testUnwrap("smallint", "a > DOUBLE '-32767.9'", "a > SMALLINT '-32768'");
        this.testUnwrap("smallint", "a > DOUBLE '-32768'", "a <> SMALLINT '-32768'");
        this.testUnwrap("smallint", "a > DOUBLE '-32768.1'", "NOT (a IS NULL) OR NULL");
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.testUnwrap("smallint", "a >= DOUBLE '1'", "a >= SMALLINT '1'");
        this.testUnwrap("bigint", "a >= DOUBLE '1'", "a >= BIGINT '1'");
        this.testUnwrap("smallint", "a >= DOUBLE '1.1'", "a > SMALLINT '1'");
        this.testUnwrap("bigint", "a >= DOUBLE '1.1'", "a > BIGINT '1'");
        this.testUnwrap("smallint", "a >= DOUBLE '1.9'", "a >= SMALLINT '2'");
        this.testUnwrap("smallint", "a >= DOUBLE '32766'", "a >= SMALLINT '32766'");
        this.testUnwrap("smallint", "a >= DOUBLE '32766.9'", "a = SMALLINT '32767'");
        this.testUnwrap("smallint", "a >= DOUBLE '32767'", "a = SMALLINT '32767'");
        this.testUnwrap("smallint", "a >= DOUBLE '32768.1'", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a >= DOUBLE '-32767'", "a >= SMALLINT '-32767'");
        this.testUnwrap("smallint", "a >= DOUBLE '-32767.9'", "a > SMALLINT '-32768' ");
        this.testUnwrap("smallint", "a >= DOUBLE '-32768'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("smallint", "a >= DOUBLE '-32768.1'", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("bigint", "a >= DOUBLE '-18446744073709551616'", "NOT (a IS NULL) OR NULL");
    }

    @Test
    public void testDistinctFrom() {
        this.testUnwrap("smallint", "a IS DISTINCT FROM DOUBLE '1'", "a IS DISTINCT FROM SMALLINT '1'");
        this.testUnwrap("bigint", "a IS DISTINCT FROM DOUBLE '1'", "a IS DISTINCT FROM BIGINT '1'");
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '1.1'");
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '1.9'");
        this.testRemoveFilter("bigint", "a IS DISTINCT FROM DOUBLE '1.9'");
        this.testUnwrap("smallint", "a IS DISTINCT FROM DOUBLE '32766'", "a IS DISTINCT FROM SMALLINT '32766'");
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '32766.9'");
        this.testUnwrap("smallint", "a IS DISTINCT FROM DOUBLE '32767'", "a IS DISTINCT FROM SMALLINT '32767'");
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '32768.1'");
        this.testRemoveFilter("bigint", "a IS DISTINCT FROM DOUBLE '18446744073709551616'");
        this.testUnwrap("smallint", "a IS DISTINCT FROM DOUBLE '-32767'", "a IS DISTINCT FROM SMALLINT '-32767'");
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '-32767.9'");
        this.testUnwrap("smallint", "a IS DISTINCT FROM DOUBLE '-32768'", "a IS DISTINCT FROM SMALLINT '-32768'");
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM DOUBLE '-32768.1'");
    }

    @Test
    public void testNull() {
        this.testUnwrap("smallint", "a = CAST(NULL AS DOUBLE)", "CAST(NULL AS BOOLEAN)");
        this.testUnwrap("bigint", "a = CAST(NULL AS DOUBLE)", "CAST(NULL AS BOOLEAN)");
        this.testUnwrap("smallint", "a <> CAST(NULL AS DOUBLE)", "CAST(NULL AS BOOLEAN)");
        this.testUnwrap("smallint", "a > CAST(NULL AS DOUBLE)", "CAST(NULL AS BOOLEAN)");
        this.testUnwrap("smallint", "a < CAST(NULL AS DOUBLE)", "CAST(NULL AS BOOLEAN)");
        this.testUnwrap("smallint", "a >= CAST(NULL AS DOUBLE)", "CAST(NULL AS BOOLEAN)");
        this.testUnwrap("smallint", "a <= CAST(NULL AS DOUBLE)", "CAST(NULL AS BOOLEAN)");
        this.testUnwrap("smallint", "a IS DISTINCT FROM CAST(NULL AS DOUBLE)", "NOT (CAST(a AS DOUBLE) IS NULL)");
        this.testUnwrap("bigint", "a IS DISTINCT FROM CAST(NULL AS DOUBLE)", "NOT (CAST(a AS DOUBLE) IS NULL)");
    }

    @Test
    public void testNaN() {
        this.testUnwrap("smallint", "a = nan()", "a IS NULL AND NULL");
        this.testUnwrap("bigint", "a = nan()", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a < nan()", "a IS NULL AND NULL");
        this.testUnwrap("smallint", "a <> nan()", "NOT (a IS NULL) OR NULL");
        this.testRemoveFilter("smallint", "a IS DISTINCT FROM nan()");
        this.testRemoveFilter("bigint", "a IS DISTINCT FROM nan()");
        this.testUnwrap("real", "a = nan()", "a IS NULL AND NULL");
        this.testUnwrap("real", "a < nan()", "a IS NULL AND NULL");
        this.testUnwrap("real", "a <> nan()", "NOT (a IS NULL) OR NULL");
        this.testUnwrap("real", "a IS DISTINCT FROM nan()", "a IS DISTINCT FROM CAST(nan() AS REAL)");
    }

    @Test
    public void smokeTests() {
        for (String type : Arrays.asList("SMALLINT", "INTEGER", "BIGINT", "REAL", "DOUBLE")) {
            this.testUnwrap("tinyint", String.format("a = %s '1'", type), "a = TINYINT '1'");
        }
        for (String type : Arrays.asList("INTEGER", "BIGINT", "REAL", "DOUBLE")) {
            this.testUnwrap("smallint", String.format("a = %s '1'", type), "a = SMALLINT '1'");
        }
        for (String type : Arrays.asList("BIGINT", "DOUBLE")) {
            this.testUnwrap("integer", String.format("a = %s '1'", type), "a = 1");
        }
        this.testUnwrap("real", "a = DOUBLE '1'", "a = REAL '1.0'");
    }

    @Test
    public void testTermOrder() {
        this.assertPlan("SELECT * FROM (VALUES REAL '1') t(a) WHERE DOUBLE '1' = a", PlanMatchPattern.output(PlanMatchPattern.filter("A = REAL '1.0'", PlanMatchPattern.values("A"))));
    }

    @Test
    public void testCastTimestampToTimestampWithTimeZone() {
        Session session = this.getQueryRunner().getDefaultSession();
        Session utcSession = TestUnwrapCastInComparison.withZone(session, TimeZoneKey.UTC_KEY);
        Session warsawSession = TestUnwrapCastInComparison.withZone(session, TimeZoneKey.getTimeZoneKey((String)"Europe/Warsaw"));
        Session losAngelesSession = TestUnwrapCastInComparison.withZone(session, TimeZoneKey.getTimeZoneKey((String)"America/Los_Angeles"));
        this.testUnwrap(utcSession, "timestamp(0)", "a > TIMESTAMP '2020-10-26 11:02:18 UTC'", "a > TIMESTAMP '2020-10-26 11:02:18'");
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-26 11:02:18 Europe/Warsaw'", "a > TIMESTAMP '2020-10-26 11:02:18'");
        this.testUnwrap(losAngelesSession, "timestamp(0)", "a > TIMESTAMP '2020-10-26 11:02:18 America/Los_Angeles'", "a > TIMESTAMP '2020-10-26 11:02:18'");
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-26 11:02:18 UTC'", "a > TIMESTAMP '2020-10-26 12:02:18'");
        this.testUnwrap(losAngelesSession, "timestamp(0)", "a > TIMESTAMP '2020-10-26 11:02:18 UTC'", "a > TIMESTAMP '2020-10-26 04:02:18'");
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-10-26 11:02:18.12 UTC'", "a > TIMESTAMP '2020-10-26 12:02:18.120000'");
        this.testUnwrap(losAngelesSession, "timestamp(6)", "a > TIMESTAMP '2020-10-26 11:02:18.12 UTC'", "a > TIMESTAMP '2020-10-26 04:02:18.120000'");
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-26 11:02:18.12 UTC'", "a > TIMESTAMP '2020-10-26 12:02:18.120000000'");
        this.testUnwrap(losAngelesSession, "timestamp(9)", "a > TIMESTAMP '2020-10-26 11:02:18.12 UTC'", "a > TIMESTAMP '2020-10-26 04:02:18.120000000'");
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-26 11:02:18.123456 UTC'", "a > TIMESTAMP '2020-10-26 12:02:18.123456000'");
        this.testUnwrap(losAngelesSession, "timestamp(9)", "a > TIMESTAMP '2020-10-26 11:02:18.123456 UTC'", "a > TIMESTAMP '2020-10-26 04:02:18.123456000'");
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-10-26 11:02:18.123456789321 UTC'", "a > TIMESTAMP '2020-10-26 12:02:18.123456789321'");
        this.testUnwrap(losAngelesSession, "timestamp(12)", "a > TIMESTAMP '2020-10-26 11:02:18.123456789321 UTC'", "a > TIMESTAMP '2020-10-26 04:02:18.123456789321'");
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-03-29 00:59:59 UTC'", "a > TIMESTAMP '2020-03-29 01:59:59'");
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-03-29 00:59:59.999 UTC'", "a > TIMESTAMP '2020-03-29 01:59:59.999'");
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-03-29 00:59:59.13 UTC'", "a > TIMESTAMP '2020-03-29 01:59:59.130000'");
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-03-29 00:59:59.999999 UTC'", "a > TIMESTAMP '2020-03-29 01:59:59.999999'");
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-03-29 00:59:59.999999999 UTC'", "a > TIMESTAMP '2020-03-29 01:59:59.999999999'");
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-03-29 00:59:59.999999999999 UTC'", "a > TIMESTAMP '2020-03-29 01:59:59.999999999999'");
        this.testNoUnwrap(warsawSession, "timestamp(0)", "> TIMESTAMP '2020-03-29 01:00:00 UTC'", "timestamp(0) with time zone");
        this.testNoUnwrap(warsawSession, "timestamp(3)", "> TIMESTAMP '2020-03-29 01:00:00.000 UTC'", "timestamp(3) with time zone");
        this.testNoUnwrap(warsawSession, "timestamp(6)", "> TIMESTAMP '2020-03-29 01:00:00.000000 UTC'", "timestamp(6) with time zone");
        this.testNoUnwrap(warsawSession, "timestamp(9)", "> TIMESTAMP '2020-03-29 01:00:00.000000000 UTC'", "timestamp(9) with time zone");
        this.testNoUnwrap(warsawSession, "timestamp(12)", "> TIMESTAMP '2020-03-29 01:00:00.000000000000 UTC'", "timestamp(12) with time zone");
        this.testNoUnwrap(warsawSession, "timestamp(0)", "> TIMESTAMP '2020-03-29 01:59:59 UTC'", "timestamp(0) with time zone");
        this.testNoUnwrap(warsawSession, "timestamp(3)", "> TIMESTAMP '2020-03-29 01:59:59.999 UTC'", "timestamp(3) with time zone");
        this.testNoUnwrap(warsawSession, "timestamp(6)", "> TIMESTAMP '2020-03-29 01:59:59.999999 UTC'", "timestamp(6) with time zone");
        this.testNoUnwrap(warsawSession, "timestamp(9)", "> TIMESTAMP '2020-03-29 01:59:59.999999999 UTC'", "timestamp(9) with time zone");
        this.testNoUnwrap(warsawSession, "timestamp(12)", "> TIMESTAMP '2020-03-29 01:59:59.999999999999 UTC'", "timestamp(12) with time zone");
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-03-29 02:00:00 UTC'", "a > TIMESTAMP '2020-03-29 04:00:00'");
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-03-29 02:00:00.000 UTC'", "a > TIMESTAMP '2020-03-29 04:00:00.000'");
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-03-29 02:00:00.000000 UTC'", "a > TIMESTAMP '2020-03-29 04:00:00.000000'");
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-03-29 02:00:00.000000000 UTC'", "a > TIMESTAMP '2020-03-29 04:00:00.000000000'");
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-03-29 02:00:00.000000000000 UTC'", "a > TIMESTAMP '2020-03-29 04:00:00.000000000000'");
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-25 00:59:59 UTC'", "a >= TIMESTAMP '2020-10-25 02:59:59'");
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-10-25 00:59:59.999 UTC'", "a >= TIMESTAMP '2020-10-25 02:59:59.999'");
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-10-25 00:59:59.999999 UTC'", "a >= TIMESTAMP '2020-10-25 02:59:59.999999'");
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-25 00:59:59.999999999 UTC'", "a >= TIMESTAMP '2020-10-25 02:59:59.999999999'");
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-10-25 00:59:59.999999999999 UTC'", "a >= TIMESTAMP '2020-10-25 02:59:59.999999999999'");
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-25 01:00:00 UTC'", "a > TIMESTAMP '2020-10-25 02:00:00'");
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-10-25 01:00:00.000 UTC'", "a > TIMESTAMP '2020-10-25 02:00:00.000'");
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-10-25 01:00:00.000000 UTC'", "a > TIMESTAMP '2020-10-25 02:00:00.000000'");
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-25 01:00:00.000000000 UTC'", "a > TIMESTAMP '2020-10-25 02:00:00.000000000'");
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-10-25 01:00:00.000000000000 UTC'", "a > TIMESTAMP '2020-10-25 02:00:00.000000000000'");
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-25 01:59:59 UTC'", "a > TIMESTAMP '2020-10-25 02:59:59'");
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-10-25 01:59:59.999 UTC'", "a > TIMESTAMP '2020-10-25 02:59:59.999'");
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-10-25 01:59:59.999999 UTC'", "a > TIMESTAMP '2020-10-25 02:59:59.999999'");
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-25 01:59:59.999999999 UTC'", "a > TIMESTAMP '2020-10-25 02:59:59.999999999'");
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-10-25 01:59:59.999999999999 UTC'", "a > TIMESTAMP '2020-10-25 02:59:59.999999999999'");
        this.testUnwrap(warsawSession, "timestamp(0)", "a > TIMESTAMP '2020-10-25 02:00:00 UTC'", "a > TIMESTAMP '2020-10-25 03:00:00'");
        this.testUnwrap(warsawSession, "timestamp(3)", "a > TIMESTAMP '2020-10-25 02:00:00.000 UTC'", "a > TIMESTAMP '2020-10-25 03:00:00.000'");
        this.testUnwrap(warsawSession, "timestamp(6)", "a > TIMESTAMP '2020-10-25 02:00:00.000000 UTC'", "a > TIMESTAMP '2020-10-25 03:00:00.000000'");
        this.testUnwrap(warsawSession, "timestamp(9)", "a > TIMESTAMP '2020-10-25 02:00:00.000000000 UTC'", "a > TIMESTAMP '2020-10-25 03:00:00.000000000'");
        this.testUnwrap(warsawSession, "timestamp(12)", "a > TIMESTAMP '2020-10-25 02:00:00.000000000000 UTC'", "a > TIMESTAMP '2020-10-25 03:00:00.000000000000'");
    }

    @Test
    public void testNoEffect() {
        this.testUnwrap("bigint", "a = DOUBLE '9007199254740992'", "CAST(a AS DOUBLE) = 9.007199254740992E15");
        this.testUnwrap("bigint", "a = DOUBLE '9223372036854775807'", "CAST(a AS DOUBLE) = 9.223372036854776E18");
        this.testUnwrap("bigint", "a = DOUBLE '-9007199254740992'", "CAST(a AS DOUBLE) = -9.007199254740992E15");
        this.testUnwrap("bigint", "a = DOUBLE '-9223372036854775807'", "CAST(a AS DOUBLE) = -9.223372036854776E18");
        this.testUnwrap("bigint", "a = REAL '8388608'", "CAST(a AS REAL) = REAL '8388608.0'");
        this.testUnwrap("bigint", "a = REAL '9223372036854775807'", "CAST(a AS REAL) = REAL '9.223372E18'");
        this.testUnwrap("bigint", "a = REAL '-8388608'", "CAST(a AS REAL) = REAL '-8388608.0'");
        this.testUnwrap("bigint", "a = REAL '-9223372036854775807'", "CAST(a AS REAL) = REAL '-9.223372E18'");
        this.testUnwrap("integer", "a = REAL '8388608'", "CAST(a AS REAL) = REAL '8388608.0'");
        this.testUnwrap("integer", "a = REAL '2147483647'", "CAST(a AS REAL) = REAL '2.14748365E9'");
        this.testUnwrap("integer", "a = REAL '-8388608'", "CAST(a AS REAL) = REAL '-8388608.0'");
        this.testUnwrap("integer", "a = REAL '-2147483647'", "CAST(a AS REAL) = REAL '-2.14748365E9'");
        this.testUnwrap("decimal(16)", "a = DOUBLE '1'", "CAST(a AS DOUBLE) = 1E0");
        this.testUnwrap("decimal(8)", "a = REAL '1'", "CAST(a AS REAL) = REAL '1.0'");
        this.testUnwrap("varchar", "CAST(a AS INTEGER) = INTEGER '1'", "CAST(a AS INTEGER) = 1");
        this.testUnwrap("double", "CAST(a AS INTEGER) = INTEGER '1'", "CAST(a AS INTEGER) = 1");
    }

    private void testNoUnwrap(String inputType, String inputPredicate, String expectedCastType) {
        this.testNoUnwrap(this.getQueryRunner().getDefaultSession(), inputType, inputPredicate, expectedCastType);
    }

    private void testNoUnwrap(Session session, String inputType, String inputPredicate, String expectedCastType) {
        String sql = String.format("SELECT * FROM (VALUES CAST(NULL AS %s)) t(a) WHERE a %s", inputType, inputPredicate);
        try {
            this.assertPlan(sql, session, PlanMatchPattern.output(PlanMatchPattern.filter(String.format("CAST(a AS %s) %s", expectedCastType, inputPredicate), PlanMatchPattern.values("a"))));
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }

    private void testRemoveFilter(String inputType, String inputPredicate) {
        String sql = String.format("SELECT * FROM (VALUES CAST(NULL AS %s)) t(a) WHERE %s", inputType, inputPredicate);
        try {
            this.assertPlan(sql, PlanMatchPattern.output(PlanMatchPattern.values("a")));
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }

    private void testUnwrap(String inputType, String inputPredicate, String expectedPredicate) {
        this.testUnwrap(this.getQueryRunner().getDefaultSession(), inputType, inputPredicate, expectedPredicate);
    }

    private void testUnwrap(Session session, String inputType, String inputPredicate, String expectedPredicate) {
        String sql = String.format("SELECT * FROM (VALUES CAST(NULL AS %s)) t(a) WHERE %s", inputType, inputPredicate);
        try {
            this.assertPlan(sql, session, PlanMatchPattern.output(PlanMatchPattern.filter(expectedPredicate, PlanMatchPattern.values("a"))));
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }

    private static Session withZone(Session session, TimeZoneKey timeZoneKey) {
        return Session.builder((Session)Objects.requireNonNull(session, "session is null")).setTimeZoneKey(Objects.requireNonNull(timeZoneKey, "timeZoneKey is null")).build();
    }
}

