/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.PlannerContext;
import io.trino.type.InternalTypeManager;
import java.util.Optional;

public final class TestingPlannerContext {
    public static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().build();

    private TestingPlannerContext() {
    }

    public static Builder plannerContextBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<Metadata> metadata = Optional.empty();

        private Builder() {
        }

        public Builder withMetadata(Metadata metadata) {
            this.metadata = Optional.of(metadata);
            return this;
        }

        public PlannerContext build() {
            return new PlannerContext(this.metadata.orElseGet(MetadataManager::createTestMetadataManager), new TypeOperators(), (BlockEncodingSerde)new InternalBlockEncodingSerde(new BlockEncodingManager(), InternalTypeManager.TESTING_TYPE_MANAGER), InternalTypeManager.TESTING_TYPE_MANAGER);
        }
    }
}

