/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanOptimizers;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.UnaliasSymbolReferences;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class BasePlanTest {
    private final Map<String, String> sessionProperties;
    private LocalQueryRunner queryRunner;

    public BasePlanTest() {
        this((Map<String, String>)ImmutableMap.of());
    }

    public BasePlanTest(Map<String, String> sessionProperties) {
        this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
    }

    protected LocalQueryRunner createLocalQueryRunner() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("task_concurrency", "1");
        this.sessionProperties.forEach((arg_0, arg_1) -> ((Session.SessionBuilder)sessionBuilder).setSystemProperty(arg_0, arg_1));
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());
        queryRunner.createCatalog((String)queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return queryRunner;
    }

    @BeforeClass
    public final void initPlanTest() {
        this.queryRunner = this.createLocalQueryRunner();
    }

    @AfterClass(alwaysRun=true)
    public final void destroyPlanTest() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    protected CatalogName getCurrentConnectorId() {
        return (CatalogName)((Optional)this.queryRunner.inTransaction(transactionSession -> this.queryRunner.getMetadata().getCatalogHandle(transactionSession, (String)transactionSession.getCatalog().get()))).get();
    }

    protected LocalQueryRunner getQueryRunner() {
        return this.queryRunner;
    }

    protected void assertPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, pattern);
    }

    protected void assertPlan(@Language(value="SQL") String sql, Session session, PlanMatchPattern pattern) {
        this.assertPlanWithSession(sql, session, true, pattern);
    }

    protected void assertPlan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern) {
        List optimizers = this.queryRunner.getPlanOptimizers(true);
        this.assertPlan(sql, stage, pattern, optimizers);
    }

    protected void assertPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern, List<PlanOptimizer> optimizers) {
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED, pattern, optimizers);
    }

    protected void assertPlan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern, Predicate<PlanOptimizer> optimizerPredicate) {
        List<PlanOptimizer> optimizers = this.queryRunner.getPlanOptimizers(true).stream().filter(optimizerPredicate).collect(Collectors.toList());
        this.assertPlan(sql, stage, pattern, optimizers);
    }

    protected void assertPlan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern, List<PlanOptimizer> optimizers) {
        this.queryRunner.inTransaction(transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, optimizers, stage, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }

    protected void assertDistributedPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        this.assertDistributedPlan(sql, this.getQueryRunner().getDefaultSession(), pattern);
    }

    protected void assertDistributedPlan(@Language(value="SQL") String sql, Session session, PlanMatchPattern pattern) {
        this.assertPlanWithSession(sql, session, false, pattern);
    }

    protected void assertMinimallyOptimizedPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(this.getQueryRunner().getMetadata()), (Object)new IterativeOptimizer(this.queryRunner.getMetadata(), new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), (Set)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).addAll((Iterable)PlanOptimizers.columnPruningRules((Metadata)this.getQueryRunner().getMetadata())).build()));
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED, pattern, (List<PlanOptimizer>)optimizers);
    }

    protected void assertPlanWithSession(@Language(value="SQL") String sql, Session session, boolean forceSingleNode, PlanMatchPattern pattern) {
        this.queryRunner.inTransaction(session, transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, forceSingleNode, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }

    protected void assertPlanWithSession(@Language(value="SQL") String sql, Session session, boolean forceSingleNode, PlanMatchPattern pattern, Consumer<Plan> planValidator) {
        this.queryRunner.inTransaction(session, transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, forceSingleNode, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            planValidator.accept(actualPlan);
            return null;
        });
    }

    protected Plan plan(@Language(value="SQL") String sql) {
        return this.plan(sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED);
    }

    protected Plan plan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage) {
        return this.plan(sql, stage, true);
    }

    protected Plan plan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, boolean forceSingleNode) {
        try {
            return (Plan)this.queryRunner.inTransaction(transactionSession -> this.queryRunner.createPlan(transactionSession, sql, stage, forceSingleNode, WarningCollector.NOOP));
        }
        catch (RuntimeException e) {
            throw new AssertionError("Planning failed for SQL: " + sql, e);
        }
    }

    protected SubPlan subplan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, boolean forceSingleNode) {
        return this.subplan(sql, stage, forceSingleNode, this.getQueryRunner().getDefaultSession());
    }

    protected SubPlan subplan(@Language(value="SQL") String sql, LogicalPlanner.Stage stage, boolean forceSingleNode, Session session) {
        try {
            return (SubPlan)this.queryRunner.inTransaction(session, transactionSession -> {
                Plan plan = this.queryRunner.createPlan(transactionSession, sql, stage, forceSingleNode, WarningCollector.NOOP);
                return this.queryRunner.createSubPlans(transactionSession, plan, forceSingleNode);
            });
        }
        catch (RuntimeException e) {
            throw new AssertionError("Planning failed for SQL: " + sql, e);
        }
    }
}

