/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableMetadata;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Objects;

final class IndexSourceMatcher
implements Matcher {
    private final String expectedTableName;

    public IndexSourceMatcher(String expectedTableName) {
        this.expectedTableName = Objects.requireNonNull(expectedTableName, "expectedTableName is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof IndexSourceNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        IndexSourceNode indexSourceNode = (IndexSourceNode)node;
        TableMetadata tableMetadata = metadata.getTableMetadata(session, indexSourceNode.getTableHandle());
        String actualTableName = tableMetadata.getTable().getTableName();
        if (!this.expectedTableName.equalsIgnoreCase(actualTableName)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("expectedTableName", (Object)this.expectedTableName).toString();
    }
}

