/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.cost.CachingCostProvider;
import io.trino.cost.CachingStatsProvider;
import io.trino.cost.CostComparator;
import io.trino.cost.CostProvider;
import io.trino.cost.PlanCostEstimate;
import io.trino.cost.StatsProvider;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ReorderJoins;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJoinEnumerator {
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void setUp() {
        this.queryRunner = LocalQueryRunner.create((Session)TestingSession.testSessionBuilder().build());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    @Test
    public void testGeneratePartitions() {
        Assert.assertEquals((Set)ReorderJoins.JoinEnumerator.generatePartitions((int)4), (Set)ImmutableSet.of((Object)ImmutableSet.of((Object)0), (Object)ImmutableSet.of((Object)0, (Object)1), (Object)ImmutableSet.of((Object)0, (Object)2), (Object)ImmutableSet.of((Object)0, (Object)3), (Object)ImmutableSet.of((Object)0, (Object)1, (Object)2), (Object)ImmutableSet.of((Object)0, (Object)1, (Object)3), (Object[])new ImmutableSet[]{ImmutableSet.of((Object)0, (Object)2, (Object)3)}));
        Assert.assertEquals((Set)ReorderJoins.JoinEnumerator.generatePartitions((int)3), (Set)ImmutableSet.of((Object)ImmutableSet.of((Object)0), (Object)ImmutableSet.of((Object)0, (Object)1), (Object)ImmutableSet.of((Object)0, (Object)2)));
    }

    @Test
    public void testDoesNotCreateJoinWhenPartitionedOnCrossJoin() {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = new PlanBuilder(idAllocator, this.queryRunner.getMetadata(), this.queryRunner.getDefaultSession());
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        ReorderJoins.MultiJoinNode multiJoinNode = new ReorderJoins.MultiJoinNode(new LinkedHashSet(ImmutableList.of((Object)p.values(a1), (Object)p.values(b1))), (Expression)BooleanLiteral.TRUE_LITERAL, (List)ImmutableList.of((Object)a1, (Object)b1), false);
        ReorderJoins.JoinEnumerator joinEnumerator = new ReorderJoins.JoinEnumerator(this.queryRunner.getMetadata(), new CostComparator(1.0, 1.0, 1.0), multiJoinNode.getFilter(), this.createContext());
        ReorderJoins.JoinEnumerationResult actual = joinEnumerator.createJoinAccordingToPartitioning(multiJoinNode.getSources(), multiJoinNode.getOutputSymbols(), (Set)ImmutableSet.of((Object)0));
        Assert.assertFalse((boolean)actual.getPlanNode().isPresent());
        Assert.assertEquals((Object)actual.getCost(), (Object)PlanCostEstimate.infinite());
    }

    private Rule.Context createContext() {
        final PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        final SymbolAllocator symbolAllocator = new SymbolAllocator();
        final CachingStatsProvider statsProvider = new CachingStatsProvider(this.queryRunner.getStatsCalculator(), Optional.empty(), Lookup.noLookup(), this.queryRunner.getDefaultSession(), symbolAllocator.getTypes());
        final CachingCostProvider costProvider = new CachingCostProvider(this.queryRunner.getCostCalculator(), (StatsProvider)statsProvider, Optional.empty(), this.queryRunner.getDefaultSession(), symbolAllocator.getTypes());
        return new Rule.Context(){

            public Lookup getLookup() {
                return Lookup.noLookup();
            }

            public PlanNodeIdAllocator getIdAllocator() {
                return planNodeIdAllocator;
            }

            public SymbolAllocator getSymbolAllocator() {
                return symbolAllocator;
            }

            public Session getSession() {
                return TestJoinEnumerator.this.queryRunner.getDefaultSession();
            }

            public StatsProvider getStatsProvider() {
                return statsProvider;
            }

            public CostProvider getCostProvider() {
                return costProvider;
            }

            public void checkTimeoutNotExhausted() {
            }

            public WarningCollector getWarningCollector() {
                return WarningCollector.NOOP;
            }
        };
    }
}

