/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.OptimizeDuplicateInsensitiveJoins;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestOptimizeDuplicateInsensitiveJoins
extends BaseRuleTest {
    private String rand;

    public TestOptimizeDuplicateInsensitiveJoins() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setup() {
        this.rand = "\"" + this.tester().getMetadata().resolveFunction(this.tester().getSession(), QualifiedName.of((String)"rand"), (List)ImmutableList.of()).toQualifiedName() + "\"()";
    }

    @Test
    public void testNoAggregation() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testAggregation() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            Symbol output = p.symbol("out");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).addAggregation(output, PlanBuilder.expression("count()"), (List<Type>)ImmutableList.of()).source((PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.values(symbolB), new JoinNode.EquiJoinClause[0])));
        }).doesNotFire();
    }

    @Test
    public void testEmptyAggregation() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).source((PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.values(symbolB), new JoinNode.EquiJoinClause[0])));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.values("A"), PlanMatchPattern.values("B")).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates)));
    }

    @Test
    public void testNestedJoins() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            Symbol symbolC = p.symbol("c");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).source((PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{symbolB}), (PlanNode)p.filter(PlanBuilder.expression("b > 10"), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolB), (PlanNode)p.values(symbolC), new JoinNode.EquiJoinClause[0]))), new JoinNode.EquiJoinClause[0])));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.values("A"), PlanMatchPattern.project(PlanMatchPattern.filter("B > 10", PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.values("B"), PlanMatchPattern.values("C")).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates)))).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates)));
    }

    @Test
    public void testNondeterministicJoins() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            Symbol symbolC = p.symbol("c");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).source((PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolB), (PlanNode)p.values(symbolC), new JoinNode.EquiJoinClause[0]), PlanBuilder.expression("b > " + this.rand), new JoinNode.EquiJoinClause[0])));
        }).matches(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("B > rand()"), PlanMatchPattern.values("A"), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), PlanMatchPattern.values("B"), PlanMatchPattern.values("C")).with(JoinNode.class, Predicate.not(JoinNode::isMaySkipOutputDuplicates))).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates)));
    }

    @Test
    public void testNondeterministicFilter() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).source((PlanNode)p.filter(PlanBuilder.expression("b > " + this.rand), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.values(symbolB), new JoinNode.EquiJoinClause[0]))));
        }).doesNotFire();
    }

    @Test
    public void testNondeterministicProjection() {
        this.tester().assertThat((Rule<?>)new OptimizeDuplicateInsensitiveJoins(this.tester().getMetadata())).on(p -> {
            Symbol symbolA = p.symbol("a");
            Symbol symbolB = p.symbol("b");
            Symbol symbolC = p.symbol("c");
            return p.aggregation(a -> a.singleGroupingSet(symbolA).source((PlanNode)p.project(Assignments.builder().putIdentity(symbolA).put(symbolC, PlanBuilder.expression(this.rand)).build(), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(symbolA), (PlanNode)p.values(symbolB), new JoinNode.EquiJoinClause[0]))));
        }).doesNotFire();
    }
}

